/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.glassfish.gmbal.util;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenericConstructor<T> {
    private final Object lock = new Object();
    private String typeName;
    private Class<T> resultType;
    private Class<?> type;
    private Class<?>[] signature;
    private Constructor constructor;

    public GenericConstructor(Class<T> clazz, String string, Class<?> ... classArray) {
        this.resultType = clazz;
        this.typeName = string;
        this.signature = (Class[])classArray.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConstructor() {
        Object object = this.lock;
        synchronized (object) {
            if (this.type == null || this.constructor == null) {
                try {
                    this.type = Class.forName(this.typeName);
                    this.constructor = AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Constructor run() throws Exception {
                            Object object = GenericConstructor.this.lock;
                            synchronized (object) {
                                return GenericConstructor.this.type.getDeclaredConstructor(GenericConstructor.this.signature);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    Logger.getLogger("com.sun.org.glassfish.gmbal.util").log(Level.FINE, "Failure in getConstructor", exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized T create(Object ... objectArray) {
        Object object = this.lock;
        synchronized (object) {
            T t = null;
            for (int i = 0; i <= 1; ++i) {
                this.getConstructor();
                if (this.constructor == null) break;
                try {
                    t = this.resultType.cast(this.constructor.newInstance(objectArray));
                    break;
                }
                catch (Exception exception) {
                    this.constructor = null;
                    Logger.getLogger("com.sun.org.glassfish.gmbal.util").log(Level.WARNING, "Error invoking constructor", exception);
                    continue;
                }
            }
            return t;
        }
    }
}

