/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.org.jvnet.mimepull;

import com.sun.xml.internal.org.jvnet.mimepull.Chunk;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEMessage;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEPart;
import java.io.IOException;
import java.io.InputStream;

final class ChunkInputStream
extends InputStream {
    Chunk current;
    int offset;
    int len;
    final MIMEMessage msg;
    final MIMEPart part;
    byte[] buf;

    public ChunkInputStream(MIMEMessage mIMEMessage, MIMEPart mIMEPart, Chunk chunk) {
        this.current = chunk;
        this.len = this.current.data.size();
        this.buf = this.current.data.read();
        this.msg = mIMEMessage;
        this.part = mIMEPart;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.fetch()) {
            return -1;
        }
        n2 = Math.min(n2, this.len - this.offset);
        System.arraycopy(this.buf, this.offset, byArray, n, n2);
        return n2;
    }

    @Override
    public int read() throws IOException {
        if (!this.fetch()) {
            return -1;
        }
        return this.buf[this.offset++] & 0xFF;
    }

    private boolean fetch() {
        if (this.current == null) {
            throw new IllegalStateException("Stream already closed");
        }
        while (this.offset == this.len) {
            while (!this.part.parsed && this.current.next == null) {
                this.msg.makeProgress();
            }
            this.current = this.current.next;
            if (this.current == null) {
                return false;
            }
            this.offset = 0;
            this.buf = this.current.data.read();
            this.len = this.current.data.size();
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.current = null;
    }
}

