var Newpart = function(duration, startTime, endTime){
  PartBase.call(this, duration, startTime, endTime);
}

Newpart.prototype = PartBase.prototype.inheritance();

Newpart.prototype.initScene = function() {

  this.scene = new THREE.Scene();
  this.camera = new THREE.PerspectiveCamera();
  this.camera.position.z = 200;
  //this.camera = new THREE.PerspectiveCamera(45, window.innerWidth / window.innerHeight, 1, 500);
	//this.camera.position.set(0, 0, 100);
	//this.camera.lookAt(new THREE.Vector3(0, 0, 0));
  
  this.scene.add(this.camera);
  this.objs = new THREE.Object3D();
    
  this.createLights();
//  this.createObjects();
  this.createRestOfCrowd();
  var material = new THREE.MeshPhongMaterial({
		color : 0x483D8B,
		ambient : 0x483D8B,
		emissive : 0x5D478B,
		specular : 0x5D478B
	});

  // var testperson = this.createOnePerson(0, -150, 17, material, 0, false);
  // for(var i = 0; i<testperson.length; i++) {
    // this.objs.add(testperson[i]);
  // }
  //this.createRestOfCrowd();
  this.createBackground();
  this.createBars();
  this.createPeople(material);
  this.scene.add(this.objs);

  //some min and max values
  this.minX = -TDEMO.width/2;
  this.maxX = TDEMO.width/2;
  this.minY = -TDEMO.height/2;
  this.maxY = TDEMO.height/2;
  this.rtt = new THREE.WebGLRenderTarget(1024, 1024);
  
  this.preScene = new THREE.Scene();
  this.preCamera = new THREE.OrthographicCamera(this.minX, this.maxX, this.maxY, this.minY);
  this.preCamera.position.z = 1;
  this.preScene.add(this.preCamera);
  
  this.createPostScene();
  
  this.swipeSpeed = 0.01;
  
  //feidaukset
  this.blinks = {
    fadeIn : {t : this.startTime+1.0, done : false},
    
    close1 : {t : 65*TDEMO.spbar, done : false},
    open2 : {t : 65*TDEMO.spbar+2, done : false},
  }

} 

//prepare function that is called before first rendering
Newpart.prototype.prepare = function(elapsedTime, rtt){
  this.startTime = elapsedTime;
  this.rtt2 = rtt;
  this.uniformsSwipe =  {
    angle : {type : "f", value: -2.0},
    scene1 : {type : "t", value: this.rtt2},
    scene2 : {type : "t", value: this.rtt},
    resolution : {type : "v2", value: new THREE.Vector2(TDEMO.width, TDEMO.height)},
  };

  this.swipeMaterial = new THREE.ShaderMaterial({
      uniforms: this.uniformsSwipe,
      vertexShader: document.getElementById( 'textured_vertex' ).textContent,
      fragmentShader: document.getElementById( 'swipe').textContent,
  });
  
  this.prePlane = new THREE.Mesh(new THREE.PlaneGeometry(TDEMO.width, TDEMO.height), this.swipeMaterial);
  this.preScene.add(this.prePlane);
}

Newpart.prototype.render = function(elapsedTime){
  if(!this.blinks.fadeIn.done){
    TDEMO.parts[TDEMO.currentPart-1].finish(elapsedTime, this.rtt2);
    TDEMO.renderer.render(this.scene, this.camera, this.rtt);
    TDEMO.renderer.render(this.preScene, this.preCamera);
  }
  else{
    TDEMO.renderer.render(this.scene, this.camera, this.rtt);
    TDEMO.renderer.render(this.postScene, this.postCamera);
  }
}

Newpart.prototype.finish = function(elapsedTime, rtt){
  this.animate(elapsedTime);
  TDEMO.renderer.render(this.scene, this.camera, rtt);
}

Newpart.prototype.animate = function(elapsedTime){

  if(!this.blinks.fadeIn.done && elapsedTime >= this.blinks.fadeIn.t){
    this.uniformsSwipe.angle.value += this.swipeSpeed;
    TDEMO.parts[TDEMO.currentPart-1].animate(elapsedTime);
    if(this.uniformsSwipe.angle.value >= 0.5){
      this.blinks.fadeIn.done = true;
      document.getElementById("greets").style.display = "none";
    }
  }
  if(!this.blinks.close1.done && elapsedTime >= this.blinks.close1.t) {
    this.uniformsBlink.phase.value -= 0.1;
    
    if(this.uniformsBlink.phase.value <= -2){
      this.uniformsBlink.phase.value = -2.0;
      this.blinks.close1.done = true;
      this.addCrowd();
    }
  }
  else if(!this.blinks.open2.done && elapsedTime >= this.blinks.open2.t){
    this.uniformsBlink.phase.value += 0.05;
    
    if(this.uniformsBlink.phase.value >= 2){
      this.uniformsBlink.phase.value = 2.0;
      this.blinks.open2.done = true;
    }
  }
    
  this.rotate(elapsedTime);
  this.zoom(elapsedTime);
  this.riseBars(elapsedTime);
  this.changeLights(elapsedTime);
  this.moveClose(elapsedTime);
}

Newpart.prototype.createPostScene = function(){
  //Silmien räpyttely
  this.postScene = new THREE.Scene();
  this.postCamera = new THREE.OrthographicCamera(this.minX, this.maxX, this.maxY, this.minY);
  this.postCamera.position.z = 1;
  this.postScene.add(this.postCamera);
  
  this.uniformsBlink =  {
    phase : {type : "f", value: 2.0},
    resolution : {type : "v2", value: new THREE.Vector2(TDEMO.width, TDEMO.height)},
    texture : {type : "t", value: this.rtt}
  };

  this.blinkMaterial = new THREE.ShaderMaterial({
      uniforms: this.uniformsBlink,
      vertexShader: document.getElementById( 'textured_vertex' ).textContent,
      fragmentShader: document.getElementById( 'blink').textContent
  });
  
  this.plane = new THREE.Mesh(new THREE.PlaneGeometry(TDEMO.width, TDEMO.height), this.blinkMaterial);
  this.postScene.add(this.plane);
}


Newpart.prototype.moveClose = function(elapsedTime) {
//  if(elapsedTime > 15*TDEMO.spbar ) {
  if(elapsedTime > 63*TDEMO.spbar ) {
    if(this.boy[1].position.x > this.girl[1].position.x) {
      for(var i = 0; i<this.girl.length; i++) {
        this.girl[i].position.x+=0.2;
        this.boy[i].position.x-=0.2;
      }
    }
    
    // if(this.boy[1].position.z > this.girl[1].position.z) {
      // for(var i = 0; i<2; i++) {
        // this.girl[i].position.z+=0.2;
        // this.boy[i].position.z-=0.2;
      // }
    // }
  }
}

Newpart.prototype.rotate = function(elapsedTime) {
  this.objs.rotation.y += 1/150;
}

Newpart.prototype.riseBars = function(elapsedTime) {
  //if(elapsedTime > 14*TDEMO.spbar) {
  if(elapsedTime > 62*TDEMO.spbar) {
    for(var i=0; i<this.bars.length;i++) {
      this.bars[i].position.y += 1;
    }
  }
}

Newpart.prototype.zoom = function(elapsedTime) {
    if(elapsedTime > 51*TDEMO.spbar && elapsedTime < 53*TDEMO.spbar) {
      this.camera.position.z += 0.2;
      this.camera.position.y += 0.2;
    } else if(elapsedTime >= 54*TDEMO.spbar && elapsedTime < 55*TDEMO.spbar) {
      this.camera.position.z += 0.1;
      this.camera.position.y += 0.1;
    } else if(elapsedTime > 55*TDEMO.spbar && elapsedTime < 57*TDEMO.spbar) {
      this.camera.position.z -= 0.2;
      this.camera.position.y -= 0.2;
    } else if(elapsedTime > 60*TDEMO.spbar && elapsedTime < 61*TDEMO.spbar) {
      this.camera.position.z -= 0.1;
      this.camera.position.y -= 0.1;
    }
}

Newpart.prototype.changeLights = function(elapsedTime) {
  // if(elapsedTime > 3*TDEMO.spbar && elapsedTime < 5*TDEMO.spbar) {
  // //if(elapsedTime > 62*TDEMO.spbar && elapsedTime < 14*TDEMO.spbar) {
    // //tee valoille jotain
  // } else if(elapsedTime >= 6*TDEMO.spbar && elapsedTime < 7*TDEMO.spbar) {

  // } else if(elapsedTime > 7*TDEMO.spbar && elapsedTime < 9*TDEMO.spbar) {

  // } else 
//  if(elapsedTime >=62*TDEMO.spbar) {
  // if(elapsedTime >=15*TDEMO.spbar) {

    // if (this.endlight.intensity <= 1) {
      // this.endlight.intensity += 0.003;
      // this.endlight2.intensity += 0.003;
    // }
    
    // if(this.pointLight2.intensity > 0) {
      // this.pointLight2.intensity -= 0.02;
      // this.pointLight3.intensity -= 0.02;

    // }
  // }
}

Newpart.prototype.createLights = function() {
	this.pointLight = new THREE.PointLight(0x8F8FBC);
	this.pointLight.position.set(500, 0, 100);

	this.pointLight2 = new THREE.PointLight(0x8F0000);
	this.pointLight.position.set(-100, 100, 50);

	this.pointLight3 = new THREE.PointLight(0x008FBC);
	this.pointLight3.position.set(-100, 50, 30);

	this.endlight2 = new THREE.PointLight(0x80800);
	this.endlight2.position.set(500, 0, 70);
  this.endlight2.intensity = 0;

  
	this.scene.add(this.pointLight);
  this.scene.add(this.pointLight2);
	this.scene.add(this.pointLight3);

}

Newpart.prototype.createBars = function() {
  var material = new THREE.MeshPhongMaterial({
		color : 0x000000,
		ambient : 0x1B1B2B,
		emissive : 0x1D1D27,
		specular : 0x1D1D27
	});

  var barsCount = 23;
  var dist = 122;
  this.bars = [];
  
  for(var i = 0; i<barsCount; i++){    
    var bar = new THREE.Mesh( new THREE.CylinderGeometry( 2, 2, 300, 32 ), material );
    bar.position.y = 75;
    bar.position.x = dist;
    this.bars.push(bar);
    this.objs.add(bar);
    dist -= 12;
  }
}

Newpart.prototype.createPeople = function(material) {
  var girlmaterial = new THREE.MeshPhongMaterial({
		color : 0x480000,
		ambient : 0x480000,
		emissive : 0x5D478B,
		specular : 0x5D478B
	});

  var boymaterial = new THREE.MeshPhongMaterial({
		color : 0x00008B,
		ambient : 0x00008B,
		emissive : 0x5D478B,
		specular : 0x5D478B
	});


  this.boy = [];
  this.girl = [];

  var head = new THREE.Mesh(new THREE.SphereGeometry(14, 32, 32), girlmaterial);
  var body = new THREE.Mesh( new THREE.CylinderGeometry( 7, 20, 60, 32 ), girlmaterial );    

  var fist1 = new THREE.Mesh(new THREE.SphereGeometry(5, 32, 32), girlmaterial);
  var fist2 = new THREE.Mesh(new THREE.SphereGeometry(5, 32, 32), girlmaterial);

  
	head.position.set(-45, -5, -20);		
  body.position.set(-45, -45, -20);
  
  fist1.position.set(-32, -25, 0);
  fist2.position.set(-57, -25, 0);
  
  this.girl.push(head);
  this.girl.push(body);

  this.girl.push(fist1);
  this.girl.push(fist2);

  this.objs.add(head);
  this.objs.add(body);

  this.objs.add(fist1);
  this.objs.add(fist2);

  
  var head2 = new THREE.Mesh(new THREE.SphereGeometry(14, 32, 32), boymaterial);
  var body2 = new THREE.Mesh( new THREE.CylinderGeometry( 9, 13, 60, 32 ), boymaterial );    
  
	head2.position.set(15, -5, 20);		
  body2.position.set(15, -45, 20);
	// head2.position.set(15, -80, 20);		
  // body2.position.set(15, -120, 20);

  
  var fist3 = new THREE.Mesh(new THREE.SphereGeometry(5, 32, 32), boymaterial);
  var fist4 = new THREE.Mesh(new THREE.SphereGeometry(5, 32, 32), boymaterial);
  fist3.position.set(28, -25, 0);
  fist4.position.set(2, -25, 0);
  // fist3.position.set(28, -100, 0);
  // fist4.position.set(2, -100, 0);
  

  this.boy.push(head2);
  this.boy.push(body2);
  this.boy.push(fist3);
  this.boy.push(fist4);

  this.objs.add(head2);
  this.objs.add(body2);
  this.objs.add(fist3);
  this.objs.add(fist4);
}

Newpart.prototype.createBackground = function() {
  var skyMaterial = new THREE.MeshLambertMaterial({
    color : 0x777777,
    ambient : 0x777777,
    side: THREE.BackSide
  });
  
  this.room = new THREE.Mesh(new THREE.BoxGeometry(300, 300, 400), skyMaterial);
  this.room.position.y = 75;
  this.objs.add(this.room);
  
}


Newpart.prototype.createRestOfCrowd = function() {
  var material = new THREE.MeshPhongMaterial({
		color : 0x483D8B,
		ambient : 0x483D8B,
		emissive : 0x5D478B,
		specular : 0x5D478B
	});

  var material2 = new THREE.MeshPhongMaterial({
		color : 0x484800,
//		ambient : 0x483D8B,
//		emissive : 0x5D478B,
		specular : 0x5D5D00
	});

  var material3 = new THREE.MeshPhongMaterial({
		color : 0x004848,
//		ambient : 0x483D8B,
//		emissive : 0x5D478B,
		specular : 0x005D5D
	});

    var material4 = new THREE.MeshPhongMaterial({
		color : 0x00481D,
//		ambient : 0x483D8B,
//		emissive : 0x5D478B,
		specular : 0x005D1D
	});

    var material5 = new THREE.MeshPhongMaterial({
		color : 0xA84800,
//		ambient : 0x483D8B,
//		emissive : 0x5D478B,
		specular : 0x9D5D00
	});

  var material6 = new THREE.MeshPhongMaterial({
		color : 0xB50000,
//		ambient : 0x483D8B,
//		emissive : 0x5D478B,
		specular : 0x8D0000
	});
  
//pari 1  
  this.pari1_1 = this.createOnePerson(70, 130, 17, 111, material4, true);

  this.pari1_2 = this.createOnePerson(70, 90, 19, 109, material3, true);

  //pari2
  
  this.pari2_1 = this.createOnePerson(-110, 30, 17, 11, material5, true);

  this.pari2_2 = this.createOnePerson(-110, -10, 13, 9, material2, true);

  //pari3
  
  this.pari3_1 = this.createOnePerson(110, -130, 17, -111, material, true);

  this.pari3_2 = this.createOnePerson(110, -90, 13, -109, material6, true);
  
  //yksittäiset
  
  // var p1 = this.createOnePerson(-130, -130, 15, 0, material2, false);
  // for(var i = 0; i<p1.length; i++) {
    // this.objs.add(p1[i]);
  // }

  // var p2 = this.createOnePerson(-130, -130, 15, 0, material2, false);
  // for(var i = 0; i<p2.length; i++) {
    // this.objs.add(p2[i]);
  // }

  // var p3 = this.createOnePerson(-130, -130, 15, 0, material2, false);
  // for(var i = 0; i<p3.length; i++) {
    // this.objs.add(p3[i]);
  // }

  
  // var pari1 = this.createOnePerson(70, 90, 19, 0, material3, false);
  // for(var i = 0; i<testperson3.length; i++) {
    // this.objs.add(testperson3[i]);
  // }

  // var pari2 = this.createOnePerson(70, 90, 19, 0, material3, false);
  // for(var i = 0; i<testperson3.length; i++) {
    // this.objs.add(testperson3[i]);
  // }
  
}

Newpart.prototype.addCrowd = function() {
  for(var i = 0; i<this.pari1_1.length; i++) {
    this.objs.add(this.pari1_1[i]);
  }

  for(var i = 0; i<this.pari1_2.length; i++) {
    this.objs.add(this.pari1_2[i]);
  }

  //pari2
  
  for(var i = 0; i<this.pari2_1.length; i++) {
    this.objs.add(this.pari2_1[i]);
  }

  for(var i = 0; i<this.pari2_2.length; i++) {
    this.objs.add(this.pari2_2[i]);
  }

  //pari3
  
  for(var i = 0; i<this.pari3_1.length; i++) {
    this.objs.add(this.pari3_1[i]);
  }

  for(var i = 0; i<this.pari3_2.length; i++) {
    this.objs.add(this.pari3_2[i]);
  }

}

Newpart.prototype.createOnePerson = function(bodyPositionX, bodyPositionZ, bottomSize, fistPositionZ, material, fists) {
  var person = [];

  var head = new THREE.Mesh(new THREE.SphereGeometry(14, 32, 32), material);
  var body = new THREE.Mesh( new THREE.CylinderGeometry( 7, bottomSize, 60, 32 ), material );    

  var fist1 = new THREE.Mesh(new THREE.SphereGeometry(5, 32, 32), material);
  var fist2 = new THREE.Mesh(new THREE.SphereGeometry(5, 32, 32), material);

  
	head.position.set(bodyPositionX, -5, bodyPositionZ);
//  head.position.set(bodyPositionX, -80, bodyPositionZ);  
  body.position.set(bodyPositionX, -45, bodyPositionZ);
//  body.position.set(bodyPositionX, -120, bodyPositionZ);

  //fistPositionZ on bodyPositionZ +/- 20
  if(fists === true) {
  //y oli -25
    fist1.position.set((bodyPositionX-13), -25, fistPositionZ);
    fist2.position.set((bodyPositionX+13), -25, fistPositionZ);  
    person.push(fist1);
    person.push(fist2);
  }
  // fist1.position.set((bodyPositionX-13), -25, bodyPositionZ+20);
  // fist2.position.set((bodyPositionX+13), -25, bodyPositionZ+20);
  
  // fist3.position.set(bodyPositionX - 13, -25, bodyPositionZ-20);
  // fist4.position.set(bodyPositionX + 13, -25, bodyPositionZ-20);

  
  person.push(head);
  person.push(body);

  return person;
}