//Namespace
this.wideload = this.wideload || {};

/**
* Main class for each part of the demo
*/

(function(){
	
	
	/**
	* Constructor
	* @param main Reference to main class
	* @param renderCacheAmount Amount of frames the part should cache in ringbuffer.
	*/
	var BasePart = function(main, renderCacheAmount, partId){
		this.partId = partId;
		this.main = main;
		this.renderer = null; //Renderer is given from outside.
		this.renderTarget = null; //Create render target on initialize.
		this.elapsedtime = 0;
		this.lastUpdate = 0;
	}
	//Expose the class.
	wideload.BasePart = BasePart;
	
	var p = BasePart.prototype;
	
	/**
	* Initialize the part. This is called during page load.
	*/
	p.initialize = function(renderer){
		this.renderCacheAmount = 20;
		this.cache = new wideload.RenderBuffer(this.renderCacheAmount);
		this.scene = new THREE.Scene();
		this.renderTarget = new THREE.WebGLRenderTarget(1280, 720, { minFilter: THREE.LinearFilter, magFilter: THREE.NearestFilter, format: THREE.RGBFormat });
//		this.renderTarget = new THREE.WebGLRenderTarget(this.main.screenResolution.width, this.main.screenResolution.height, { minFilter: THREE.LinearFilter, magFilter: THREE.NearestFilter, format: THREE.RGBFormat });
		this.renderer = renderer;
		
	}
	
	
	/**
	* Pause the execution of part.
	*/
	p.pause = function(){
		this.isActive = false;
	}
	
	/**
	* Resume the execution.
	*/
	p.resune = function(){
		this.isActive = true;
	}
	
	/**
	* Get the rendertarget of part.
	*/
	p.getRenderTarget = function(){
		return this.renderTarget;
	}
	
	/**
	* Main controller calls render function
	* @param elapsedtime The elapsed song time.
	*/
	p.render = function(elapsedtime){
	
		if(this.isActive){
			this.elapsedtime = elapsedtime-this.lastUpdate;
			this.internalRender(this.elapsedtime, this.renderTarget);
			//this.cache.add(this.renderTarget.clone());
		}
		else{ //Passive effets loop the buffer.
			if(this.cache.isBuffered){
				this.renderer.render(this.scene,this.camera,this.buffer.getNext());		
			}
		}
		
	}
	
	/*
	Overwrite and do render here
	*/
	p.internalRender = function(elapsedtime,renderTarget){

	}
	
	
}())