/**
 * ...
 * @author Henri Sarasvirta
 */

(function() {
	var Greets = function(main, renderCacheAmount, partId){
		this.partId = partId;
		this.main = main;
		this.renderer = null; //Renderer is given from outside.
		this.renderTarget = null; //Create render target on initialize.
	}
	var p = Greets.prototype = new wideload.BasePart();
	wideload.Greets = Greets;
	
	
	p.initialize = function(renderer){
		this.renderCacheAmount = 20;
		this.cache = new wideload.RenderBuffer(this.renderCacheAmount);
		this.scene = new THREE.Scene();
		this.renderTarget = new THREE.WebGLRenderTarget(this.main.screenResolution.width*3, this.main.screenResolution.height*3, { minFilter: THREE.LinearFilter, magFilter: THREE.NearestFilter, format: THREE.RGBFormat });
		this.renderer = renderer;
		
		this.maxX = this.main.resolution.width*3/2;
		this.minX = -this.main.resolution.width*3/2;
		this.maxY = this.main.resolution.height*3/2;
		this.minY = -this.main.resolution.height*3/2;
		
		this.camera = new THREE.OrthographicCamera(this.minX,this.maxX, this.maxY, this.minY);this.camera.position.set( 0, 0, -500 );
				
		this.scene = new THREE.Scene();
		this.texts = [];
				
		this.createText("ANANASMURSKA / API / BYTERAPERS / MATT CURRENT / BOMBSQUAD / DAMONES / HBC / ASD ",-180);
		this.createText("JUMALAUTA / NPLI / SOLEIL / DoO / ALUMNI / ELVENTHOR / EVOFLASH / MERCURY / SUPADUPA  ",80);
		this.createText("PYROTECH / FAIRLIGHT / KEWLERS / TRACTION / DEKADENCE / HEDELMAE / PARAGUAY / FGJ ",320);
		

		this.isActive = true;
	}
	
	p.createText = function(text,pos)
	{
		var text3d = new THREE.TextGeometry( text, {

			size: 140,
			height: 80,
			curveSegments: 0,
			font: "helvetiker"			
		});
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		var textMaterial = new THREE.MeshBasicMaterial( { color:  0x999999, side: THREE.DoubleSide } );
		var text = new THREE.Mesh( text3d, textMaterial );
		
		text.position.x = -400;// centerOffset;
		text.position.y = pos;
		text.position.z = 0;

		text.rotation.y = Math.PI;
		text.rotation.x = Math.PI;
		this.texts.push(text);
		this.scene.add(text);
		
	}

	
	/*
	Overwrite and do render here
	*/
	p.internalRender = function(elapsedtime,renderTarget){
		/*
		
		this.shaderMaterial.uniforms.resolution.value.x = $("#demo canvas").width()/2;
		this.shaderMaterial.uniforms.resolution.value.y = $("#demo canvas").height()/2;
		
		this.shaderMaterial.uniforms.time.value = elapsedtime*0.0002;*/
		for(var i = 0; i < this.texts.length; i++)
			this.texts[i].position.x =-1200+ Math.floor(elapsedtime/2.7)%12000;
		this.renderer.autoClear= true;
		this.renderer.setClearColor(0x02415B);
		//this.renderer.setClearColor(0x4AC948);
		
		//this.renderer.setClearColor(0xAA00FF);
		this.renderer.render(this.scene, this.camera, renderTarget);
		this.renderer.autoClear= false;
		this.renderer.setClearColor(0x000000);
	}
	
	
})();

