
#ifdef GL_ES
precision highp float;
#endif

uniform float timeFrag;
uniform vec2 resolution;

void main(void) {
  vec2 p = (2.0*gl_FragCoord.xy-resolution.xy)/(resolution.y/2.0);
  float a = atan(p.x, p.y);
  float r = length(p)*0.3;
  
  float w = abs(sin(timeFrag)+cos(timeFrag));
  float d = r+tan(0.5*w);
  
  float col = 0.2+(w*d);

  gl_FragColor = vec4(1.0-(col-0.5), 1.0-(col-0.3),
    1.0-(col-0.5), 1.0);
  
}