﻿/**
 * ...
 * @author Anna-Liisa Mattila
 */
wideload.RandomShader =
{
	attributes:{
	},
	
	uniforms:{
		resolution: {type:"v2", value: new THREE.Vector2(8,8)},
		time: {type:"f", value: 0.0},
	},
	
	vertex: [
		"varying vec3 vNormal;",
		
		"void main() {",
			"vNormal = normal;",
			"vec3 p = position;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( p, 1.0 );",
		"}"
	].join("\n"),
	
	fragment:[
    
    "uniform vec2 resolution;",
    "uniform float time;",
    
    "varying vec3 vNormal;",
    
    "float u(float x){",
      "return (x > 0.0)?1.0:0.0;",
    "}",
    "void main(void){",
      "vec2 p = (2.0*gl_FragCoord.xy-resolution.xy)/(resolution.y/6.0);",
      "float a = atan(p.x, p.y);",
      "float r = length(p)*1.0;",
      
      "float w = cos(3.1415927*time-r*2.0);",
      "float h = (0.5+0.5*cos((12.0*a-w*7.0+r*8.0))*(0.5+0.5*sin(r*30.0)))*(time);",
      "float d = 0.25+0.75*pow(abs(h),1.5*r)*(0.7+0.3*w);",
      
      "float col = u(d-r)*sqrt(1.0-r/d)*r*2.5;",
      "col *= 1.25+0.25*(cos((12.0*a-w*0.7+r*8.0)/2.0));",
      "col *= 1.0-0.35*(0.5+0.5*sin(r*30.0))*(0.5+0.5*cos(12.0*a-w*7.0+r*8.0));",
      
      "float red = col-h*r+0.2*h*(1.0-r)*0.5;",
      "float green = col*9.0*h/time*0.5;",
      "float blue = col-h*0.5+r*0.3+0.35*h*(1.0-r);",
      
      "gl_FragColor = vec4(red, green, blue,1.0);",
    "}"
	].join("\n")
}


