//Namespace
this.wideload = this.wideload || {};

/**
* Teddy part, first
*/

(function(){
	
	/**
	* Constructor
	* @param beginTime When the effect should start
	* @param prepareTime How long should the effect be allowed to stay in prepare phase (visible during previous parts end phase).
	         Value of 0 indicates immediate change. The endtime for previous part is the same as this parts prepare. First part has no prepare.
	         */
	    var Ballsea = function( main, cache, id){
	    
		this.renderer = null; //Renderer is given from outside.
		this.main = main;
		this.partId = id;
	}
	//Expose class
	wideload.Ballsea = Ballsea;
	
	var p = Ballsea.prototype = new wideload.BasePart(20);
	p.superInitialize = p.initialize;
	/**
	* Initialize the part. This is called during page load.
	*/
	p.initialize = function(renderer){
		this.superInitialize(renderer);
		this.renderTarget = new THREE.WebGLRenderTarget(2048, 2048, { minFilter: THREE.LinearFilter, magFilter: THREE.NearestFilter, format: THREE.RGBFormat });
		this.renderer = renderer;
		this.random = wideload.Random;

		this.scene = new THREE.Scene();
		
		this.camera = new THREE.PerspectiveCamera(70,1,0.1,2000);
		this.camera.position.z = 55;
		this.camera.position.y = -6;
		this.scene.add(this.camera);

		this.particles = 500;

        var objectGeometry = new THREE.SphereGeometry( 1.5, 0.4, 8, 16 );

				for ( var i = 0; i < this.particles; i ++ ) {
					var objectMaterial = new THREE.MeshPhongMaterial( { ambient: 0x111111, specular: 0xffffff, metal: true,} );
					objectMaterial.color = new THREE.Color(this.random.nextFloat(), this.random.nextFloat(), this.random.nextFloat());
					var mesh = new THREE.Mesh( objectGeometry, objectMaterial );

					mesh.position.x = 200 * ( 0.5 - this.random.nextFloat() );
					mesh.position.y = 200 * ( 0.5 - this.random.nextFloat() );
					mesh.position.z = 200 * ( 0.5 - this.random.nextFloat() );

					mesh.rotation.y = 3.14 * ( 0.5 - this.random.nextFloat() );
					mesh.rotation.x = 3.14 * ( 0.5 - this.random.nextFloat() );

					mesh.matrixAutoUpdate = false;
					mesh.updateMatrix();
					this.scene.add( mesh );

				}

		// LIGHTS

				this.scene.add( new THREE.AmbientLight( 0x111111 ) );

				var intensity = 2.5;
				var distance = 100;
				var c1 = 0xff0040, c2 = 0x0040ff, c3 = 0x80ff80, c4 = 0xffaa00, c5 = 0x00ffaa, c6 = 0xff1100;
				//var c1 = 0xffffff, c2 = 0xffffff, c3 = 0xffffff, c4 = 0xffffff, c5 = 0xffffff, c6 = 0xffffff;

				light1 = new THREE.PointLight( c1, intensity, distance );
				this.scene.add( light1 );

				light2 = new THREE.PointLight( c2, intensity, distance );
				this.scene.add( light2 );

				light3 = new THREE.PointLight( c3, intensity, distance );
				this.scene.add( light3 );

				light4 = new THREE.PointLight( c4, intensity, distance );
				this.scene.add( light4 );

				light5 = new THREE.PointLight( c5, intensity, distance );
				this.scene.add( light5 );

				light6 = new THREE.PointLight( c6, intensity, distance );
				this.scene.add( light6 );

				var dlight = new THREE.DirectionalLight( 0xffffff, 0.1 );
				dlight.position.set( 0.5, -1, 0 ).normalize();
				this.scene.add( dlight );

				var sphere = new THREE.SphereGeometry( 0.25, 16, 8 );

				var l1 = new THREE.Mesh( sphere, new THREE.MeshBasicMaterial( { color: c1 } ) );
				l1.position = light1.position;
				this.scene.add( l1 );

				var l2 = new THREE.Mesh( sphere, new THREE.MeshBasicMaterial( { color: c2 } ) );
				l2.position = light2.position;
				this.scene.add( l2 );

				var l3 = new THREE.Mesh( sphere, new THREE.MeshBasicMaterial( { color: c3 } ) );
				l3.position = light3.position;
				this.scene.add( l3 );

				var l4 = new THREE.Mesh( sphere, new THREE.MeshBasicMaterial( { color: c4 } ) );
				l4.position = light4.position;
				this.scene.add( l4 );

				var l5 = new THREE.Mesh( sphere, new THREE.MeshBasicMaterial( { color: c5 } ) );
				l5.position = light5.position;
				this.scene.add( l5 );

				var l6 = new THREE.Mesh( sphere, new THREE.MeshBasicMaterial( { color: c6 } ) );
				l6.position = light6.position;
				this.scene.add( l6 );


        
	}
	
	/**
	* Main controller calls render function
	* @param renderTarget The rendertarget to render to
	*/
	p.internalRender = function (elapsedtime, renderTarget) {
		this.renderTarget = renderTarget;
	    this.camera.position.x = Math.cos(elapsedtime / 4000) * 10 + 160 ;
	    this.camera.position.y = Math.sin(elapsedtime / 4000) * 50 + 160;
	   this.camera.position.z = Math.sin(elapsedtime / 4500) * 10 + 160;
	    this.camera.lookAt(new THREE.Vector3(0, 0, 0));
	    
        this.renderer.render(this.scene, this.camera, renderTarget);
	}
	
}())