//Namespace
this.wideload = this.wideload || {};

/**
* Teddy part, first
*/

(function(){
	
	/**
	* Constructor
	* @param beginTime When the effect should start
	* @param prepareTime How long should the effect be allowed to stay in prepare phase (visible during previous parts end phase).
	         Value of 0 indicates immediate change. The endtime for previous part is the same as this parts prepare. First part has no prepare.
	         */
	    var Starfall = function( main, cache, id){
	    
		this.renderer = null; //Renderer is given from outside.
		this.main = main;
		this.partId = id;
	}
	//Expose class
	wideload.Starfall = Starfall;
	
	var p = Starfall.prototype = new wideload.BasePart(20);
	p.superInitialize = p.initialize;
	/**
	* Initialize the part. This is called during page load.
	*/
	p.initialize = function(renderer){
		this.superInitialize(renderer);

		this.renderTarget = new THREE.WebGLRenderTarget(2048, 2048, { minFilter: THREE.LinearFilter, magFilter: THREE.NearestFilter, format: THREE.RGBFormat });
	    
	    this.particleCount = 4500;
	    this.particles = new THREE.Geometry();
	    this.camera = new THREE.PerspectiveCamera(40, this.main.resolution.width/this.main.resolution.height, 1, 10000);
	    this.camera.position.z = 20;


        var sparkTexture = new THREE.Texture(jsAsset_star);
        sparkTexture.needsUpdate = true;

		pMaterial = new THREE.ParticleBasicMaterial({
			color: 0x21C7FF,
			size: 5,
			map: sparkTexture,
			blending: THREE.AlphaBlending ,
			transparent: true,
			opacity:1.0
		});
		this.pMaterial = pMaterial;
		var random = wideload.Random;

		for(var p = 0; p < this.particleCount; p++) {
			var pX = random.nextFloat() * 100 - 50,
				pY = random.nextFloat() * -5000,
				pZ = random.nextFloat() * 100 - 50,
		    	particle = new THREE.Vector3(pX, pY, pZ);
		    	particle.timeoff = Math.random() * 50000 - 15000;
			particle.velocity = new THREE.Vector3(
				0,				// x
				random.nextFloat()/0.0001,	// y
				0);				// z

			// add it to the geometry
			this.particles.vertices.push(particle);
		}
		this.particleSystem = new THREE.ParticleSystem(this.particles,pMaterial);
		this.particleSystem.sortParticles = true;
		this.scene.add(this.particleSystem);
		
		var hblur = new THREE.ShaderPass(THREE.ShaderExtras["horizontalBlur"]);
		var vblur = new THREE.ShaderPass(THREE.ShaderExtras["verticalBlur"]);
		var bluriness = 2;

		hblur.uniforms["h"].value = bluriness / this.width;
		vblur.uniforms["v"].value = bluriness / this.height;

		var renderPass = new THREE.RenderPass(this.scene, this.camera);

		this.composer = new THREE.EffectComposer(this.renderer, this.renderTarget);
		this.composer.addPass(renderPass);
		//this.composer.addPass(hblur);
		//this.composer.addPass(vblur);
		this.composer.addPass(vblur);
		//this.particleSystem.sortParticles = true;
	this.particleDropOffZone = 20;
	}
	
	/**
	* Main controller calls render function
	* @param renderTarget The rendertarget to render to
	*/
	p.internalRender = function (elapsedtime, renderTarget) {
		this.renderTarget = renderTarget;
	    
        //this.particleSystem.rotation.y = 0.00005*elapsedtime;
			this.pMaterial.size = elapsedtime*0.0005;
	
        for(var i = 0; i < this.particles.vertices.length; ++i ){
        	var p = this.particles.vertices[i];
        	p.y = ((p.timeoff+elapsedtime)%40000)/1000 - this.particleDropOffZone;
        	
        }
      //  this.particles.verticesNeedUpdate = true;
        this.renderer.autoClear = true;
        this.composer.render();
        this.renderer.autoClear = false;
	
	}
}())