-- add lua implementations of the intersection functions

l1 = { a = vec3d(0,0,0), b = vec3d(100,0,100) }
l2 = { a = vec3d(70,0,0), b = vec3d(0,0,100) }
l3 = { a = vec3d(70,0,0), b = vec3d(0,0,100) }

c1 = { c = vec3d(0,0,0), r = 80 }
c2 = { c = vec3d(10,0,-40), r = 140 }
c3 = { c = vec3d(150,0,0), r = 100 }

copyvec3d(l3.b,c3.c)

mechangle = 0

mechinits = 0

cl1 = { c = cvec3d(l2.a), r = 80 }
cl2 = { c = cvec3d(l2.b), r = 80 }
locus = {}

function renderLine(l)
  drawLine(l.a.x, l.a.y, l.a.z,
           l.b.x, l.b.y, l.b.z)
end

function renderCircle(c, n)
  movePen(c.c.x + c.r * math.sin(0), 0, c.c.z + c.r * math.cos(0))
  local cnt = 0
  local fn = drawTo
  for i=0,math.pi * 2,math.pi * 0.05 do
    if cnt % n == 0 then
      fn = drawTo
    else
      fn = movePen
    end
    
    fn(c.c.x + c.r * math.sin(i), 0, c.c.z + c.r * math.cos(i))
    cnt = cnt + 1
  end
end

function renderPoint(p)
  drawLine(p.x, p.y-20, p.z,
           p.x, p.y+20, p.z)
end

function renderLocus(l)
  if #l < 2 then
    return
  end
  
  movePen(l[1].x, l[1].y, l[1].z)
  for i=2,#l,1 do
    drawTo(l[i].x, l[i].y, l[i].z)
  end
end

function mech.init()
  setCamPos(50 + math.random(100), 50 + math.random(100), 50 + math.random(100))
  lookAt(75,0,0)
  mechinits = mechinits + 1
end

function mech.render()
  renderLine(l1)
  renderLine(l2)
  renderLine(l3)
  renderCircle(c1,1)
  renderCircle(c2,1)
  renderCircle(c3,1)
  if locus[#locus] ~= nil then
    renderLine({a = l2.a, b = locus[#locus]})
    renderLine({a = l2.b, b = locus[#locus]})
  end
  --renderCircle(cl1,1)
  --renderCircle(cl2,1)
  
  do --if mechinits % 2 == 1 then
    renderLocus(locus)
    renderParticles()
  end
end

function mech.update()
  l1.b.x = c1.r * math.sin(mechangle)
  l1.b.z = c1.r * math.cos(mechangle)
  mechangle = mechangle + math.pi * 0.02
  
  copyvec3d(l2.a,l1.b)
  copyvec3d(c2.c,l2.a)
  
  local r = circlecircle(c2,c3)
  
  copyvec3d(l2.b,r.p1)
  copyvec3d(l3.a,l2.b)
  
  -- now, locus
  cl1 = { c = cvec3d(l2.a), r = 80 }
  cl2 = { c = cvec3d(l2.b), r = 80 }
  
  r = circlecircle(cl1, cl2)
  
  table.insert(locus, r.p1)
  
  updateParticles()
  
  if mechinits % 2 == 0 then
    setCamPos(l1.b.x, 50, l1.b.z)
    if mechinits % 4 == 0 then
      lookAt(l3.a.x, l3.a.y, l3.a.z)
    else
      lookAt(l3.b.x, l3.b.y, l3.b.z)
    end
  else
    lookAt(locus[#locus].x, locus[#locus].y, locus[#locus].z)
  end
  
end

particles = {}

function initParticles()
  for i = 1, 100, 1 do
    particles[i] = {}
    local p = particles[i]
    p.pos = vec3d(0,0,0)
    p.vel = vec3d(0,0,0)
    p.active = false
  end
end

initParticles()

function updateParticles()
  local activationCountdown = 10
  for i = 1,100,1 do
    local p = particles[i]
    if p.active == true then
      p.pos = p.pos + p.vel * 0.3
      p.vel = p.vel + vec3d(0,-1,0) * 0.2
      if p.pos.y < 0 then
        p.active = false
      end
    else
      if activationCountdown > 0 and g_wrapItUp ~= 0 then
        -- prime the particle
        copyvec3d(p.pos,locus[#locus])
        --p.pos.y = 60
        --p.vel = vec3d(math.random(20) - 10, math.random(6)-3, math.random(6)-3)
        Vector3D.set(p.vel, math.random(10) - 5, math.random(6) - 3, math.random(10)-5)
        p.active = true
        activationCountdown = activationCountdown - 1
      end
    end
  end
end

function renderParticles()
  colorGL(200,180, 90)
  for i = 1,100,1 do
    local p = particles[i]
	if p.active == true then
		drawLine(p.pos.x,
				 p.pos.y,
				 p.pos.z,
				 p.pos.x + p.vel.x,
				 p.pos.y + p.vel.y,
				 p.pos.z + p.vel.z)
    end
  end
end
