
var debug = 0;

function Debug(text){
    if (debug == 1){
        console.log(text);
    }
}
if (process.argv.length < 3){
    console.log('Specify IP-address and optionally port');
    console.log('Example:');
    console.log('node.js C4UL8R.js 127.0.0.1');
    console.log('or:');
    console.log('node.js C4UL8R.js 127.0.0.1 54321');
    process.exit();
}
var ip = process.argv[2];
Debug('IP: ' + ip);

var port = 54321;
if (process.argv.length >3){
    port = process.argv[3];
}
Debug('Port: ' + port);

var net = require('net');

var client = {
    socket: net.connect({ port: port, host: ip }, function() {
        console.log('Connected');
        this.write('JSON\n');
        this.write('NAME C4UL8R\n');
    }),
    moveUp: function () {
        this.socket.write('UP\n');
    },
    moveDown: function () {
        this.socket.write('DOWN\n');
    },
    moveLeft: function () {
        this.socket.write('LEFT\n');
    },
    moveRight: function () {
        this.socket.write('RIGHT\n');
    },
	Bomb: function(){
		this.socket.write('BOMB\n');
    },
    say: function (msg) {
        this.socket.write('SAY ' + msg + '\n');
    }
};

client.socket.on('end', function(){
    console.log('Client disconnected');
});

var state;
client.socket.on('data', function(data){
    var temp;
	try{
		temp = JSON.parse(data);
	} catch (e){
		return;
	}
    Debug(temp);
    if (temp.type == 'dead'){
        Debug('Dead, noting to do...');
        return;
    }else if (temp.type == 'round end'){
        Debug('New round any moment now');
        return;
    }else if (temp.type == 'status update'){
        Debug('Game AI online');
        state = temp;
        GameAI();
        return;
    }else{
        Debug('Unrecognized data, ignoring');
        Debug(temp);
        return;
    }
});

// ----- AI starts here

function GameAI(){
    if (InDanger()){
        Debug('C4UL8R is in danger! Trying to escape.');
        Escape();
    } else if (SafeToExplore()) {
        Debug('Exploring....');
        Explore();
    }
}

function SafeToExplore() {
    return true;
}

function IsBomb(x, y){
    if (!CoordinateOnMap(x,y)) {
        return false;
    }
    var res = false;
    state.bombs.forEach(function(entry) {
        if (entry.x == x && entry.y==y) {
            res = true;
            return;
        }
    });
    return res;
}


function IsPlayer(x, y){
    if (!CoordinateOnMap(x,y)) {
        return false;
    }
    var res = false;
    state.players.forEach(function(entry) {
        if (entry.x == x && entry.y==y) {
            res = true;
            return;
        }
    });
    return res;
}

function InBombReach(x, y){
    if (!CoordinateOnMap(x,y)) {
        Debug('Not on map. X: ' + x + ', Y: ' + y);
        return 100;
    }
    var res = 100;
    state.bombs.forEach(function(entry) {
        for (i = -2; i <= 2; i++){
            var xdiff = entry.x - i;
            var ydiff = entry.y - i;
            if (x == xdiff && y == entry.y && res > entry.state){
                res = entry.state;
            }
            if (x == entry.x && y == ydiff && res > entry.state){
                res = entry.state;
            }
        }
    });
    return res;
}

function CoordinateOnMap(x, y){
    return !(x < 0 || x >= state.width || y < 0 || y >= state.height);
}

function InDanger(){ //Check if bombs are in line of sight
    return (InBombReach(state.x, state.y)<9);
}

function NextToNumber(x, y, map){
    var number = 10;
    if (!map[x][y] == 'y'){
        return number;
    }
	var diff = [[0,-1],[0,1],[-1,0],[1,0]];
	for (var i = 0; i < 4;i++){
		if (CoordinateOnMap(x + diff[i][0],y+diff[i][1]) && parseInt(map[x+diff[i][0]][y+diff[i][1]]) < number){
			number = parseInt(map[x+diff[i][0]][y+diff[i][1]]);
		}
	}
    return number;
}

function printmap(map){
    Debug('The Map:');
    for (var i = 0; i < map.length; i++){
        var v = '';
        for (var j = 0; j < map[i].length; j++){
            v += map[i][j];
        }
        Debug(v);
    }
}

function BacktrackFrom(x, y, map){
    var steps = parseInt(map[y][x]);
    Debug('Backtracking from x: ' + x + ', y: ' +y + ' steps ' + steps);
	var diff = [[0,-1],[0,1],[-1,0],[1,0]];
	for (var i = 0; i < 4; i++){
		if (CoordinateOnMap(x+diff[i][0], y+diff[i][1])){
			var test = parseInt(map[y+diff[i][1]][x+diff[i][0]]);
			if (test < steps){
				if (test == 0){
					switch (i){
						case 0:
							client.moveDown();
							break;
						case 1:
							client.moveUp();
							break;
						case 2:
							client.moveRight();
							break;
						case 3:
							client.moveLeft();
					}
				}else{
					BacktrackFrom(x+diff[i][0], y+diff[i][1], map);
				}
				return;
			}
		}
	}
}

function Escape(){
    var map = new Array(state.map.length);
    for (var i = 0; i < state.map.length; i++){
        map[i] = new Array(state.map[0].length);
        for (var j = 0; j < map[i].length; j++){
            if (IsBomb(j, i) || IsPlayer(j, i) || state.map[i][j] == '+' || state.map[i][j] == '#'){
                map[i][j] = 'x';
            }else if (state.map[i][j] == '.'){
                map[i][j] = 'y';
            }else{
                Debug('Map not feeling well:' + map[i][j]);
            }
        }
    }
    map[state.y][state.x] = '0';
    var escapeTime = InBombReach(state.x, state.y); 
	Debug('Escapetime : ' + escapeTime);
    //printmap(map);
    for (count = 0; count < escapeTime; count++){
        for (var i = 0; i < map.length; i++){
            for (var j = 0; j < map[0].length; j++){
                if (map[i][j] == 'y'){
                    var distance = NextToNumber(i,j,map);
                    if (distance <= escapeTime){
                        map[i][j] = distance + 1;
                        if (InBombReach(j, i)>=9){
                            Debug('Found safe spot at x: ' + j + ', y: ' + i);
                            BacktrackFrom(j, i, map);
                            printmap(map);
                            return;
                        }
                    }
                }
            }
        }
    }
	printmap(map);
}

function DestructibleWithinBombRange(x, y, map){
	if (!CoordinateOnMap(x, y)){
		return false;
	}
	for (i = -2; i <= 2; i++){
		var xdiff = x - i;
		var ydiff = y - i;
		if ((CoordinateOnMap(x, ydiff) && map[ydiff][x] == '#') || (CoordinateOnMap(xdiff, y) && map[y][xdiff] == '#')){
			return true;
		}
	}
	return false;
}

function Explore(){
	var map = new Array(state.map.length);
    for (var i = 0; i < state.map.length; i++){
        map[i] = new Array(state.map[0].length);
        for (var j = 0; j < map[i].length; j++){
            if (InBombReach(j, i) < 9 || IsPlayer(j, i) || IsPlayer(j, i) || state.map[i][j] == '+' || state.map[i][j] == '#'){
                map[i][j] = 'x';
            }else if (state.map[i][j] == '.'){
                map[i][j] = 'y';
            }else{
                Debug('Map not feeling well:' + map[i][j]);
            }
        }
    }
    map[state.y][state.x] = '0';
	
	if (DestructibleWithinBombRange(state.x, state.y, state.map) && CanEscapeFrom(state.x,state.y)){
		client.Bomb();
		return;
	}

	var rounds = 8;
    for (count = 0; count < rounds; count++){
        for (var i = 0; i < map.length; i++){
            for (var j = 0; j < map[0].length; j++){
                if (map[i][j] == 'y'){
                    var distance = NextToNumber(i,j,map);
                    if (distance <= rounds){
                        map[i][j] = distance + 1;
                        if (DestructibleWithinBombRange(j, i, state.map) && CanEscapeFrom(j,i)){
							Debug('Found destructible at x ' + j + ' y ' + i);
							BacktrackFrom(j, i, map);
							return;
                        }
                    }
                }
            }
        }
    }
}

function InFutureBombReach(x, y, bombX, bombY){
	return ((y==bombY&&Math.abs(bombX-x)<3)||(x==bombX&&Math.abs(bombY-y)<3));
}

function CanEscapeFrom(x, y){
	var map = new Array(state.map.length);
    for (var i = 0; i < state.map.length; i++){
        map[i] = new Array(state.map[0].length);
        for (var j = 0; j < map[i].length; j++){
            if (InBombReach(j, i) < 9 || IsPlayer(j, i) || state.map[i][j] == '+' || state.map[i][j] == '#'){
                map[i][j] = 'x';
            }else if (InFutureBombReach(j, i, x, y)){
				map[i][j] = 'z';
			}else if (state.map[i][j] == '.'){
                map[i][j] = 'y';
            }else{
                Debug('Map not feeling well:' + map[i][j]);
            }
        }
    }
    map[y][x] = '0';
    printmap(map);
	var rounds = 3;
    for (count = 0; count < rounds; count++){
        for (var i = 0; i < map.length; i++){
            for (var j = 0; j < map[0].length; j++){
                if (map[i][j] == 'z'||map[i][j] == 'y'){
                    var distance = NextToNumber(i,j,map);
                    if (distance <= rounds){
						if (map[i][j]=='y'){
							return true;
						}
                        map[i][j] = distance + 1;
                    }
                }
            }
        }
    }
	return false;
}