#ifndef DNB_NODE_H_
#define DNB_NODE_H_

#include "OdinAI/GraphNodes.h"
#include "Vector2.h"

/**
 * Our own implementation of a node, which adds extra information about the state of a node.
 */
class DNBNode : public OdinAI::NavGraphNode<iVec2>
{
public:
    DNBNode(int index, const iVec2 &pos, char tile) : OdinAI::NavGraphNode<iVec2>(index, pos), m_tile(tile) {}

    /**
     * Set the tile type of the node.
     */
    void SetTile(char tile) {m_tile = tile;}

    /**
     * Get the tile type of the node.
     */
    char GetTile() const {return m_tile;}
private:
    char m_tile;
};

#endif