#ifndef DNB_GAMEMANAGER_H_
#define DNB_GAMEMANAGER_H_

#include "OdinAI/OdinAIRoot.h"
#include "PlayerManager.h"
#include "Map.h"
#include "Brain.h"
#include "BombManager.h"

#define MAP_BUFFER_SIZE 1132768

class GameManager : public OdinAI::OdinAIRoot
{
public:
    static GameManager &GetInstance()
    {
        static GameManager instance;
        return instance;
    }

    /**
     * @return Map instance.
     */
    const Map &GetMap() const { return m_map; }

    /**
     * @return True if sudden death.
     */
    bool IsSuddenDeath() const;

    /**
     * @return Our bomb manager.
     */
    const BombManager &GetBombMgr() const { return m_bombManager; }

    /**
     * @return Our player manager
     */
    const PlayerManager &GetPlayerMgr() const { return m_playerManager; };
private:
    GameManager() : m_hasInitMap(false), m_mapOffset(0), m_bombsOffset(0) {}
    GameManager(const GameManager &) {}
    GameManager &operator=(const GameManager&) {}

    bool NewRound();

    PlayerManager m_playerManager;
    BombManager m_bombManager;

    char buffer[MAP_BUFFER_SIZE];
    int m_mapOffset;
    int m_bombsOffset;
    Map m_map;
    Brain m_brain;
    bool m_hasInitMap;

    bool OnInit(int argc, char** argv);
    bool OnLoop();
    
    void AsyncRecv(char *data, int size);
};

#define gGameMgr GameManager::GetInstance()

#endif