#ifndef DNB_MAP_EVENT_H_
#define DNB_MAP_EVENT_H_

#include "OdinAI/Event.h"
#include <vector>

/**
 * Sent on map changed.
 * Listen to "mapChanged".
 */
class MapChangedEvent : public OdinAI::Event
{
public:
    DECLARE_EVENT(MapChangedEvent);

    void Init(const std::vector< std::vector<char> > *map)
    {
        m_map = map;
    }

    const std::vector< std::vector<char> > *GetMap() const
    {
        return m_map;
    }

    const char *GetName() const
    {
        return "mapChanged";
    }
private:
    const std::vector< std::vector<char> > * m_map;
};

#endif