#ifndef DNB_TRAVERSE_EDGE_GOAL_H_
#define DNB_TRAVERSE_EDGE_GOAL_H_

#include "OdinAI/Goals.h"
#include "OdinAI/GraphEdges.h"

class Player;

class TraverseEdgeGoal : public OdinAI::AtomicGoal
{
public:
    TraverseEdgeGoal(Player *pOwner, const OdinAI::GraphEdge &edge) : m_pOwner(pOwner), m_edge(edge) {}

    /**
	 * Function called before a goal is processed.
	 */
	void Activate();

	/**
	 * Function used to process goal.
	 */
	int Process();

	/**
	 * Function used to clean up an goal.
	 */
	void End();
private:
    Player *m_pOwner;
    OdinAI::GraphEdge m_edge;
};

#endif