#ifndef DNB_VECTOR2_H_
#define DNB_VECTOR2_H_

#include "OdinAI/DebugUtil.h"
#include "OdinAI/MathUtil.h"

template<typename ValueType>
class Vector2
{
public:
    ValueType x, y;

    Vector2() : x(0), y(0) {}

    explicit Vector2(ValueType x, ValueType y) : x(x), y(y) {}

    explicit Vector2(ValueType scale) : x(scale), y(scale) {}

    ValueType operator [](const OdinAI::uint i) const
    {
        AssertMsg(i < 2, "Index is out of range!");

        return *(&x+1);
    }

    ValueType &operator [](const OdinAI::uint i)
    {
        AssertMsg(i < 2, "Index is out of range!");

        return *(&x+1);
    }

    Vector2<ValueType> operator +(const Vector2<ValueType> &a) const
    {
        return Vector2<ValueType>(x + a.x, y + a.y);
    }

    Vector2<ValueType> operator -(const Vector2<ValueType> &a) const
    {
        return Vector2<ValueType>(x - a.x, y - a.y);
    }

    Vector2<ValueType> operator *(const Vector2<ValueType> &a) const
    {
        return Vector2<ValueType>(x * a.x, y * a.y);
    }

    Vector2<ValueType> operator /(const Vector2<ValueType> &a) const
    {
        return Vector2<ValueType>(x / a.x, y / a.y);
    }

    Vector2<ValueType> operator *(ValueType a) const
    {
        return Vector2<ValueType>(x * a, y * a);
    }
    
    Vector2<ValueType> operator /(ValueType a) const
    {
        return Vector2<ValueType>(x / a, y / a);
    }

    Vector2<ValueType> &operator +=(const Vector2<ValueType> &a)
    {
        x += a.x;
        y += a.y;

        return *this;
    }

    Vector2<ValueType> &operator -=(const Vector2<ValueType> &a)
    {
        x -= a.x;
        y -= a.y;

        return *this;
    }

    ValueType Length() const
    {
        return static_cast<ValueType>(sqrt(static_cast<double>(x*x) + static_cast<double>(y*y)));
    }

    bool operator !=(const Vector2<ValueType> &a) const
    {
        return x != a.x || y != a.y;
    }

    bool operator ==(const Vector2<ValueType> &a) const
    {
        return x == a.x && y == a.y;
    }

    template<typename ValueType>
    friend std::ostream& operator<<(std::ostream &o, const Vector2<ValueType> &t)
    {
        o << "(" << t.x << ", " << t.y << ")";
        return o;
    }
};

typedef Vector2<int> iVec2;
typedef Vector2<unsigned int> uiVec2;
typedef Vector2<float> fVec2;
typedef Vector2<double> dVec2;

#endif