#include "ExploreGoal.h"
#include "OdinAI/DijkstraGraphSearch.h"
#include "GameManager.h"
#include "BombTargetCondition.h"
#include "Player.h"
#include "FollowPathGoal.h"
#include "BombGoal.h"
#include "PathValidation.h"

ExploreGoal::ExploreGoal(Player *pPlayer) : m_pPlayer(pPlayer)
{
    gGameMgr.GetEventMgr().AddEventListener("mapChanged", std::bind(&ExploreGoal::OnMapChanged, this, std::placeholders::_1), this);
}

void ExploreGoal::Activate()
{
    m_status = OdinAI::GOAL_ACTIVE;
    OdinAI::DijkstraGraphSearch<DNBGraph, BombTargetCondition, SafePathValidation> search(gGameMgr.GetMap().GetGraph(), gGameMgr.GetMap().GetNodeIdx(m_pPlayer->GetPosition()));
    std::list<int> path = search.GetPath();

    if(path.size() > 0)
    {
        AddGoal(new FollowPathGoal(m_pPlayer, path, true));
    }
}

int ExploreGoal::Process()
{
    ActivateIfInactive();

    m_status = ProcessSubgoals();

    return m_status;
}

void ExploreGoal::OnMapChanged(const OdinAI::Event *pEvent)
{
    Clear();
    Activate();
}

void ExploreGoal::End()
{
    gGameMgr.GetEventMgr().RemoveEventListener("mapChanged", std::bind(&ExploreGoal::OnMapChanged, this, std::placeholders::_1), this);
}


