#include "FleeGoal.h"
#include <vector>
#include <queue>
#include "GameManager.h"
#include "FollowPathGoal.h"
#include "MapEvent.h"

const char *sayMsg[] = {
"Motherfucker!",
"I hate this!",
"Cya later",
"R.I.P D'n'B",
"I am dying help me!",
"Help! Help! Fire in the hole!",
"Why me?",
"I guess i am dead now, ait?",
"You are funny though.",
"I hate you",
"asdhashdashdashd",
"RAGE QUITING!11?N00BS"
};

void FleeGoal::Activate()
{
    m_status = OdinAI::GOAL_ACTIVE;

    m_path = CreateEscapePlan(true);
    
    if(m_path.size() > 0)
    {
        AddGoal(new FollowPathGoal(m_pOwner, m_path));
    }
    else
    {
        // We try once more, but now, without safety margin.
        m_path = CreateEscapePlan(false);
        if(m_path.size() > 0)
        {
            AddGoal(new FollowPathGoal(m_pOwner, m_path));
        }
        else
        {
            // And we are dead...
            std::string msg = "SAY ";
            msg += sayMsg[rand() % sizeof(sayMsg) / sizeof(char*)];
            msg += '\n';
            gGameMgr.GetNetworkMgr().Send(msg.c_str(), msg.length());
        }
    }
}

int FleeGoal::Process()
{
    ActivateIfInactive();

    m_status = ProcessSubgoals();

    return m_status;
}

void FleeGoal::OnMapChanged(const OdinAI::Event *pEvent)
{
    Clear();
    m_map = *dynamic_cast<const MapChangedEvent*>(pEvent)->GetMap();
    Activate();
}

std::list<int> FleeGoal::CreateEscapePlan(Player* pOwner, const std::vector<std::vector<char>> &bombMap, bool useSafetyMargin)
{
    struct Edge
    {
        int from;
        int to;
        int cost;
    };

    const auto &curMap = gGameMgr.GetMap();
    const iVec2 &pos = pOwner->GetPosition();
    int startNode = gGameMgr.GetMap().GetNodeIdx(pos);

    int numNodes = curMap.GetSizeX() * curMap.GetSizeY();
    std::vector<bool> visited(numNodes);
    std::vector<int> route(numNodes);
    std::queue<Edge> queue;
    
    Edge dummy = {startNode, startNode, 0};
    queue.push(dummy);
    
    int targetNode = -1;
    while(!queue.empty())
    {
        Edge edge = queue.front();
        queue.pop();

        route[edge.to] = edge.from;

        iVec2 pos = curMap.GetPosFromNodeIdx(edge.to);
        char tile = bombMap[pos.x][pos.y];
        int tickLeft = useSafetyMargin ? tile-1 : tile;
        if(tile < 32 && (tile - 1) == edge.cost)
            continue;

        if(curMap.IsTileStandAble(tile) || (tile < 32 && tile < edge.cost))
        {
            // We found an empty positions which are not in range of any bomb, this maybe our escape path.
            targetNode = edge.to;
            break;
        }

        Edge edges[4];
        int curEdge = 0;

        // Left edge
        if(pos.x > 0 && (curMap.IsTileStandAble(bombMap[pos.x-1][pos.y]) || bombMap[pos.x-1][pos.y] < 32))
        {
            edges[curEdge].from = edge.to;
            edges[curEdge].to = curMap.GetNodeIdx(iVec2(pos.x-1, pos.y));
            ++curEdge;
        }

        // Right edge
        if(pos.x + 1 < curMap.GetSizeX() && (curMap.IsTileStandAble(bombMap[pos.x+1][pos.y]) || bombMap[pos.x+1][pos.y] < 32))
        {
            edges[curEdge].from = edge.to;
            edges[curEdge].to = curMap.GetNodeIdx(iVec2(pos.x+1, pos.y));
            ++curEdge;
        }

        // Top edge
        if(pos.y > 0 && (curMap.IsTileStandAble(bombMap[pos.x][pos.y-1]) || bombMap[pos.x][pos.y-1] < 32))
        {
            edges[curEdge].from = edge.to;
            edges[curEdge].to = curMap.GetNodeIdx(iVec2(pos.x, pos.y-1));
            ++curEdge;
        }

        // Bottom edge
        if(pos.y + 1 < curMap.GetSizeY() && (curMap.IsTileStandAble(bombMap[pos.x][pos.y+1]) || bombMap[pos.x][pos.y+1] < 32))
        {
            edges[curEdge].from = edge.to;
            edges[curEdge].to = curMap.GetNodeIdx(iVec2(pos.x, pos.y+1));
            ++curEdge;
        }

        for(int i = 0;i < curEdge;++i)
        {
            edges[i].cost = edge.cost + 1;
            if(!visited[edges[i].to])
            {
                queue.push(edges[i]);

                visited[edges[i].to] = true;
            }
        }
    }

    std::list<int> path;
    if(targetNode < 0)
        return path;

    int node = targetNode;
    path.push_front(node);

    while(node != startNode)
    {
        node = route[node];
        path.push_front(node);
    }

    return path;
}

void FleeGoal::End()
{
    gGameMgr.GetEventMgr().RemoveEventListener("mapChanged", std::bind(&FleeGoal::OnMapChanged, this, std::placeholders::_1), this);
}