#include "TraverseEdgeGoal.h"
#include <iostream>
#include "GameManager.h"
#include "Player.h"

const char *moveCmds[4] = 
{
    "UP\n", 
    "DOWN\n", 
    "LEFT\n", 
    "RIGHT\n"
};

void TraverseEdgeGoal::Activate()
{
    m_status = OdinAI::GOAL_COMPLETE;

    iVec2 start = gGameMgr.GetMap().GetPosFromNodeIdx(m_edge.From());
    iVec2 end = gGameMgr.GetMap().GetPosFromNodeIdx(m_edge.To());

    if(gGameMgr.GetMap().GetMap()[end.x][end.y] == 1)
    {
        m_status = OdinAI::GOAL_FAILED;
        return;
    }

    if(m_pOwner->GetPosition().x != start.x || 
       m_pOwner->GetPosition().y != start.y)
    {
        OdinAI::DebugMessage("TraverseEdgeGoal: Failed to traverse an edge");
        m_status = OdinAI::GOAL_FAILED;
        return;
    }

    const char *cmd = moveCmds[0];
    if(start.x > end.x)
    {
        cmd = moveCmds[2];
    }
    else if(start.x < end.x)
    {
        cmd = moveCmds[3];
    }
    else if(start.y < end.y)
    {
        cmd = moveCmds[1];
    }

    gGameMgr.GetNetworkMgr().Send(cmd, strlen(cmd));
}

int TraverseEdgeGoal::Process()
{
    ActivateIfInactive();

    return m_status;
}

void TraverseEdgeGoal::End()
{
}