#include "OdinAI/NetworkManager.h"
#include "OdinAI/SharedDefs.h"
#include "OdinAI/MessageHandler.h"

#include <string>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <errno.h>
#include <netinet/in.h>
#include <netdb.h>
#include <fcntl.h>
#include <string.h>

namespace OdinAI
{
	bool NetworkManager::Connect(const char *ip, const char *port, const AsyncRecvCallback &asyncRecvCallback)
	{
		m_asyncRecvCallback = asyncRecvCallback;

		int iResult;
		addrinfo *pResult = NULL, *pCurrent = NULL, hints;

		memset(&hints, 0, sizeof(hints));
		hints.ai_family = AF_UNSPEC;
		hints.ai_socktype = SOCK_STREAM;
		hints.ai_protocol = IPPROTO_TCP;

		if(getaddrinfo(ip, port, &hints, &pResult))
		{
			perror("getaddrinfo");
			return false;
		}

		if((m_clientSocket = socket(pResult->ai_family, pResult->ai_socktype, pResult->ai_protocol)) == -1)
		{
			perror("socket");
			return false;
		}

		if(fcntl(m_clientSocket, F_SETFL, O_NONBLOCK))
		{
			perror("fcntl");
			return false;
		}

		if(connect(m_clientSocket, pResult->ai_addr, (int)pResult->ai_addrlen) == -1)
		{
			perror("connect");
			return false;
		}

		return true;
	}

	void NetworkManager::Update()
	{
		HandleReceive();
	}

	void NetworkManager::HandleReceive()
	{
		int iNumBytesReceived = recv(m_clientSocket, &m_netBuffer, NETWORK_BUFFER_SIZE, 0);
		if(iNumBytesReceived > 0)
		{
			m_asyncRecvCallback(m_netBuffer, iNumBytesReceived);
		}
	}

	void NetworkManager::Send(const void *data, int size)
	{
		if(send(m_clientSocket, static_cast<const char*>(data), size, 0) == -1)
		{
			perror("send");
		}
	}

	void NetworkManager::Close()
	{
		close(m_clientSocket);
	}
}
