#!/dev/null

use strict;
use warnings;

#use Devel::SimpleTrace;

use IO::Select;
use IO::Socket::INET;

package AI;

sub new {
    my ($package, %options) = @_;

    my $self = {};

    $self->{$_} = $options{$_} for keys %options;

    bless $self, $package;

    # Updates to our position.
    $self->bind('X', sub {
        ($self->{'x'}) = @_;
    });
    $self->bind('Y', sub {
        ($self->{'y'}) = @_;
    });

    # Map size.
    $self->bind('WIDTH', sub {
        ($self->{'map_width'}) = @_;
    });
    $self->bind('HEIGHT', sub {
        ($self->{'map_height'}) = @_;
    });

    # Map layout.
    $self->bind('MAP', sub {
        $self->{'map'} = ();

        while (1) {
            $self->buffer_socket();
            my $input = $self->read_buffer();

            next unless defined $input or length $input == 0;
            last if $input eq 'ENDMAP';

            push @{$self->{'map'}}, $input;
        }

        # Hack.
        $self->{'updates'}++;
        if ($self->{'updates'} == 3) {
            $self->{'buffer'} = 'OK' . "\n" . $self->{'buffer'};
            $self->{'updates'} = 0;
        }
    });

    # Player list.
    $self->bind('PLAYERS', sub {
        $self->{'players'} = ();

        while (1) {
            $self->buffer_socket();
            my $input = $self->read_buffer();

            next unless defined $input or length $input == 0;
            last if $input eq 'ENDPLAYERS';

            push @{$self->{'players'}}, $input;
        }

        # Hack.
        $self->{'updates'}++;
        if ($self->{'updates'} == 3) {
            $self->{'buffer'} = 'OK' . "\n" . $self->{'buffer'};
            $self->{'updates'} = 0;
        }
    });

    # Bomb list.
    $self->bind('BOMBS', sub {
        @{$self->{'bombs'}} = ();

        while (1) {
            $self->buffer_socket();
            my $input = $self->read_buffer();

            next unless defined $input or length $input == 0;
            last if $input eq 'ENDBOMBS';

            push @{$self->{'bombs'}}, $input;
        }

        # Hack.
        $self->{'updates'}++;
        if ($self->{'updates'} == 3) {
            $self->{'buffer'} = 'OK' . "\n" . $self->{'buffer'};
            $self->{'updates'} = 0;
        }
    });

    # >=(
    $self->bind('DEAD', sub {
        
    });

    # When we have won ;););)
    $self->bind('ENDOFROUND', sub {
        
    });

    return $self;
}

sub bind {
    my ($self, $command, $coderef) = @_;

    $self->{'handlers'} = () unless defined $self->{'handlers'};
    $self->{'handlers'}->{$command} = () unless defined $self->{'handlers'}->{$command};

    push @{$self->{'handlers'}->{$command}}, $coderef;
}

sub connect {
    my ($self) = @_;

    $self->{'select'} = IO::Select->new();
    $self->{'socket'} = IO::Socket::INET->new($self->{'server'}) or die $!;

    $self->{'select'}->add($self->{'socket'});

    $self->{'buffer'} = '';
}

sub write {
    my ($self, $data) = @_;

    #print $data;

    syswrite $self->{'socket'}, $data;
}

sub buffer_socket {
    my ($self) = @_;

    return unless $self->{'select'}->can_read(0);

    my $bytes = sysread($self->{'socket'}, my $buffer = '', 1024);

    die $! unless defined $bytes;
    die 'Error reading from socket!' if $bytes == -1;
    die 'Socket closed!' if $bytes == 0;

    $self->{'buffer'} .= $buffer;
}

sub read_buffer {
    my ($self) = @_;

    if ($self->{'buffer'} =~ s/^(.*?)\n//) {
        return $1;
    }
}

sub set_name {
    my ($self, $name) = @_;

    $self->write('NAME ' . $name . "\n");
}

sub say {
    my ($self, $message) = @_;

    chomp $message;

    $self->write('SAY ' . $message . "\n");
}

sub left {
    my ($self) = @_;

    $self->write('LEFT' . "\n");
}

sub right {
    my ($self) = @_;

    $self->write('RIGHT' . "\n");
}

sub up {
    my ($self) = @_;

    $self->write('UP' . "\n");
}

sub down {
    my ($self) = @_;

    $self->write('DOWN' . "\n");
}

sub bomb {
    my ($self) = @_;

    $self->write('BOMB' . "\n");
}

sub tick {
    my ($self) = @_;

    $self->buffer_socket();

    my $input = $self->read_buffer();

    return unless length $input;

    my ($command, $arguments) = split(' ', $input, 2);

    if (defined $self->{'handlers'}->{$command}) {
        foreach my $handler (@{$self->{'handlers'}->{$command}}) {
            &{$handler}($arguments);
        }
    } else {
        warn 'Unhandled data: ' . $command . "\n";
    }
}

1;
