﻿#undef DEBUG

using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;

namespace segfault {
   public static class ExtM {
      public static T At<T>(this T[,] t, Pos p) {
         try {
            return t[p.X, p.Y];
         } catch (Exception x) {
#if DEBUG
            Console.WriteLine("At{0}{1}: {2}", p.X, p.Y, x);
#endif
            return default(T);
         }
      }

      public static void SetAt<T>(this T[,] t, Pos p, T v) {
         try {
            t[p.X, p.Y] = v;
         } catch (Exception x) {
#if DEBUG
            Console.WriteLine("SetAt{0}{1}<{3}: {2}", p.X, p.Y, x, v);
#endif
         }
      }

      public static int IndexOf<T>(this T[] array, Predicate<T> predicate) {
         for (int i = 0; i < array.Length; i++)
            if (predicate(array[i]))
               return i;
         return -1;
      }

      public static byte[,] BlockCopy(this byte[,] src, byte[,] dst) {
         Buffer.BlockCopy(src, 0, dst, 0, src.Length);
         return dst;
      }

      public static string Mappify(this byte[][,] othermaps, params byte[][,] oothermaps) {
         if (othermaps == null)
            return "";
         return othermaps.First().Mappify(othermaps.Skip(1).Concat(oothermaps).ToArray());
      }

      public static string HotMappify(this byte[,] hot) {
         if (hot == null)
            return "";
         var sb = new StringBuilder();
         for (int y = 0; y < hot.GetLength(1); y++) {
            for (int x = 0; x < hot.GetLength(0); x++)
               sb.Append(hot[x, y] == 0 ? ' ' : '@');
            sb.AppendLine();
         }
         return sb.ToString();
      }

      public static string Mappify(this byte[,] map, params byte[][,] othermaps) {
         if (map == null)
            return "";
         var sb = new StringBuilder();
         for (int y = 0; y < map.GetLength(1); y++) {
            for (int x = 0; x < map.GetLength(0); x++)
               sb.Append((char)((map[x, y] <= Program.BTTB ? '0' : 0) + map[x, y]));
            sb.AppendLine();
         }
         if (othermaps.Any()) {
            sb.AppendLine();
            sb.Append(othermaps.First().Mappify(othermaps.Skip(1).ToArray()));
         }
         return sb.ToString();
      }
   }
}
