﻿#undef DEBUG
#undef SHOWWAIT
#undef VALIDATEFUT
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net.Sockets;
using System.Threading;

namespace segfault {
   class Program {
      #region helper'n'fields
      static Random rnd = new Random();
      static NetworkStream gameserver;
      static StreamReader sr;
      static StreamWriter sw;
      public const int BTTB = 5;
      static byte[][,] Fut = new byte[BTTB + 1][,];
      static byte[,] Hot;
      static int Tick;

      static void ReadAll<T>(Func<string> read, IList<T> pool) {
         pool.Clear();
         while (true) {
            var line = read();
            if (line[0] == 'E')
               return;
            pool.Add((T)Activator.CreateInstance(typeof(T), new object[] { line.Split(' ') }));
         }
      }

      static void send(string data) {
         sw.Write(data + "\n");
         sw.Flush();
#if DEBUG
         Console.WriteLine("> " + data);
#endif
      }

      static string read() { return sr.ReadLine(); }

      static void move(Dir dir) {
         switch (dir) {
            case Dir.Up:
               send("UP");
               break;
            case Dir.Right:
               send("RIGHT");
               break;
            case Dir.Down:
               send("DOWN");
               break;
            case Dir.Left:
               send("LEFT");
               break;
            default:
               send("SAY 2+2=5");
               break;
         }
      }

      static int _(int i) {
         return (i + 1 + BTTB) % (BTTB + 1);
      }

      static byte[,] FloodFill(Pos P, byte[,] map, byte acceptValue, byte setValue, out int count) {
         int w, h, cnt = 0;

         var ret = new byte[w = map.GetLength(0), h = map.GetLength(1)];
         var scan = new Queue<Tuple<Pos, Pos>>();

         Func<Pos, bool> accept = q => q.X >= 0 && q.X < w && q.Y >= 0 && q.Y < h && map.At(q) == acceptValue;

         Action<Pos> add = q => { ++cnt; ret.SetAt(q, setValue); };

         Func<Pos, Tuple<Pos, Pos>> _scan = pos => {
            add(pos);
            Pos t;
            var p = new Pos(pos);

            while (p.X >= 0 && accept(t = p.Offset(Dir.Left)))
               add(p = t);

            while (pos.X < w && accept(t = pos.Offset(Dir.Right)))
               add(pos = t);

            return new Tuple<Pos, Pos>(p, pos);
         };

         if (accept(P))
            scan.Enqueue(_scan(P));

         while (scan.Count > 0) {
            Pos t;
            var range = scan.Dequeue();
            for (Pos i = new Pos(range.Item1); i.X <= range.Item2.X; i.X++) {
               t = i.Offset(Dir.Up);
               if (t.Y > 0          // in range
                  && ret.At(t) == 0 // not scanned yet
                  && accept(t)) {
                  var tt = _scan(t);
                  scan.Enqueue(tt);
                  i = tt.Item2.Offset(Dir.Down).Offset(Dir.Right);
               }
            }
            for (Pos i = range.Item1; i.X <= range.Item2.X; i.X++) {
               t = i.Offset(Dir.Down);
               if (t.Y < h          // in range
                  && ret.At(t) == 0 // not scanned yet
                  && accept(t)) {
                  var tt = _scan(t);
                  scan.Enqueue(tt);
                  i = tt.Item2.Offset(Dir.Up).Offset(Dir.Right);
               }
            }
         }

         count = cnt;
         return ret;
      }
      #endregion

      static void Main(string[] args) {
         #region connect'n'init
         if (args.Length == 0)
            //args = new string[] { "localhost", "54321" };
            args = new string[] { "151.216.153.109", "54321" };
         else if (args.Length != 2) {
            Console.WriteLine("segfault.exe localhost 54321");
            return;
         }

         var sp = typeof(State).GetFields().ToDictionary(p => p.Name[0]);
         var host = new TcpClient();
         var mybombs = new List<Bomb>();
         bool dead = true;
         bool win = false;
         bool suddenDeathDetected = false;
         var maxbombs = 1; // might change due to powerups
#if SHOWWAIT
         var _WATCH_WAIT = new Stopwatch();
         _WATCH_WAIT.Start();
#endif
         Func<int> nextBombAvailableIn = () => mybombs.Count < maxbombs ? 0 : mybombs.Min(b => b.T);

         while (true) {
            try {
               while (true) {
                  try {
                     host.Connect(args[0], int.Parse(args[1]));
                     break;
                  } catch {
                     Console.WriteLine("retryin to connect to {0}:{1}", args[0], args[1]);
                     Thread.Sleep(666);
                  }
               }

               gameserver = host.GetStream();
               sw = new StreamWriter(gameserver);
               sr = new StreamReader(gameserver);

               Console.WriteLine("Segmentation Fault (Core Dumped)");
               Thread.Sleep(321);
               Console.WriteLine("just kidding... connected!");
         #endregion

               send("NAME segfault");

               while (true) {
                  #region reinit
                  if (dead || win) {
                     mybombs.Clear();
                     win = suddenDeathDetected = dead = false;
                     Tick = -1;
                  }
                  mybombs.RemoveAll(b => --b.T < 0);
                  bool rcv = true;
                  var s = new State(++Tick);
#if SHOWWAIT
            bool firstLine = true;
            _WATCH_WAIT.Restart();
            //Console.WriteLine(Fut.Skip(Tick % Fut.Length).ToArray().Mappify(Fut.Take(Tick % Fut.Length).ToArray()));
            //Console.SetCursorPosition(0, 0);
            //Console.WriteLine(Hot.HotMappify());
#endif
                  #endregion

                  #region receive status
                  while (rcv && !dead && !win) {
                     var line = read();
                     if (line == null)
                        continue;
#if SHOWWAIT
               if (firstLine) {
                  Console.WriteLine("           * TICK *    waited {0}ms", _WATCH_WAIT.ElapsedMilliseconds);
                  firstLine = false;
               }
#endif

                     Func<int> N = () => int.Parse(line.Split(' ')[1]);
                     GC.Collect();
                     GC.WaitForPendingFinalizers();

                     switch (line[0]) {
                        case 'P':
                           ReadAll(read, s.Players);
                           break;
                        case 'B':
                           ReadAll(read, s.Bombs);
                           break;
                        case 'M':
                           s.InitMap();
                           for (int y = 0; y < s.H; y++) {
                              line = read();
                              int x = 0;
                              foreach (var @char in line)
                                 s.Map[x++, y] = (byte)@char;
                           }
                           rcv = false;
                           read();
                           break;
                        case 'E': // various ends
                           if (line == "ENDOFROUND") {
                              win = true;
#if DEBUG
                        Console.WriteLine("wooohow \\o/ springfield");
#endif
                           }
                           break;
                        case 'D': // EAD :(
#if DEBUG
                     Console.WriteLine("DIED :(");
#endif
                           dead = true;
                           continue;
                        default:
                           sp[line[0]].SetValue(s, N());
                           break;
                     }
                  }

                  if (dead || win)
                     continue;
                  #endregion

                  #region detect sudden death mode
                  if (!suddenDeathDetected && s.Bombs.Count > 5 && (s.Bombs.Count - 2) > s.Players.Count) {
                     suddenDeathDetected = true;
#if DEBUG
               Console.WriteLine("!!! SUDDEN DEATH DETECTED !!!");
#endif
                  }
                  #endregion

                  #region see the future
                  if (Tick == 0 || Fut[0].Length != s.Map.Length) {
                     // initial setup of future
                     for (int i = 0; i <= BTTB; i++)
                        Fut[i] = s.Map.BlockCopy(new byte[s.W, s.H]);
                  } else {
                     var last = _(Tick - 1);
                     Fut[_(Tick - 2)].BlockCopy(Fut[last]);
                     for (int x = 0; x < s.W; x++)
                        for (int y = 0; y < s.H; y++) {
                           var t = Fut[last][x, y];
                           if (t == TILE.Boom)
                              Fut[last][x, y] = TILE.Grass;
                           else if (t <= BTTB && t > 0)
                              Fut[last][x, y] = (byte)(t - 1);
                        }
                  }

#if VALIDATEFUT
            // validate the future
            for (int x = 0; x < s.W; x++)
               for (int y = 0; y < s.H; y++)
                  if (Fut[_(Tick)][x, y] != s.Map[x, y])
                     if (!((Fut[_(Tick)][x, y] <= BTTB || Fut[_(Tick)][x, y] == TILE.Boom) && s.Map[x, y] == TILE.Grass))
                        throw new Exception("future ain't what it used to be...");
#else
                  // accept reality
                  Fut[_(Tick)] = s.Map;
#endif
                  #endregion

                  #region integrate newborn explosive devices
                  foreach (var newBomb in s.Bombs.Where(p => p.T == BTTB)) {
                     int t;
                     for (t = 0; t < BTTB; t++) {
                        var c = Fut[_(Tick + t)].At(newBomb);
                        Fut[_(Tick + t)].SetAt(newBomb, (byte)(BTTB - t));
                        if (c == TILE.Boom)
                           break;
                     }

                     int boomT = _(Tick + t);
                     Fut[boomT].SetAt(newBomb, TILE.Boom);

                     // sim BoOoOoM
                     for (int dir = 0; dir < 4; dir++) {
                        for (int dist = 1; dist < 3; dist++) {
                           var p = newBomb.Offset((Dir)dir, dist);
                           if (p.X < 0 || p.X >= s.W || p.Y < 0 || p.Y >= s.H)
                              continue;
                           var current = Fut[boomT].At(p);
                           if (current != TILE.Wall)
                              Fut[boomT].SetAt(p, TILE.Boom);
                           if (current != TILE.Grass)
                              break;
                        }
                     }
                  }
                  #endregion

                  #region integrate future into heatmap
                  Hot = new byte[s.W, s.H];
                  for (int x = 0; x < s.W; x++)
                     for (int y = 0; y < s.H; y++)
                        for (int g = 0; g < Fut.Length; g++)
                           if (Fut[g][x, y] != TILE.Grass) {
                              Hot[x, y] = 1;
                              break;
                           }
                  #endregion

                  #region create reachabilitystudy
                  var distGeographically = s.Study(Fut, s);
                  var distDict = new Dictionary<int, List<Step>>();
                  for (int x = 0; x < s.W; x++)
                     for (int y = 0; y < s.H; y++) {
                        var step = distGeographically[x, y];
                        if (step == null) continue; // can't get there bro
                        var dist = step.Distance;
                        if (!distDict.ContainsKey(dist))
                           distDict.Add(dist, new List<Step>());
                        distDict[dist].Add(step);
                     }
                  #endregion

                  #region decide action
                  var deadIn = Fut.IndexOf(p => p.At(s) == TILE.Boom);
                  if (deadIn != -1 || suddenDeathDetected) {
                     deadIn += Fut.Length - _(Tick);
                     deadIn %= Fut.Length;
                     deadIn--;
#if DEBUG
               Console.Write("survive: ");
#endif
                     var survivalDodgeMove =
                     distDict[distDict.Max(p => p.Key)]
                     .OrderBy(p => {
                        int count;
                        FloodFill(p, Hot, FLOODHEAT.COLD, FLOODHEAT.HOT, out count);

                        return (double)count
                           + (double)p.AllSteps.Count(q => Hot.At(q) == 0)
                           / (double)p.AllSteps.Count();
                     }).First().FirstValidStep.Direction;
                     move(survivalDodgeMove);
                  } else {
                     var classified = new Dictionary<int, List<Step>>();
                     for (int i = 0; i < 9; i++)
                        classified[i] = new List<Step>();

                     var idleAnyway = nextBombAvailableIn();
                     int tryMore = 0;
                     Step decision = null;
                     do {
                        var targetMap = Fut[_(Tick - 1)];

                        foreach (var dist in distDict.Keys.OrderBy(p => p)) {
                           foreach (var path in distDict[dist].OrderBy(p => rnd.Next())) {
                              var areaOfEffect = 0;

                              for (int dir = 0; dir < 4; ++dir)
                                 for (int d = 1; d < 3; ++d) {
                                    var burningMan = path.Offset((Dir)dir, d);
                                    if (burningMan.X < 0 || burningMan.X >= s.W || burningMan.Y < 0 || burningMan.Y >= s.H)
                                       continue;
                                    var collateral = targetMap.At(burningMan);
                                    if (collateral == TILE.Dirt)
                                       ++areaOfEffect;
                                    areaOfEffect += s.Players.Count(p => p.CompareTo(burningMan) == 0);
                                    if (collateral != TILE.Grass)
                                       break;
                                 }

                              var bestAlternative = classified[areaOfEffect].FirstOrDefault();
                              if (bestAlternative == null
                                 || bestAlternative.Distance == path.Distance
                                 || path.Distance < (idleAnyway + tryMore))
                                 classified[areaOfEffect].Add(path);
                           }
                        }

                        foreach (var study in classified.OrderByDescending(p => p.Key)) {
                           foreach (var idea in study.Value.OrderBy(p => p.Distance)) {
                              int count;
                              var workingArea = FloodFill(idea, targetMap, TILE.Grass, TILE.Grass, out count);
                              --count; // da bomb, da bass
                              for (int dir = 0; dir < 4; ++dir)
                                 for (int d = 1; d < 3; ++d) {
                                    var check = idea.Offset((Dir)dir, d);
                                    if (check.X >= 0 && check.X < s.W && check.Y >= 0 && check.Y < s.H)
                                       if (workingArea.At(check) == TILE.Grass)
                                          --count;
                                 }
                              if (count > 0) {
                                 decision = idea;
                                 break;
                              }
                           }
                           if (decision != null)
                              break;
                        }

                        ++tryMore;
                     } while (decision == null && tryMore < 10);

#if DEBUG
               Console.Write("tactic: ");
#endif
                     if (decision == null)
                        send("SAY .oO(???)");
                     else if (decision.Distance < idleAnyway)
                        send("SAY fap fap");
                     else if (decision.Distance == 0) {
                        mybombs.Add(new Bomb(decision) { T = BTTB });
                        send("BOMB");
                     } else
                        move(decision.FirstValidStep.Direction);
                  }
                  #endregion
               }
            } catch (Exception x) {
               Console.WriteLine("oopsie: {0}", x);
            }
         }
      }
   }
}
