import random
import socket
import sys
import math
import time
import operator
import json
from random import shuffle
#import pygame

last_JSON = None

class AI:
	gamestate = ""
	data = ""
	width = ""
	height = ""
	Map = ""
	Players = ""
	Bombs = ""
	Fuses = ""
	px = None
	py = None
	oldPx = ""
	oldPy = ""

	grid = ""
	score = ""
	oldScore = ""

	safe = True
	bombDropped = False
	bx = 0
	by = 0
	suddenDeath = False
	playerCount = 1
	bombCount = 0
	dead = True
	deadScreenshot = False

	moves = []
	circleCount = 0

	debug = False

	def __init__(self, s=None):
		if s is None:
			self.s = socket.socket(
			socket.AF_INET, socket.SOCK_STREAM)
		else:
			self.s = s

	def connect(self, host, port):
		print "* Connecting to", host, port
		try:
			self.s.connect((host, port))
		except Exception, e:
			print >>sys.stderr, e
			sys.exit(1)

	def name(self, nick):
		print "* Sending name:", nick
		self.s.send("NAME %s\n" % (nick))

	def sleep(self, sec):
		time.sleep(sec)

	def nudge(self):
		return random.uniform(-0.5, 0.5)

	def walk(self, direction):
		print "  * Walk:", direction
		self.moves.insert(0, direction)
		if len(self.moves) == 5:
			self.moves.pop()

		if "up" in self.moves and "down" in self.moves and "left" in self.moves and "right" in self.moves:
			self.circleCount += 1

		if self.circleCount == 5:
			print "    !!!!! stop walking in circles..."
			self.circleCount = 0
			self.randomWalk()
			return False

		self.score[self.py][self.px] -= 1

		if (direction == "up"):
 			self.s.send("UP\n")
			self.py = self.py - 1
 		elif (direction == "down"):
 			self.s.send("DOWN\n")
			self.py = self.py + 1
 		elif (direction == "left"):
 			self.s.send("LEFT\n")
			self.px = self.px - 1
 		elif (direction == "right"):
 			self.s.send("RIGHT\n")
			self.px = self.px + 1

	def say(self, msg):
		print "* Say:", msg
		self.s.send("SAY %s\n" % (msg))

	def bomb(self):
		print "* Bomb"
		self.Bombs[self.py][self.px] = "b"
		self.s.send("BOMB\n")

	def setJSON(self):
		print "* JSON"
		self.s.send("JSON\n")

	def getJSON(self):
		global last_JSON

		while True:
			buff = self.s.recv(4096)
			if last_JSON == None:
				last_JSON = time.time()
			else:
				new_JSON = time.time()
				#print "delta JSON:",(new_JSON-last_JSON)
				last_JSON = new_JSON
			if buff[-1] == '\n':
				return "".join(buff)

###############################################################################
# UPDATES
###############################################################################

	def reset(self):
		self.dead = False
		self.deadScreenshot = False
		self.score = [[0 for x in xrange(self.data["width"])] for x in xrange(self.data["height"])]
		self.circleCount = 0

	def update(self):
		JSON = self.getJSON()

		for JSON_line in JSON.split('\n'): 
			if len(JSON_line) == 0:
				continue
			try:
				self.data = json.loads(JSON_line)
				state = self.data["type"]

				if state == "status update":
					self.gamestate = "playing"

					if self.dead:
						self.reset()

					self.grid = [[0 for x in xrange(self.data["width"])] for x in xrange(self.data["height"])]

					self.playerCount = 1
					self.bombCount = 0

					self.updateMap()
					self.updateBombs()
					self.updatePlayers()
					self.updateScores()
					self.bleedMap()
			
					#print "PLAYER vs BOMBS:", self.playerCount, self.bombCount
					if self.bombCount > self.playerCount and not self.suddenDeath:
						print "!! SUDDEN DEATH !!"
						self.suddenDeath = True

				elif state == "dead":
					print "!! DEAD"
					self.gamestate = "dead"
					self.dead = True
				elif state == "round end": # BUG: end round
					print "!! EOR"
					self.gamestate = "endround"
					self.dead = True # TODO: not dead ;)
				else:
					print "type error: " + type
					self.gamestate = "error"

			except ValueError, e:
				print "ERROR: parsing json",e

	def updateMap(self):
		m = self.data["map"]
		self.width = self.data["width"]
		self.height = self.data["height"]
		self.Map = [[0 for x in xrange(self.width)] for x in xrange(self.height)]

		for y, line in enumerate(m):
			for x, tile in enumerate(line):
				self.Map[y][x] = str(tile)
				if self.Map[y][x] == "#":
					self.grid[y][x] = 4
				elif self.Map[y][x] == "+":
					self.grid[y][x] = 5

	def updatePlayers(self):
		self.Players = [["." for x in xrange(self.data["width"])] for x in xrange(self.data["height"])]
		self.oldPx = self.px
		self.oldPy = self.py
		self.px = self.data["x"]
		self.py = self.data["y"]
		self.Players[self.py][self.px] = "m"
		self.grid[self.py][self.px] = 1
		if self.oldPx:
			self.score[self.oldPy][self.oldPx] = self.score[self.oldPy][self.oldPx] - 0.05


		for player in self.data["players"]:
			self.playerCount += 1
			i = player["id"]
			x = player["x"]
			y = player["y"]
			self.Players[y][x] = i
			self.grid[y][x] = 3
			if not self.suddenDeath:
				if self.bombDropped:
					self.score[y][x] -= 10
				else:
					self.score[y][x] += 10
			else:
				self.score[y][x] -= 10


	def updateBombs(self):
		self.Bombs = [["." for x in xrange(self.width)] for x in xrange(self.height)]
		self.Fuses = [["." for x in xrange(self.width)] for x in xrange(self.height)]

		for bomb in self.data["bombs"]:
			x = bomb["x"]
			y = bomb["y"]

			self.bombCount += 1

			fuse = bomb["state"]
			self.addBomb(x, y, fuse)
			self.grid[y][x] = 2
			#self.Map[y][x] = str(fuse)

		self.updateFuses()

	def updateScores(self):
		# center magic
		mx = int(self.width/2)
		my = int(self.height/2)
		self.score[my][mx] += 0.5

		for y, line in enumerate(self.Map):
			for x, tile in enumerate(line):
				self.score[y][x] += self.nudge()
				#if self.Map[y][x] == "#":
					#self.score[y][x] = 5
					#self.score[y][x] = self.score[y][x] + 0.2
				# BUG ?
				#if self.Map[y][x] == ".":
				if self.Map[y][x] == "#":
					self.score[y][x] += 2#self.bombValue(x,y)*0.5
				elif self.Map[y][x] == "+":
					self.score[y][x] = -1
					#self.score[y][x] = 0
				#if self.isTrap(x,y):
				#	self.score[y][x] = self.score[y][x] - 0.1

###############################################################################
# BOMBS AND FUSES
###############################################################################

	def addBomb(self, x, y, fuse):
			self.Bombs[y][x] = "b"
			self.addFuse(x, y, fuse)

			# fuse x positive
			for xPos in range(x + 1, x + 3):
				if not self.isWall(xPos-1, y):
					self.addFuse(xPos, y, fuse)
			# fuse x negative
			for xNeg in range(x - 2, x):
				if not self.isWall(xNeg+1, y):
					self.addFuse(xNeg, y, fuse)
			# fuse y positive
			for yPos in range(y + 1, y + 3):
				if not self.isWall(x, yPos-1):
					self.addFuse(x, yPos, fuse)
			# fuse y negative
			for yNeg in range(y - 2, y):
				if not self.isWall(x, yNeg+1):
					self.addFuse(x, yNeg, fuse)

	def addFuse(self, x, y, fuse):
		if self.inBounds(y, x) and not self.isWall(x, y):
			if fuse < self.Fuses[y][x]:
				self.Fuses[y][x] = fuse
				self.grid[y][x] = 6
				#self.score[y][x] -= 3

	# if explosion hits another bomb - update fuse
	def updateFuses(self):
		for bomb in self.data["bombs"]:
			x = bomb["x"]
			y = bomb["y"]
			fuse = bomb["state"]

			# fuse x positive
			for xPos in range(x + 1, x + 3):
				if self.isBomb(xPos, y):
					self.calcFuse(x, y, xPos, y)
			# fuse x negative
			for xNeg in range(x - 2, x):
				if self.isBomb(xNeg, y):
					self.calcFuse(x, y, xNeg, y)
			# fuse y positive
			for yPos in range(y + 1, y + 3):
				if self.isBomb(x, yPos):
					self.calcFuse(x, y, x, yPos)
			# fuse y negative
			for yNeg in range(y - 2, y):
				if self.isBomb(x, yNeg):
					self.calcFuse(x, y, x, yNeg)

	def isBomb(self, x, y):
		try:
			if self.inBounds(y, x) and not self.isWall(x, y):
				if self.Bombs[y][x] == "b":
					return True
				else:
					return False
			else:
				return False
		except:
			pass

	def calcFuse(self, x1, y1, x2, y2):
		if self.Fuses[y1][x1] < self.Fuses[y2][x2]:
			self.addBomb(x1, y1, self.Fuses[y2][x2])
		else:
			self.addBomb(x2, y2, self.Fuses[y1][x1])

	def cellBombValue(self,x,y):
		if self.inBounds(x,y):
			if self.isOtherPlayer(x,y):
				return 10
			elif self.Map[y][x] == "#":
				return 1
			elif self.isBomb(x,y):
				return 2
		return 0

	def bombValue(self,x,y):
		if self.isWall(x,y):# or not self.canEscape(x,y):
			return 0
		value = 0
		for i in range(1,3):
			if self.isTile(x+i-1,y,'.'): value = value + self.cellBombValue(x+i,y)
			if self.isTile(x-i+1,y,'.'): value = value + self.cellBombValue(x-i,y)
			if self.isTile(x,y+i-1,'.'): value = value + self.cellBombValue(x,y+i)
			if self.isTile(x,y-i+1,'.'): value = value + self.cellBombValue(x,y-i)
		return value


###############################################################################
# HELPER FUNCTIONS
###############################################################################

	def isTile(self, x, y, tile):
		if (self.Map[y][x] == tile):
			return True
		else:
			return False

	def isWall(self, x, y):
		try:
			if self.inBounds(y, x):
				tile = self.Map[y][x]
				#print "isWall:", x, y, tile
				if tile == "+" or tile == "#":
					return True
				else:
					return False
		except:
			#print x,y,length(self.Map)
			pass

	def isOtherPlayer(self, x, y):
		if not self.inBounds(x,y):
			return False
		tile = self.Players[y][x]
		if tile == ".":
			return False
		else:
			return True
	def isPlayer(self, x, y):
		return self.isOtherPlayer(x,y) or (x == self.px and y == self.py)

	def isTrap(self, x, y):
		count = 0
		if self.isWall(x+1,y): count = count + 1
		if self.isWall(x-1,y): count = count + 1
		if self.isWall(x,y+1): count = count + 1
		if self.isWall(x,y)-1: count = count + 1
		return count >= 2

	# is pos safe from exploding bombs?
	def isSafe(self, x, y, threshold):
		fuse = self.Fuses[y][x]
		#if fuse <= threshold:
		if not fuse == ".":
			return False
		else:
			return True

	def inBounds(self, x, y):
		try:
			value = self.Map[y][x]
			return True
		except:
			return False

		#	if x < 0 or x >= self.width:
		#		return False 
		#	elif y < 0 or y >= self.height:
		#		return False
		#	else:
		#		return True

	def printArray(self, array):
		for y in range(self.height):
			for x in range(self.width):
				sys.stdout.write(str(array[y][x]))
			print ""

	def canMove(self, x, y, direction):
		nx = x
		ny = y

		if (direction == "up"):
			ny = y - 1
		elif (direction == "down"):
			ny = y + 1
		elif (direction == "left"):
			nx = x - 1
		elif (direction == "right"):
			nx = x + 1
		else:
			print "ERROR: illegal direction"

		if self.isWall(nx, ny):
			return False
		elif self.isOtherPlayer(nx, ny):
			return False
		elif self.isBomb(nx, ny):
			return False
		else:
			return True

	def isSafeToMove(self, direction):
		nx = self.px
		ny = self.py

		if (direction == "up"):
			ny = self.py - 1
	 	elif (direction == "down"):
			ny = self.py + 1
	 	elif (direction == "left"):
			nx = self.px - 1
	 	elif (direction == "right"):
			nx = self.px + 1
		else:
			print "ERROR: illegal direction"

		if self.isSafe(nx, ny, 4):
			return True
		else:
			return False

	def canEscape(self, x,y):

		if self.canMove(x, y, "up"):
			if self.canMove(x, y - 1, "left") and self.isSafe(x-1,y-1,5):
				return True
			elif self.canMove(x, y - 1, "right") and self.isSafe(x+1,y-1,5):
				return True
			#elif self.canMove(x, y-2, "up") and self.isSafe(x,y-2,5):
				return True
		elif self.canMove(x, y, "down"):
			if self.canMove(x, y + 1, "left") and self.isSafe(x-1,y+1,5):
				return True
			elif self.canMove(x, y + 1, "right") and self.isSafe(x+1,y+1,5):
				return True
			#elif self.canMove(x, y + 2, "down") and self.isSafe(x,y+2,5):
				return True
		elif self.canMove(x, y, "left"):
			if self.canMove(x - 1, y, "up") and self.isSafe(x-1,y-1,5):
				return True
			elif self.canMove(x - 1, y, "down") and self.isSafe(x-1,y+1,5):
				return True
			#elif self.canMove(x-2, y, "left") and self.isSafe(x-2,y,5):
				return True
		elif self.canMove(x, y, "right"):
			if self.canMove(x + 1, y, "up") and self.isSafe(x+1,y-1,5):
				return True
			elif self.canMove(x + 1, y, "down") and self.isSafe(x+1,y+1,5):
				return True
			#elif self.canMove(x+2, y, "right") and self.isSafe(x+2,y,5):
				return True
		return False

	def debugPrint(self):
		print "\nmap:"
		self.printArray(self.Map)
		print "\nplayers:"
		self.printArray(self.Players)
		print "\nbombs:"
		self.printArray(self.Bombs)
		print "\nFuses (5...0):"
		self.printArray(self.Fuses)
		print

	def randomWalk(self):
		directions = ["up", "down", "left", "right"]
		shuffle(directions)
		safe = False

		for direction in directions:
			if self.canMove(self.px, self.py, direction) and self.isSafeToMove(direction):
				self.walk(direction)
				return True

		return False

	def scoreWalk(self):
		print "* Score Walk"
		directions = self.getScore()
		here = self.score[self.py][self.px]
		#print "!!!!", here
		#if direction[0] == 1:
		#	self.randomWalk()
		#else:
		for d in directions:
			#print "!!!!", d
			# TODO: what?
			#if d[0] < here:
			#	break
			if self.canMove(self.px, self.py, d[1]) and self.isSafeToMove(d[1]):
				self.walk(d[1])
				return True
		return False

	def notSafe(self):
		self.safe = False
		print "Not safe to stand here!"

		# score
		#directions = self.getScore()


		# fuses
		directions = ["up", "down", "left", "right"]

		for direction in directions:
			#if self.canMove(self.px, self.py, direction[1]) and self.isSafeToMove(direction[1]):
			if self.canMove(self.px, self.py, direction) and self.isSafeToMove(direction):
				#print "* Safe to move", direction[0], direction[1]
				print "* Safe to move", direction
				#self.walk(direction[1])
				self.walk(direction)
				self.safe = True
				break


		x = self.px
		y = self.py
		if not self.safe:
			print "* NOT SAFE to move up/down/left/right"

			# score
			'''
			directions = [
				[self.score[y-1][x-1], "up", "left"],
				[self.score[y-1][x+1], "up", "right"],
				[self.score[y+1][x-1], "down", "left"],
				[self.score[y+1][x+1], "down", "right"],
				[self.score[y-1][x-1], "left", "up"],
				[self.score[y+1][x-1], "left", "down"],
				[self.score[y-1][x+1], "right", "up"],
				[self.score[y+1][x+1], "right", "down"]
			]

			#shuffle(directions)
			directions.sort(reverse=True)
			'''
			# fuses
			directions = [
				[self.Fuses[y-1][x-1], "up", "left"],
				[self.Fuses[y-1][x+1], "up", "right"],
				#[self.Fuses[y-2][x], "up", "up"],
				[self.Fuses[y+1][x-1], "down", "left"],
				[self.Fuses[y+1][x+1], "down", "right"],
				#[self.Fuses[y+2][x], "down", "down"],
				[self.Fuses[y-1][x-1], "left", "up"],
				[self.Fuses[y+1][x-1], "left", "down"],
				#[self.Fuses[y][x-2], "left", "left"],
				[self.Fuses[y-1][x+1], "right", "up"],
				[self.Fuses[y+1][x+1], "right", "down"]
				#[self.Fuses[y][x+2], "right", "right"]
			]

			shuffle(directions)

			for s, d1, d2 in directions:
				if self.canMove(self.px, self.py, d1):
					x = self.px
					y = self.py

					if d1 == "up":
						y = y - 1
					elif d1 == "down":
						y = y + 1
					elif d1 == "left":
						x = x - 1
					elif d1 == "right":
						x = x + 1

					if self.canMove(x, y, d2):
						print "** ESCAPE:", s, d1, d2
						self.walk(d1)
						self.update()
						if not self.isSafe(self.px, self.py, 5):
							self.walk(d2)
						break

	def dropBomb(self):
		print "Drop bomb?"
		# TODO: isSafe
		if not self.Fuses[self.py][self.px] == ".":
			print "  * don't drop - fuse here"
			return False
		elif not self.Fuses[self.py+1][self.px] == ".":
			print "  * don't drop - fuse here"
			return False
		elif not self.Fuses[self.py-1][self.px] == ".":
			print "  * don't drop - fuse here"
			return False
		elif not self.Fuses[self.py][self.px+1] == ".":
			print "  * don't drop - fuse here"
			return False
		elif not self.Fuses[self.py][self.px-1] == ".":
			print "  * don't drop - fuse here"
			return False
		elif self.canEscape(self.px,self.py):
			self.bomb()
			#self.update()
			self.bombDropped = True
			self.bx = self.px
			self.by = self.py
			return True
		else:
			print "    * Can't escape - don't drop!"
			self.scoreWalk()
			return False

	def getScore(self):
		directions = [
			[self.score[self.py - 1][self.px], "up"],
			[self.score[self.py + 1][self.px], "down"],
			[self.score[self.py][self.px - 1], "left"],
			[self.score[self.py][self.px + 1], "right"]
		]

		directions.sort(reverse=True)
		#print "\nScore directions:", directions
		#print
		#for dir in directions:
		#	return dir
		return directions

	def distance(self, x1, y1, x2, y2):
		return sqrt((x1 - x2) ** 2 + (y1 - y2) ** 2)

	def bleedMap(self):

		newMap = [[0 for x in xrange(self.width)] for x in xrange(self.height)]
		oldMap = self.score

		for y in range(self.height):
			for x in range(self.width):
				value = oldMap[y][x] * 0.3
				#print y, x, "value:",value
				#if value > 0:
				# up, down, left, right
				if y > 0:
					value = value + oldMap[y - 1][x]*0.15
				if y < self.height - 1:
					value = value + oldMap[y + 1][x]*0.15
				if x > 0:
					value = value + oldMap[y][x - 1]*0.15
				if x < self.width - 1:
					value = value + oldMap[y][x + 1]*0.15

				newMap[y][x] = value

		self.score = newMap

	def viz(self):
		BLACK = ( 0, 0, 0)
		WHITE = ( 255, 255, 255)
		GREEN = ( 0, 255, 0)
		RED = ( 255, 0, 0)
		BLUE = (0, 0, 255)
		GRAY = (0,255,255)
		PINK = (255,0,255)
		GUL = (255,255,0)

		width = 40 #self.width #20
		height = 40 #self.height #20
		margin = 5

		pygame.init()
		size = [640, 480]
		screen = pygame.display.set_mode(size)
		pygame.display.set_caption("bot - viz")

		font = pygame.font.Font(pygame.font.get_default_font(), 14)
		text = font.render("8", True, (0, 0, 0))

		done = False
		clock = pygame.time.Clock()

		while done == False:
			for event in pygame.event.get():
				if event.type == pygame.QUIT:
					done = True

			if self.dead and not self.deadScreenshot:
				filename = str(int(time.time())) + ".tga"
				print "TAKING SCREENSHOT:", filename
				#pygame.image.save(screen, filename)
				self.deadScreenshot = True

			screen.fill(BLACK)

			#for y, x in self.grid:
			for row in range(self.height):
				for column in range(self.width):
					color = WHITE
					if self.grid[row][column] == 1:
						color = GREEN
					elif self.grid[row][column] == 2:
						color = RED
					elif self.grid[row][column] == 3:
						color = BLUE
					elif self.grid[row][column] == 4:
						color = GRAY
					elif self.grid[row][column] == 5:
						color = PINK
					elif self.grid[row][column] == 6:
						color = GUL

					rect = pygame.draw.rect(screen,
						color,
						[(margin+width) * column + margin,
						(margin+height) * row + margin,
						width,
						height])
			
					#value = "%.3" % int(self.score[row][column])
					value = self.score[row][column]
					#text = font.render(str(self.bombValue(column,row)), 1, (0,0,0))
					text = font.render(str(value), 1, (0,0,0))
					screen.blit(text, (rect.centerx - 10, rect.centery - 10))

			clock.tick(10)
			pygame.display.flip()

		pygame.quit()
