/**
 * @author mrdoob / http://www.mrdoob.com
 *
 * Simple test shader
 */

THREE.RadialBlurShader = {

	uniforms: {
		"tDiffuse": { "type": "t", "value": null }
	},

	vertexShader: [
		"varying vec2 vUv;",

		"void main() {",
			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",

		"}"

	].join("\n"),

	fragmentShader: [
		"uniform sampler2D tDiffuse;",
		 
		// texture coordinates passed from the vertex shader
		"varying vec2 vUv;",
		 
		// some const, tweak for best look
		"const vec2 center = vec2(0.5, 0.5);",
		"const int nsamples = 10;",
		"const float blurStart = 1.0;",
		"const float blurWidth = -0.05;",
			 
		"void main()",
		"{",
			"vec2 uv = vUv - center;",
    		"vec4 c = vec4(0.0);",
    		"for(int i = 0; i < nsamples; i++) {",
    			"float scale = blurStart + blurWidth * (float(i) / float(nsamples - 1));",
    			"c += texture2D(tDiffuse, uv * scale + center );",
   			"}",
   			"c /= float(nsamples);",
    		"gl_FragColor = c;",
		"}"

	].join("\n")

};
