THREE.RayMarchingPass = function (fragment_shader) {

	this.uniforms = {
		"tDiffuse": { "type": "t", "value": null },
		"var1": { "type": "f", "value": 0.0 },
		"var2": { "type": "f", "value": 0.0 },
		"var3": { "type": "f", "value": 0.0 },
		"var4": { "type": "f", "value": 0.0 },
		"var5": { "type": "f", "value": 0.0 },
		"var6": { "type": "f", "value": 0.0 },
		"var7": { "type": "f", "value": 0.0 },
		"iResolution": { "type": "v3", "value": new THREE.Vector3(wWidth, wHeight, 0.0) }
	}

	this.material = new THREE.ShaderMaterial({
		uniforms: this.uniforms,
		vertexShader: shaders.vertexShader_generic,
		fragmentShader: fragment_shader
	});

	this.enabled = true;
	this.renderToScreen = false;
	this.needsSwap = true;

	this.camera = new THREE.OrthographicCamera( -1, 1, 1, -1, 0, 1 );
	this.scene  = new THREE.Scene();

	this.quad = new THREE.Mesh( new THREE.PlaneGeometry( 2, 2 ), null );
	this.scene.add( this.quad );

};

THREE.RayMarchingPass.prototype = {

	setVar: function (varName, t) {
		this.uniforms[varName].value = t;
	},

	render: function ( renderer, writeBuffer, readBuffer, delta ) {

		this.uniforms[ "tDiffuse" ].value = readBuffer;

		this.quad.material = this.material;

		if ( this.renderToScreen ) {

			renderer.render( this.scene, this.camera );

		} else {

			renderer.render( this.scene, this.camera, writeBuffer, false );

		}

	}

};