function lineup_rockets ()
{

	launchpad.add(scenes.title_screen, scenes.title_screen.render, 0); // 0
	launchpad.add(scenes.globe, scenes.globe.slow_zoom_to_earth, 1); // 1
	launchpad.add(scenes.globe, scenes.globe.descend, 2); // 2
	
	launchpad.add(scenes.globe, scenes.globe.orbit1, 3); // 3
	launchpad.add(scenes.globe, scenes.globe.orbit2, 4); // 4
	launchpad.add(scenes.globe, scenes.globe.orbit3, 5); // 5 
	launchpad.add(scenes.globe, scenes.globe.orbit4, 6); // 6
	launchpad.add(scenes.globe, scenes.globe.orbit5, 7); // 7

	launchpad.add(scenes.terrain, scenes.terrain.render, 8); // 8
	
	launchpad.add(scenes.staticNoise, scenes.staticNoise.render, 9); // 9

	launchpad.add(scenes.globe, scenes.globe.zoom_into_earth, 10); // 10	

	launchpad.add(scenes.globe, scenes.globe.inside_earth, 11); // 11	

	launchpad.add(scenes.tunnel, scenes.tunnel.render, 12); // 12

	launchpad.add(scenes.raymarching, scenes.raymarching.render, 13); // 13	

	launchpad.add(scenes.raymarching2, scenes.raymarching2.render, 14); // 14

	launchpad.add(scenes.globe, scenes.globe.orbit_rocket, 15); // 15

	launchpad.add(scenes.boxworm, scenes.boxworm.render, 16); // 16

	launchpad.add(scenes.microscope, scenes.microscope.render, 17); // 17

	launchpad.add(scenes.textparticles, scenes.textparticles.render, 18); // 17
}


function _launchpad()
{
	this.scenes = [];

	this.add = function(scene, func, index)
	{
		if(typeof(index) === "undefined") {
			this.scenes.push(
				{
					scene: scene,
					func: func
				}
			);	
		} else {
			this.scenes[index] = {
				scene: scene,
				func: func
			};
		}
		
	}

	this.launch = function(i)
	{
		i = Math.floor(i);

		if (i < this.scenes.length)
		{
			var percent = getVal("percent");
			if(isNaN(percent)) {
				return;
			}
			if(typeof(this.scenes[i]) !== "undefined") {
				this.scenes[i].func.apply(this.scenes[i].scene, [row / ROW_RATE, percent]);	
			}
			
		}
	}
}