/*

The loaders in three.js are a mix of blocking and non-blocking functions.
This requires us to wait until all loaders have finished loading before we can start..

Three.js' built in loader system is bloated...

To chr's knowledge:
THREE.ImageUtils.loadTexture: non-blocking
THREE.SphereGeometry: blocking

Seems like anything that uses ajax is non-blocking.

*/

var loadable_elements = 0;
var loaded_elements = 0;
var loading_started = 0;

var loader_div;
var loader_text_lines = new Array(
"  ______                     _                   _           ",
" |___  /                    | |                 (_)          ",
"    / / ___  _ __ ___   __ _| |_ _ __ ___  _ __  _  ___ ___  ",
"   / / / _ \\| '_ ` _ \\ / _` | __| '__/ _ \\| '_ \\| |/ __/ __| ",
"  / /_| (_) | | | | | | (_| | |_| | | (_) | | | | | (__\\__ \\ ",
" /_____\\___/|_| |_| |_|\\__, |\\__|_|  \\___/|_| |_|_|\\___|___/  ",
"                        __/ |                                ",
"                       |___/   "
);

var debloat = "";

function load_texture(src, debug_name)
{
	debloat += "cp "+src+" gfx2/"+src+"\n";
	loading_started = 1;
	loadable_elements += 1;
	return new THREE.ImageUtils.loadTexture(src, {}, function(){
		loader_complete_callback(debug_name);
	});
}

function load_scene (scene_object, debug_name)
{
	loading_started = 1;
	loadable_elements += 1;
	scene_object.load();
}

function loader_complete_callback (debug_name)
{
	loaded_elements += 1;
	loading_console_write("Loaded "+debug_name+" ("+loaded_elements+"/"+loadable_elements+")");
	//console.log("Loaded: "+debug_name);
}

function create_loading_console ()
{
	//$('#loading_console').css('left',document.innerWidth/2-$('#loading_console').css('width')/2);
	loading_console = document.getElementById('loading_console');
	loading_console.style.left = window.innerWidth/2-300;
	loading_console.style.display = "block";

	loading_console_write('Loaded loading helpers.');
}

function destroy_loading_console()
{
	loading_console = document.getElementById('loading_console');
	loading_console.style.display = "none";
}

function loading_console_write (text)
{
	console.log(text);

	var height = 20;
	var ascii = "";

	loader_text_lines.push(text);

	if (loader_text_lines.length>height)
	{
		loader_text_lines.reverse();
		loader_text_lines.pop();
		loader_text_lines.reverse();
	}

	for (line in loader_text_lines)
	{
		ascii += loader_text_lines[line]+"\n";
	}

	document.getElementById('loading_console_text').innerHTML = ascii;
}






