function scene_boxes () {
	this.scene_name = "Boxes";

	this.load = function() {
		loading_console_write('Creating box');

		this.camera = new THREE.PerspectiveCamera(45, 16/9, 0.1, 2000); // view angle, aspect, near, far
		this.scene = new THREE.Scene();
		
		this.axisHelper = new THREE.AxisHelper(20);

		this.scene.add(this.camera);
		this.scene.add(this.axisHelper);

		this.createSkybox();
		this.createFloor();
		this.createMirrorCube();		

		this.camera.position.set(-10, 30, -60);
		this.camera.lookAt(this.box.position);

		this.composer = new THREE.EffectComposer(renderer);

		var renderpass = new THREE.RenderPass(this.scene, this.camera);
		this.composer.addPass(renderpass);

		var vignetteShader = new THREE.ShaderPass( THREE.VignetteShader );
		vignetteShader.uniforms['offset'].value = 1.2;
		vignetteShader.uniforms['darkness'].value = 1.3;
		this.composer.addPass(vignetteShader);

		this.final_pass = new THREE.ShaderPass(FinalPassShader);
		this.final_pass.renderToScreen = true;
		this.composer.addPass(this.final_pass);

		//this.controls = new THREE.OrbitControls( this.camera, renderer.domElement );		
	}

	this.createMirrorCube = function() {
		this.mirrorCubeCamera = new THREE.CubeCamera( 0.1, 2000, 512 );
		this.scene.add( this.mirrorCubeCamera );
		var mat = new THREE.MeshBasicMaterial( { envMap: this.mirrorCubeCamera.renderTarget } );
		this.box = new THREE.Mesh(new THREE.CubeGeometry(10, 10, 10), mat);
		this.box.position.set(0, 10, 0);
		this.mirrorCubeCamera.position = this.box.position;
		this.scene.add(this.box);	
	}

	this.createSkybox = function() {
		var tex_skybox = load_texture(texture_dir+'skybox/starscape_3.jpg','starmap skybox texture');
		var skybox_material = new THREE.MeshBasicMaterial( { map: tex_skybox, side: THREE.DoubleSide } );
		var skybox_geometry = new THREE.CubeGeometry(1000, 1000, 1000);
		this.skybox = new THREE.Mesh(skybox_geometry, skybox_material);
		this.scene.add(this.skybox);
	}

	this.createFloor = function() {
		var floorTexture = load_texture( '../textures/ship_panel.png' );
		floorTexture.wrapS = floorTexture.wrapT = THREE.RepeatWrapping; 
		floorTexture.repeat.set( 100, 100 );
		var floorMaterial = new THREE.MeshBasicMaterial( { map: floorTexture, side:THREE.BackSide } );
		var floorGeometry = new THREE.PlaneGeometry(1000, 1000, 1, 1);
		this.floor = new THREE.Mesh(floorGeometry, floorMaterial);
		this.floor.position.y = -0.5;
		this.floor.rotation.x = Math.PI / 2;
		this.scene.add(this.floor);
	}

	this.render = function(scene_time) {
		this.box.rotation.x = Math.sin(scene_time / 10.0) * (2 * Math.PI);
		this.box.rotation.y = Math.cos(scene_time / 10.0) * (2 * Math.PI);

		this.box.visible = false;
		this.mirrorCubeCamera.updateCubeMap( renderer, this.scene );
		this.box.visible = true;

		this.composer.render();
		//renderer.render(this.scene, this.camera);
	}
}