function scene_boxworm ()
{
	this.load = function()
	{
		var i;
		tex.boxworm_floor = load_texture(texture_dir+'boxworm/metall010-new-tileable.png','metal floor');
		tex.boxworm_floor_nm = load_texture(texture_dir+'boxworm/metall010-new-tileable-nm.png','metal floor nm');
		tex.boxworm = load_texture(texture_dir+'boxworm/metall003-new.png','boxworm');

		tex.boxworm_wall = load_texture(texture_dir+'boxworm/rust/rust_DIFFUSE.jpg','metal wall');
		tex.boxworm_wall_nm = load_texture(texture_dir+'boxworm/rust/rust_NORMAL.jpg','metal wall nm');

		tex.boxworm_warn = load_texture(texture_dir+'boxworm/restriction_lines/warning_DIFFUSE.jpg','warning');
		tex.boxworm_warn_nm = load_texture(texture_dir+'boxworm/restriction_lines/warning_NORMAL.jpg','warning nm');

		tex.boxworm_warnbox = load_texture(texture_dir+'boxworm/metal.jpg','warningbox');
		tex.boxworm_warnbox_nm = load_texture(texture_dir+'boxworm/BubbleGrip-NormalMap.png','warningbox nm');


		tex.smallearth = load_texture(texture_dir+'boxworm/smallearth.jpg','earthworm');


		this.numboxes = 220;

		this.scene = new THREE.Scene();
		this.camera = new THREE.PerspectiveCamera(55.0, wWidth / wHeight, 0.5, 300000);
		this.camera.position.set(0,10,0);
		//this.camera.lookAt(this.scene.position);
		//this.camera.lookAt({x:0,y:5,z:-30});
		this.scene.add(this.camera);

		this.ambient = new THREE.AmbientLight(0x505050);
		this.scene.add(this.ambient);

		this.numpointlights = 4;
		this.pointintensity = 2;
		this.pointlights = [];

		for (i=0; i<this.numpointlights; i++)
		{
			this.pointlights.push(new THREE.PointLight(new THREE.Color(0xFFC000), this.pointintensity, 8));
			this.scene.add(this.pointlights[i]);
		}

		this.earthlight = new THREE.PointLight(0x00ff00, 0, 12);
		this.moonlight = new THREE.PointLight(0xFFC000, 0, 12);
		this.scene.add(this.earthlight);
		this.scene.add(this.moonlight);

		//this.controls = new THREE.OrbitControls( this.camera, renderer.domElement );
		this.renderpass = new THREE.RenderPass(this.scene, this.camera);

		

		this.worm_material = new THREE.MeshPhongMaterial(
			{
				map: tex.boxworm
			}
		);


			this.test_uniforms = {
				texture: { type: "t", value: tex.boxworm },
				cube: { type: "i", value: 1 },
				glow: { type: "f", value: 0 },
				scale: { type: "f", value: 1 },
				ambient: { type: "f", value: 0.7 },
				glowColor: { type: "c", value: new THREE.Color(0x80e3ff) }
			}

			this.test_material = new THREE.ShaderMaterial(
			{
				uniforms: this.test_uniforms,
				vertexShader: shaders.vertexShader_innerglow,
				fragmentShader: shaders.fragmentShader_innerglow,
				side: THREE.FrontSide,
				blending: THREE.NormalBlending,
				transparent: false
			}
			);


		var plate = new THREE.PlaneGeometry(10,10,1,1);
		this.floor_material = new THREE.MeshPhongMaterial({
			map: tex.boxworm_floor,
			normalMap: tex.boxworm_floor_nm,
			shininess: 0.1
		});

		this.wall_material = new THREE.MeshPhongMaterial({
			map: tex.boxworm_wall,
			normalMap: tex.boxworm_wall_nm,
			shininess: 0.1
		});

		this.room = new THREE.Object3D();

		var floorplate1 = new THREE.Mesh(plate, this.floor_material);
		floorplate1.rotation.set(deg2rad(-90),0,0);
		var floorplate2 = floorplate1.clone();
		var floorplate3 = floorplate1.clone();
		var floorplate4 = floorplate1.clone();
		var floorplate5 = floorplate1.clone();
		var floorplate6 = floorplate1.clone();
		var floorplate7 = floorplate1.clone();
		var floorplate8 = floorplate1.clone();

		floorplate7.position.set(0,0,10);
		floorplate2.position.set(0,0,-10);
		floorplate3.position.set(0,0,-20);
		floorplate4.position.set(0,0,-30);
		floorplate5.position.set(10,0,-30);
		floorplate6.position.set(20,0,-30);
		floorplate8.position.set(30,0,-30);

		this.room.add(floorplate1);
		this.room.add(floorplate2);
		this.room.add(floorplate3);
		this.room.add(floorplate4);
		this.room.add(floorplate5);
		this.room.add(floorplate6);
		this.room.add(floorplate7);
		this.room.add(floorplate8);

		var roofplate1 = floorplate1.clone();
		roofplate1.rotation.set(deg2rad(90),0,0);
		roofplate1.position.set(0,10,0);
		var roofplate2 = roofplate1.clone();
		var roofplate3 = roofplate1.clone();
		var roofplate4 = roofplate1.clone();
		var roofplate5 = roofplate1.clone();
		var roofplate6 = roofplate1.clone();
		var roofplate7 = roofplate1.clone();
		var roofplate8 = roofplate1.clone();

		roofplate7.position.set(0,10,10);
		roofplate2.position.set(0,10,-10);
		roofplate3.position.set(0,10,-20);
		roofplate4.position.set(0,10,-30);
		roofplate5.position.set(10,10,-30);
		roofplate6.position.set(20,10,-30);
		roofplate8.position.set(30,10,-30);

		this.room.add(roofplate1);
		this.room.add(roofplate2);
		this.room.add(roofplate3);
		this.room.add(roofplate4);
		this.room.add(roofplate5);
		this.room.add(roofplate6);
		this.room.add(roofplate7);
		this.room.add(roofplate8);

		this.neonLight = new THREE.PointLight(0xffff00, 5.2, 8);
		this.neonLight.position.set(-4, 1.1, -17);
		this.scene.add(this.neonLight);

		this.neonLight2 = new THREE.PointLight(0xffff00, 5.2, 8);
		this.neonLight2.position.set(-4, 1.6, -24);
		this.scene.add(this.neonLight2);

		this.neonLight3 = new THREE.PointLight(0xffff00, 5.2, 8);
		this.neonLight3.position.set(-4, 1.4, -20);
		this.scene.add(this.neonLight3);
/*
		var plh = new THREE.PointLightHelper(this.neonLight, 0.2);
		this.scene.add(plh);
		plh = new THREE.PointLightHelper(this.neonLight2, 0.2);
		this.scene.add(plh);
*/
		this.neonColors = {
			true: {
				"inner": new THREE.Color(1.0, 1.0, 1.0),
				"outer": new THREE.Color(1.0, 1.0, 0.0)
			},
			false: {
				"inner": new THREE.Color(0.5, 0.5, 0.5),
				"outer": new THREE.Color(0.3, 0.3, 0.3)
			}
		}

		this.neonMaterial = new THREE.ShaderMaterial({
			uniforms: {
				"OuterColor": { "type": "c", "value": this.neonColors[true]["outer"] },
				"InnerColor": { "type": "c", "value": this.neonColors[true]["inner"] }
			},
			vertexShader: shaders.vertexShader_microscope,
			fragmentShader: shaders.fragmentShader_microscope
		});

		var loader = new THREE.JSONLoader();
		loader.load( "models/zomgtronics.js", function( geometry ) {
			var mesh = new THREE.Mesh( geometry, scenes.boxworm.neonMaterial );
			mesh.scale.x = mesh.scale.y = mesh.scale.z = 0.05;
			mesh.rotation.set(-1.41, 1.37, 1.4);
			mesh.position.set(-4.8, 2.05, -21);
			scenes.boxworm.zomgtronics = mesh;
			scenes.boxworm.scene.add( mesh );
		});

		// Saftblander "light bulb"

		var saftbulb_material = new THREE.ShaderMaterial({
			uniforms: {
				"OuterColor": { "type": "c", "value": new THREE.Color(0x000000) },
				"InnerColor": { "type": "c", "value": new THREE.Color(0xFFAEAE) }
			},
			vertexShader: shaders.vertexShader_microscope,
			fragmentShader: shaders.fragmentShader_microscope,
			side: THREE.DoubleSide
		});
		var saftbulb_material = new THREE.MeshPhongMaterial({
				color: 0xffffff,
				side: THREE.DoubleSide,
				shininess: 100
			});

		this.saftbulb = new THREE.Object3D();

		var saftbulb_geo = new THREE.CubeGeometry(0.4,0.1,0.6);
		var saftblock = new THREE.Mesh(saftbulb_geo, saftbulb_material);
		//this.saftbulb.add(saftblock);
		
		var saftbulb1_geo = new THREE.SphereGeometry(0.2, 20, 20, 0, Math.PI, 0, Math.PI);
		var saftbulb1 = new THREE.Mesh(saftbulb1_geo, saftbulb_material);
		var saftbulb2 = saftbulb1.clone();
		saftbulb1.position.set(0,0.2,0);
		saftbulb1.rotation.set(deg2rad(90),0,0);
		saftbulb2.position.set(0,-0.2,0);
		saftbulb2.rotation.set(deg2rad(-90),0,0);
		
		this.saftbulb.add(saftbulb1);
		this.saftbulb.add(saftbulb2);

		this.saftbulb.position.set(0, 5, -35 + 0.4);
		this.scene.add(this.saftbulb);


		loader.load( "models/saftblander.js", function( geometry, materials ) {
			materials[1].transparent = true;
			materials[1].blending = THREE.AdditiveBlend;
			var mesh = new THREE.Mesh( geometry, new THREE.MeshFaceMaterial(materials) );
			mesh.scale.x = mesh.scale.y = mesh.scale.z = 0.05;
			mesh.rotation.set(Math.PI/2, 0, 0);
			mesh.position.set(0, 5, -35);
			scenes.boxworm.saftblander = mesh;
			scenes.boxworm.scene.add( mesh );
		});

		this.saftblanderLight = new THREE.PointLight(0xff0000, 6.0, 4);
		this.saftblanderLight.position.set(0.2, 5, -35+0.15);
		this.scene.add(this.saftblanderLight);

		//var wallplate1 = floorplate1.clone();
		var wallplate1 = new THREE.Mesh(plate, this.wall_material);
		wallplate1.rotation.set(0,deg2rad(180),0);
		wallplate1.position.set(0,5,10);
		this.room.add(wallplate1);

		var wallplate2 = wallplate1.clone();
		wallplate2.rotation.set(0,deg2rad(-90),0);
		wallplate2.position.set(30,5,-30);
		this.room.add(wallplate2);

		for (i=0; i<5; i++)
		{
			var wallplate = wallplate1.clone();
			wallplate.rotation.set(0,deg2rad(90),0);
			wallplate.position.set(-5,5,10-i*10);
			this.room.add(wallplate);

			if (i<4)
			{
				var wallplate = wallplate1.clone();
				wallplate.rotation.set(0,deg2rad(-90),0);
				wallplate.position.set(5,5,10-i*10);
				this.room.add(wallplate);				
			}
		}

		for (i=0; i<4; i++)
		{
			var wallplate = wallplate1.clone();
			wallplate.rotation.set(0,0,0);
			wallplate.position.set(i*10,5,-35);
			this.room.add(wallplate);

			if (i>0)
			{
				var wallplate = wallplate1.clone();
				wallplate.rotation.set(0,deg2rad(180),0);
				wallplate.position.set(i*10,5,-25);
				this.room.add(wallplate);
			}
		}




		/*
		var wallplate2 = wallplate1.clone();
		var wallplate3 = wallplate1.clone();
		var wallplate4 = wallplate1.clone();
		var wallplate5 = wallplate1.clone();
		var wallplate6 = wallplate1.clone();

		var wallplate7 = wallplate1.clone();
		var wallplate8 = wallplate1.clone();
		var wallplate9 = wallplate1.clone();
		var wallplate10 = wallplate1.clone();

		wallplate1.position.set(0,5,10);

		wallplate2.rotation.set(0,deg2rad(90),0);
		wallplate2.position.set(-5,5,10);

		wallplate3.rotation.set(0,deg2rad(90),0);
		wallplate3.position.set(-5,5,0);

		wallplate4.rotation.set(0,deg2rad(90),0);
		wallplate4.position.set(-5,5,-10);

		wallplate5.rotation.set(0,deg2rad(90),0);
		wallplate5.position.set(-5,5,-20);

		wallplate6.rotation.set(0,deg2rad(90),0);
		wallplate6.position.set(-5,5,-30);

		wallplate7.rotation.set(0,0,0);
		wallplate7.position.set(0,5,-35);



		this.scene.add(wallplate1);
		this.scene.add(wallplate2);
		this.scene.add(wallplate3);
		this.scene.add(wallplate4);
		this.scene.add(wallplate5);
		this.scene.add(wallplate6);
		this.scene.add(wallplate7);
		this.scene.add(wallplate8);
		this.scene.add(wallplate9);
		this.scene.add(wallplate10);*/

		this.moon_uniforms = {
			texture: { type: "t", value: tex.moon },
			cube: { type: "i", value: 1 },
			glow: { type: "f", value: 0 },
			scale: { type: "f", value: 1 },
			ambient: { type: "f", value: 0.7 },
			glowColor: { type: "c", value: new THREE.Color(0xFFC000) }
		}

		this.moon_material = new THREE.ShaderMaterial(
		{
			uniforms: this.moon_uniforms,
			vertexShader: shaders.vertexShader_innerglow,
			fragmentShader: shaders.fragmentShader_innerglow,
			side: THREE.FrontSide,
			blending: THREE.NormalBlending,
			transparent: false
		}
		);

		this.earth_uniforms = {
			texture: { type: "t", value: tex.smallearth },
			cube: { type: "i", value: 1 },
			glow: { type: "f", value: 0 },
			scale: { type: "f", value: 1 },
			ambient: { type: "f", value: 0.7 },
			glowColor: { type: "c", value: new THREE.Color(0x00ff00) }
		}

		this.earth_material = new THREE.ShaderMaterial(
		{
			uniforms: this.earth_uniforms,
			vertexShader: shaders.vertexShader_innerglow,
			fragmentShader: shaders.fragmentShader_innerglow,
			side: THREE.FrontSide,
			blending: THREE.NormalBlending,
			transparent: false
		}
		);

		this.moon_geometry = new THREE.SphereGeometry(2.0, 50,50);
		//this.moon_material = new THREE.MeshBasicMaterial({color: 0x00ffff});
		this.moon = new THREE.Mesh(this.moon_geometry, this.moon_material);
		this.moon.position.set(0,5,5);
		//this.scene.add(this.moon);
		this.moonlight.position = this.moon.position;

		this.earth_geometry = new THREE.SphereGeometry(3.5, 50, 50);
		//this.earth_material = new THREE.MeshBasicMaterial({color: 0x00ff00});
		this.earth = new THREE.Mesh(this.earth_geometry, this.earth_material);
		this.earth.position.set(25,5,-30);
		this.earth.rotation.set(0,deg2rad(158),0);
		this.scene.add(this.earth);
		this.earthlight.position = this.earth.position;

		this.sun_inside_uniforms = {
			sceneTime: { type: "f", value: 0.0 },
			scale: { type: "f", value: 1.0 },
			scaleFactor: { type: "f", value: 1.0 },
			bumpScale: { type: "f", value: 1.0 }
		};

		this.sun_inside_material = new THREE.ShaderMaterial(
			{
				uniforms: this.sun_inside_uniforms,
				vertexShader: shaders.vertexShader_sun,
				fragmentShader: shaders.fragmentShader_sun,
				side: THREE.FrontSide
			}
		);

		this.sun_inside_geometry = new THREE.SphereGeometry(2,200,200);
		this.sun_inside = new THREE.Mesh(this.sun_inside_geometry, this.sun_inside_material);
		this.sun_inside.position.set(0,5,5);
		this.scene.add(this.sun_inside);

		this.sunlight = new THREE.PointLight(0xFFC000, 4, 8);
		this.sunlight.position = this.sun_inside.position;
		this.scene.add(this.sunlight);


		var caution = new THREE.Object3D();

		var cautionwidth = 0.3;
		var cautionoffset = 0.0;

		tex.boxworm_warn.wrapS = tex.boxworm_warn.wrapT = THREE.RepeatWrapping;
		tex.boxworm_warn.repeat.set(1,20);
		tex.boxworm_warn_nm.wrapS = tex.boxworm_warn_nm.wrapT = THREE.RepeatWrapping;
		tex.boxworm_warn_nm.repeat.set(1,20);

		this.warn_material = new THREE.MeshPhongMaterial({
			map: tex.boxworm_warn,
			normalMap: tex.boxworm_warn_nm,
			shininess: 0.1
		});
		this.warnbox_material = new THREE.MeshPhongMaterial({
			map: tex.boxworm_warnbox,
			normalMap: tex.boxworm_warnbox_nm,
			shininess: 0.2
		});

		var boxgeo = new THREE.CubeGeometry(cautionwidth,10,cautionwidth,10,10);
		var tube = new THREE.Mesh(boxgeo, this.warn_material);
		tube.position.set(-5+cautionoffset,5,5);
		var tube2 = tube.clone();
		tube2.position.set(5-cautionoffset,5,5);
		var tube3 = tube.clone();
		tube3.rotation.set(0,0,deg2rad(90));
		tube3.position.set(0,10-cautionoffset,5);
		var tube4 = tube3.clone();
		tube4.position.set(0,cautionoffset,5);

		caution.add(tube);
		caution.add(tube2);
		caution.add(tube3);
		caution.add(tube4);

		var boxgeo2 = new THREE.CubeGeometry(cautionwidth*2.2,cautionwidth*2.2,cautionwidth*2.2,1,1);
		var tubebox = new THREE.Mesh(boxgeo2, this.warnbox_material);
		tubebox.position.set(5,0,5);
		caution.add(tubebox);
		tubebox2 = tubebox.clone();
		tubebox2.position.set(5,10,5);
		caution.add(tubebox2);
		tubebox3 = tubebox.clone();
		tubebox3.position.set(-5,0,5);
		caution.add(tubebox3);
		tubebox4 = tubebox.clone();
		tubebox4.position.set(-5,10,5);
		caution.add(tubebox4);

		this.room.add(caution);

		var caution2 = caution.clone();
		caution2.position.set(0,0,-10);
		this.room.add(caution2);

		var caution3 = caution.clone();
		caution3.position.set(0,0,-20);
		this.room.add(caution3);

		var caution4 = caution.clone();
		caution4.position.set(0,0,-30);
		this.room.add(caution4);

		var caution5 = caution.clone();
		caution5.position.set(0,0,-30);
		caution5.rotation.set(0,deg2rad(90),0);
		this.room.add(caution5);

		var caution6 = caution5.clone();
		caution6.position.set(10,0,-30);
		this.room.add(caution6);

		var caution7 = caution5.clone();
		caution7.position.set(20,0,-30);
		this.room.add(caution7);

		
		this.target1 = new THREE.Object3D();
		this.target2 = new THREE.Object3D();

		this.spotlight1 = new THREE.SpotLight(0xff0000, 4, 15, deg2rad(15), 1);
		this.spotlight2 = new THREE.SpotLight(0xff0000, 4, 15, deg2rad(15), 1);
		this.spotlight1.position.set(0,5,-35+0.1);
		this.spotlight2.position.set(0,5,-35+0.1);
		this.spotlight1.target = this.target1;
		this.spotlight2.target = this.target2;
		this.scene.add(this.spotlight1);
		this.scene.add(this.spotlight2);

		

		this.scene.add(this.room);
		this.blackroom = this.room.clone();
		this.scene.add(this.blackroom);

		var blackmaterial = new THREE.MeshBasicMaterial({color: 0x000000});

		for (var i = 0; i<this.blackroom.children.length; i++)
		{
			this.blackroom.children[i].material = blackmaterial;
		}





		var geometry = new THREE.Geometry();
		var points = [];
		var campoints = [];
		var index, position;

		/*for (i = 0; i < 10; i++)
		{
			points.push(
				new THREE.Vector3(Math.random() * 2, Math.random() * 2, i)
			);
		}*/
		
		var h = 0.5;

		// never doing this manually again!
		points.push(new THREE.Vector3(0, 5, 5));
		points.push(new THREE.Vector3(0, 5, 1));
		points.push(new THREE.Vector3(0, h+1, -2));
		points.push(new THREE.Vector3(1.5, h, -3.5));
		points.push(new THREE.Vector3(3.5, h, -7));
		points.push(new THREE.Vector3(0, h, -9.5));
		points.push(new THREE.Vector3(-3, h, -10));
		points.push(new THREE.Vector3(-2, h+2, -10));
		points.push(new THREE.Vector3(0, h+4, -11.5)); // høy bue fly under..
		points.push(new THREE.Vector3(2, h+4, -13.5));
		points.push(new THREE.Vector3(4, h, -16));
		points.push(new THREE.Vector3(3, h, -20));
		points.push(new THREE.Vector3(0, h+1, -24));
		points.push(new THREE.Vector3(-2, h, -26));
		points.push(new THREE.Vector3(-4, h, -30));
		points.push(new THREE.Vector3(-1, h, -33));
		points.push(new THREE.Vector3(2, h, -32));
		points.push(new THREE.Vector3(5, h, -30));
		points.push(new THREE.Vector3(7, h, -28));
		points.push(new THREE.Vector3(9, h+1, -30));
		points.push(new THREE.Vector3(13, h, -30));
		points.push(new THREE.Vector3(16, h, -32));
		points.push(new THREE.Vector3(18, h, -30));
		points.push(new THREE.Vector3(19, h+2.5, -30));
		points.push(new THREE.Vector3(20, h+5, -30));
		points.push(new THREE.Vector3(23, h+5, -30));
		

		campoints.push(new THREE.Vector3(4, 4, 3));
		campoints.push(new THREE.Vector3(4, 4, 0));
		campoints.push(new THREE.Vector3(4.5, 4, -6));
		campoints.push(new THREE.Vector3(3.5, 2.5, -9));
		campoints.push(new THREE.Vector3(0, 1, -12));
		campoints.push(new THREE.Vector3(-4, 3, -15));
		campoints.push(new THREE.Vector3(-3, 4, -20));
		campoints.push(new THREE.Vector3(-3, 4, -30));
		campoints.push(new THREE.Vector3(0, 8, -30));
		campoints.push(new THREE.Vector3(7, 5, -27));
		campoints.push(new THREE.Vector3(15, 5, -26));
		campoints.push(new THREE.Vector3(20, 2, -26));

		
		this.spline = new THREE.SplineCurve3(points);
		this.camspline = new THREE.SplineCurve3(campoints);

		/* debug line
		for (i=0; i<100; i++)
		{
			index = i/100;
			position = this.spline.getPoint(index);
			geometry.vertices[i] = new THREE.Vector3(position.x, position.y, position.z);
		}
		this.line_material = new THREE.LineBasicMaterial({color: 0xffff00, opacity: 1, linewidth: 3});
		this.line = new THREE.Line(geometry, this.line_material);
		this.scene.add(this.line);
		*/

		/* camera debug line
		var camgeometry = new THREE.Geometry();
		for (i=0; i<100; i++)
		{
			index = i/100;
			position = this.camspline.getPoint(index);
			camgeometry.vertices[i] = new THREE.Vector3(position.x, position.y, position.z);
		}
		this.cam_material = new THREE.LineBasicMaterial({color: 0x0000ff, opacity: 1, linewidth: 3});
		this.camline = new THREE.Line(camgeometry, this.cam_material);
		this.scene.add(this.camline);
		*/


		var rot;
		var scale;

		
		this.boxes = [];
		for (i=0; i < this.numboxes; i++)
		{
			index = i/this.numboxes;
			scale = 0.5+this.fakerandom(i)*0.1;
			rot = new THREE.Vector3(this.fakerandom(i*2)*Math.PI, this.fakerandom(i*3)*Math.PI, this.fakerandom(i*3)*Math.PI);

			position = this.spline.getPoint(index);
			this.boxes[i] = {};
			geometry = new THREE.CubeGeometry(1,1,1);

			this.boxes[i].rot = new THREE.Vector3(this.fakerandom(i*5)-0.5,this.fakerandom(i*6)-0.5,this.fakerandom(i*7)-0.5);

			this.boxes[i].uniforms = {
				texture: { type: "t", value: tex.boxworm },
				cube: { type: "i", value: 1 },
				glow: { type: "f", value: Math.sin(i/4)*0.5+0.5},
				ambient: { type: "f", value: 1 },
				scale: { type: "f", value: 1+Math.sin(i/4)*0.1+0.1 },
				//glowColor: { type: "c", value: new THREE.Color(0xFFC000) }
				glowColor: { type: "c", value: new THREE.Color(0x00ff00) }
			}

			this.boxes[i].material = new THREE.ShaderMaterial({
				uniforms: this.boxes[i].uniforms,
				vertexShader: shaders.vertexShader_innerglow,
				fragmentShader: shaders.fragmentShader_innerglow,
			});

			this.boxes[i].mesh = new THREE.Mesh(geometry, this.boxes[i].material);
			this.boxes[i].mesh.position.set(position.x, position.y, position.z);
			this.boxes[i].position = {x: position.x, y: position.y, z: position.z};
			this.boxes[i].mesh.rotation.set(rot.x, rot.y, rot.z);
			this.boxes[i].mesh.scale.multiplyScalar(scale);
			this.scene.add(this.boxes[i].mesh);

		}
		

		this.bloompass = new THREE.BloomPass(0.65);
		this.savepass = new THREE.SavePass(buffer1);
		this.blendpass = new THREE.ShaderPass(THREE.AdditiveBlendShader3);
		this.blendpass.uniforms['tDiffuse2'].value = buffer1;
		this.fxaaPass = new THREE.ShaderPass(THREE.FXAAShader);
		this.fxaaPass.uniforms[ 'resolution' ].value = new THREE.Vector2( 1 / wWidth, 1 / wHeight );

	}

	this.render = function(scene_time, percent)
	{
		var colorchange1 = 0.7;
		var colorchange2 = 0.85;

		scene_time = scene_time += getVal("var5");

		//this.controls.update();

		var cp = Math.max(0, Math.min(100, getVal("var1")));
		var lap = Math.max(0, Math.min(100, getVal("var2")));

		this.camera.position = this.camspline.getPoint(cp/100);
		var cp = this.camera.position;
		this.camera.position.set(
			cp.x + getVal("r1_x"),
			cp.y + getVal("r1_y"),
			cp.z + getVal("r1_z")
		);
		this.camera.lookAt(this.spline.getPoint(lap/100));
		var cr = this.camera.rotation;
		this.camera.rotation.set(
			cr.x + deg2rad(getVal("r2_x")),
			cr.y + deg2rad(getVal("r2_y")),
			cr.z + deg2rad(getVal("r2_z"))
		);



		var neonBrightness = getVal("var3");
		this.neonLight.intensity = neonBrightness;
		this.neonLight2.intensity = neonBrightness;
		this.neonLight3.intensity = neonBrightness;

		var neonIsOn = (getVal("var4") >= 1.0);
		if(neonIsOn !== this.prevNeonIsOn) {
			this.neonMaterial.uniforms["InnerColor"].value = this.neonColors[neonIsOn]["inner"];
			this.neonMaterial.uniforms["OuterColor"].value = this.neonColors[neonIsOn]["outer"];
			this.prevNeonIsOn = neonIsOn;
		}

		var i,ii,s,g,glow,scale;

		var speed = 1/14;
		var closelimit = 0.04;

		var li = [];
		for (i=0; i<this.numpointlights; i++)
		{
			s = scene_time*speed+(i/this.numpointlights);
			s = s-Math.floor(s);
			li.push(s);

			var p = this.spline.getPoint(s);
			this.pointlights[i].position.set(p.x, p.y, p.z);

			// HSV
			// 0.125 = yellow
			// 0.333 = green
			// diff 0.208

			var hue = 0.125 + smoothstep(colorchange1, colorchange2, s) * 0.208;
			this.pointlights[i].color.setHSL(hue,1,0.5);


			if (s < closelimit)
			{
				this.pointlights[i].intensity = this.pointintensity * s/closelimit;
			} else
			{
				this.pointlights[i].intensity = this.pointintensity;
			}

			if (1-s < closelimit)
			{
				this.pointlights[i].intensity = this.pointintensity * (1-s)/closelimit;
			} else
			{
				this.pointlights[i].intensity = this.pointintensity;
			}

			//this.pointlights[i].intensity = this.pointintensity;
		}

		// var l1 = scene_time*speed-Math.floor(scene_time*speed);
		// var p1 = this.spline.getPoint(l1);
		// this.pointlights[0].position.set(p1.x, p1.y, p1.z);

		var cs;

		for (i=0; i<this.numboxes; i++)
		{
			cs = i/this.numboxes;
			glow = 0;
			scale = 0;

			for (ii=0; ii<this.numpointlights; ii++)
			{
				g = 1-Math.abs(li[ii]-(i/this.numboxes))*30;
				g = Math.max(g, 0.0);
				g = jQuery.easing.easeInOutSine(null, g, 0, 1, 1);
				glow += g;

				s = 1-Math.abs(li[ii]-(i/this.numboxes))*50;
				s = Math.max(s, 0.0);
				s = jQuery.easing.easeInOutSine(null, s, 0, 1, 1);
				scale += s;
			}


			//this.boxes[i].uniforms.glow.value = Math.pow(Math.sin(i/4+scene_time*2)*0.5+0.5,2);
			//this.boxes[i].uniforms.scale.value = 1+Math.pow(Math.sin(i/4+scene_time*2)*0.5+0.5,10)*0.5;

			this.boxes[i].uniforms.glow.value = glow;
			this.boxes[i].uniforms.scale.value = 1+scale*0.5;

			var rotfactor = 0.1;
			this.boxes[i].mesh.rotation.set(
				this.boxes[i].mesh.rotation.x + this.boxes[i].rot.x * rotfactor * glow,
				this.boxes[i].mesh.rotation.y + this.boxes[i].rot.y * rotfactor * glow,
				this.boxes[i].mesh.rotation.z + this.boxes[i].rot.z * rotfactor * glow
			);

			var d = i/this.numboxes;
			var mov = 0.03;

			var px = Math.sin(d*50 + scene_time) * mov;
			px += Math.sin(d*90 + scene_time*2) * mov * (1+getVal("var6"));

			var pz = Math.sin(d*60 + scene_time*1.1) * mov;
			pz += Math.sin(d*114 + scene_time*1.9) * mov * (1+getVal("var7"));

			var py = Math.sin(d*100 + scene_time*1.1) * mov + mov;
			py += Math.sin(d*140 + scene_time*1.9) * mov + mov;

			this.boxes[i].mesh.position.set(
				this.boxes[i].position.x + px,
				this.boxes[i].position.y + py,
				this.boxes[i].position.z + pz
			);

			var hue = 0.166 + smoothstep(colorchange1, colorchange2, cs) * 0.166;
			this.boxes[i].uniforms.glowColor.value.setHSL(hue,1,0.5);

		}

		// make moon glow
		//var gmoon = 1-Math.abs(l1-0.05)*10;
		//gmoon = Math.max(g1, 0.0); 
		gmoon = Math.sin((scene_time*this.numpointlights)*speed*(Math.PI*2) + 1.32)*0.5+0.5;
		gmoon = Math.pow(gmoon, 30);
		this.moon_uniforms.glow.value = gmoon;
		this.moonlight.intensity = gmoon * 2;

		this.sun_inside_uniforms.sceneTime.value = scene_time;
		this.sun_inside_uniforms.bumpScale.value = 14 + gmoon*40;
		//this.sun_inside_uniforms.bumpScale.value = getVal("var5");
		this.sun_inside_uniforms.scale.value = 1;
		this.sun_inside_uniforms.scaleFactor.value = getVal("var7");

		var sun1 = Math.sin(scene_time * 20) * 0.2;
		var sun2 = Math.sin(scene_time * 35) * 0.15;

		this.sunlight.intensity = 4 + sun1 + sun2;

		/*this.sun_inside_uniforms = {
			sceneTime: { type: "f", value: 0.0 },
			scale: { type: "f", value: 1.0 },
			scaleFactor: { type: "f", value: 1.0 },
			bumpScale: { type: "f", value: 1.0 }
		};*/


		gearth = Math.sin((scene_time*this.numpointlights)*speed*(Math.PI*2) + 1.66)*0.5+0.5;
		gearth = Math.pow(gearth, 30)*0.5;
		this.earth_uniforms.glow.value = gearth;
		this.earthlight.intensity = gearth * 2;


		var blinkt = scene_time * getVal("p1_lat");
		var blinki = getVal("p1_lon");

		this.spotlight1.intensity = blinki;
		this.spotlight2.intensity = blinki;
		this.saftblanderLight.intensity = blinki*0.8;

		this.target1.position.set(Math.sin(blinkt)*5,Math.cos(blinkt)*5+5,-35);
		blinkt += Math.PI;
		this.target2.position.set(Math.sin(blinkt)*5,Math.cos(blinkt)*5+5,-35);

		this.saftbulb.rotation.set(0,0,-blinkt);

		//this.blinkerbase.position = this.target1.position;
		

		/*
		effectcomposer.passes = []; // reusing global effectcomposer in order to preserve memory.
		effectcomposer.addPass(this.renderpass);

		effectcomposer.addPass(this.fxaaPass);
		effectcomposer.addPass(final_pass);
		effectcomposer.render();
		*/

		this.roomvisible(false);
		this.blackroomvisible(true);
		effectcomposer.doPass(this.renderpass);
		effectcomposer.doPass(this.bloompass);
		effectcomposer.doPass(this.savepass);

		this.roomvisible(true);
		this.blackroomvisible(false);
		effectcomposer.doPass(this.renderpass);
		effectcomposer.doPass(this.blendpass);
		effectcomposer.doPass(this.fxaaPass);


		effectcomposer.doPass(final_pass);


		//renderer.render(this.scene, this.camera);

		//var campos = this.camspline.getPoint(getVal("var1")/100);
		//this.box.position = campos;
	}

	this.fakerandom = function(n)
	{
		/*
		var v1 = Math.sin(n*1000000+n)*0.5+0.5;
		var v2 = Math.cos(n*100000+n)*0.5+0.5;
		var v3 = Math.sin(n*500000)*0.5+0.5;
		var v4 = Math.sin(n*300000)*0.5+0.5;
		var v5 = Math.sin(n*600000)*0.5+0.5;
		return ((v1 + v2 + v3 + v4 + v5)/5);
		*/
		return (Math.sin(n*100000000)*0.5+0.5);
	}

	this.roomvisible = function (state)
	{
		for (var i = 0; i<this.room.children.length; i++)
		{
			this.room.children[i].visible = state;
		}
	}

	this.blackroomvisible = function (state)
	{
		for (var i = 0; i<this.blackroom.children.length; i++)
		{
			this.blackroom.children[i].visible = state;
		}
	}
}