
function deg2rad(degrees) {
	return degrees * Math.PI / 180;
}

function scene_globe () {

	this.scene_name = "Globe";

	this.load = function(){

		this.sun_position = {x: 400, y: 0, z: -400};

		this.camera = new THREE.PerspectiveCamera(45, 16/9, 0.1, 20000); // view angle, aspect, near, far

		this.scene = new THREE.Scene();

		// ===============================================
		// Setup to render effects on top of the earth.
		this.pp_overlay_uniforms = {
			tDiffuse: { type: "t", value: buffer4 },
			overlayTexture: { type: "t", value: buffer1 },
			opacity: { type: "f", value: 1 }
		};
		this.pp_overlay_material = new THREE.ShaderMaterial(
		{
			uniforms: this.pp_overlay_uniforms,
			vertexShader: THREE.CopyShader.vertexShader,
			fragmentShader: shaders.fragmentShader_overlay,
			blending: THREE.NormalBlending,
			transparent: true
		}
		);
		this.pp_camera = new THREE.OrthographicCamera( -1, 1, 1, -1, 0, 1 );
		this.pp_scene  = new THREE.Scene();
		this.pp_quad = new THREE.Mesh( new THREE.PlaneGeometry( 2, 2 ), this.pp_overlay_material );
		this.pp_scene.add( this.pp_quad );
		

		//this.controls = new THREE.OrbitControls( this.camera, renderer.domElement );

		// ===============================================
		// Planet and textures/shaders. 


		loading_console_write('Creating globe');
		this.globe_geometry = new THREE.SphereGeometry(10,100,100);

/*		tex.earth_day_hires = load_texture(texture_dir+'earth/2_no_clouds_16k_curved.jpg','earth texture hires');
		tex.earth_night_hires = load_texture(texture_dir+'earth/night_awesome.jpg','earth texture night hires');
		tex.earth_clouds_hires = load_texture(texture_dir+'earth/fair_clouds_8k.jpg','earth clouds hires');
		tex.earth_clouds2_hires = load_texture(texture_dir+'earth/australia_clouds_8k.jpg','earth clouds hires');
		tex.earth_water_hires = load_texture(texture_dir+'earth/water_16k.png','earth watermask hires');
		tex.earth_cloudlights_hires = load_texture(texture_dir+'earth/cloudlights_4k.png','earth watermask hires');
*/
		tex.earth_day_hires = load_texture(texture_dir+'earth/small/2_no_clouds_16k_curved.jpg','earth texture hires');
		tex.earth_night_hires = load_texture(texture_dir+'earth/small/night_awesome.jpg','earth texture night hires');
		tex.earth_clouds_hires = load_texture(texture_dir+'earth/small/fair_clouds_8k.jpg','earth clouds hires');
		tex.earth_clouds2_hires = load_texture(texture_dir+'earth/small/australia_clouds_8k.jpg','earth clouds hires');
		tex.earth_water_hires = load_texture(texture_dir+'earth/small/water_16k.png','earth watermask hires');
		tex.earth_cloudlights_hires = load_texture(texture_dir+'earth/small/cloudlights_4k.png','earth watermask hires');

		tex.earth_day_lowres = load_texture(texture_dir+'earth/mini/2_no_clouds_16k_curved.jpg','earth texture hires');
		tex.earth_night_lowres = load_texture(texture_dir+'earth/mini/5_night_16k.jpg','earth texture night hires');



		this.globe_uniforms = {
			dayTexture: { type: "t", value: tex.earth_day_hires },
			nightTexture: { type: "t", value: tex.earth_night_hires },
			cloudTexture: { type: "t", value: tex.earth_clouds2_hires },
			waterTexture: { type: "t", value: tex.earth_water_hires },
			viewVector: { type: "v3", value: this.camera.position },
			sunVector: { type: "v3", value: this.sun_position },
			cloudOffset: { type: "f", value: 0.0 },
			insideEarth: { type: "i", value: 0 },
			blink: { type: "f", value: 0.0 },
			sunblink: { type: "f", value: 100.0 },
		};

		this.globe_material = new THREE.ShaderMaterial(
		{
			uniforms: this.globe_uniforms,
			vertexShader: shaders.vertexShader_globe,
			fragmentShader: shaders.fragmentShader_globe,
			side: THREE.DoubleSide,
			blending: THREE.NormalBlending,
			transparent: true
		}
		);
		


		this.globe_mesh = new THREE.Mesh( this.globe_geometry, this.globe_material );

		// ===============================================
		// Glow around planet

		this.glow_uniforms = {
			"c": { type: "f", value: 1.0 },
			"p": { type: "f", value: 2.4 },
			uGlowColor: { type: "c", value: new THREE.Color(0x80e3ff) },
			sunVector: { type: "v3", value: this.sun_position },
			viewVector: { type: "v3", value: this.camera.position }
		}

		this.glow_material = new THREE.ShaderMaterial(
		{
			uniforms: this.glow_uniforms,
			vertexShader: shaders.vertexShader_glow,
			fragmentShader: shaders.fragmentShader_glow,
			side: THREE.FrontSide,
			blending: THREE.NormalBlending,
			transparent: false
		}
		);

		this.lolmongo = new THREE.MeshBasicMaterial({color: 0xff00ff});

		this.glow_scene = new THREE.Scene();
		this.globe_glow = new THREE.Mesh(this.globe_geometry.clone(), this.glow_material);
		//this.globe_glow = new THREE.Mesh(this.globe_geometry.clone(), this.lolmongo);
		this.globe_glow.position = this.globe_mesh.position;
		this.globe_glow.scale.multiplyScalar(1.02);
		this.glow_scene.add(this.globe_glow);
		this.glow_renderpass = new THREE.RenderPass(this.glow_scene, this.camera);
		this.glow_savepass = new THREE.SavePass(buffer1);
		this.glow_overlaypass = new THREE.OverlayPass(null, 1.0);

		// ===============================================
		// Clouds

		this.cloud_uniforms = {
			cloudTexture: { type: "t", value: tex.earth_clouds2_hires },
			cloudlightsTexture: { type: "t", value: tex.earth_cloudlights_hires },
			sunVector: { type: "v3", value: this.sun_position },
			textureOffset: { type: "f", value: 0.0 },
			insideEarth: { type: "i", value: 0 },
			blink: { type: "f", value: 0.0 },
			sunblink: { type: "f", value: 100.0 },
		};

		this.cloud_material = new THREE.ShaderMaterial(
		{
			uniforms: this.cloud_uniforms,
			vertexShader: shaders.vertexShader_globeclouds,
			fragmentShader: shaders.fragmentShader_globeclouds,
			side: THREE.FrontSide,
			blending: THREE.NormalBlending,
			transparent: true
		}
		);

		this.globe_clouds = new THREE.Mesh(this.globe_geometry.clone(), this.cloud_material);
		this.globe_clouds.position = this.globe_mesh.position;
		this.globe_clouds.scale.multiplyScalar(1.010);

		// Clouds inside

		this.cloud_inside_uniforms = {
			cloudTexture: { type: "t", value: tex.earth_clouds2_hires },
			cloudlightsTexture: { type: "t", value: tex.earth_cloudlights_hires },
			sunVector: { type: "v3", value: this.sun_position },
			textureOffset: { type: "f", value: 0.0 },
			insideEarth: { type: "i", value: 1 },
			blink: { type: "f", value: 0.0 },
			sunblink: { type: "f", value: 100.0 },
		};

		this.cloud_inside_material = new THREE.ShaderMaterial(
		{
			uniforms: this.cloud_inside_uniforms,
			vertexShader: shaders.vertexShader_globeclouds,
			fragmentShader: shaders.fragmentShader_globeclouds,
			side: THREE.BackSide,
			blending: THREE.NormalBlending,
			transparent: true
		}
		);

		this.globe_clouds_inside = new THREE.Mesh(this.globe_geometry.clone(), this.cloud_inside_material);
		this.globe_clouds_inside.position = this.globe_mesh.position;
		this.globe_clouds_inside.scale.multiplyScalar(0.95);



		// Moon

		tex.moon = load_texture(texture_dir+'moon/moonmap4k.jpg','moon texture medres');
		this.moon_material = new THREE.MeshLambertMaterial( { map: tex.moon, side: THREE.DoubleSide } );
		this.moon_geometry = new THREE.SphereGeometry(2,50,50);
		this.moon = new THREE.Mesh(this.moon_geometry, this.moon_material);
		this.moon.position.set(50,0,0);
		this.moon_material.needsUpdate = true;
		tex.moon.needsUpdate = true;

	
		// ===============================================
		// Aurora borealis sphere

		this.aurora_uniforms = {
			viewVector: { type: "v3", value: this.camera.position },
			width: { type: "f", value: wWidth },
			height: { type: "f", value: wHeight },
			demoTime: { type: "f", value: 0 },
			sphereRadius: { type: "f", value: 0 },
			normalMode: { type: "i", value: 0 },
			planeMode: { type: "i", value: 0 },
			reflectMode: { type: "i", value: 0 },
			auroraNorth: { type: "f", value: 1 },
			auroraSouth: { type: "f", value: 1 },
			planeNormal: { type: "v3", value: {x: 0, y: 0, z: 0} },
			var1: { type: "f", value: 1 },
			var2: { type: "f", value: 1 },
			var3: { type: "f", value: 1 }
		};

		this.aurora_material = new THREE.ShaderMaterial(
			{
				uniforms: this.aurora_uniforms,
				vertexShader: shaders.vertexShader_aurora,
				fragmentShader: shaders.fragmentShader_aurora,
				side: THREE.FrontSide,
				blending: THREE.NormalBlending,
				transparent: true
			}
		);

		this.aurora_blur_uniforms = {
			"tDiffuse": { type: "t", value: null },
			mapTexture: { type: "t", value: buffer1 },
			mapTextureBack: { type: "t", value: buffer2 },
			normalTexture: { type: "t", value: buffer3 },
			viewVector: { type: "v3", value: this.camera.position },
			auroraScale: { type: "f", value: 0.0015 },
			planeMode: { type: "i", value: 0 }
		};

		this.auroraPassShader = {
		uniforms: this.aurora_blur_uniforms,
		
		vertexShader: [

			"varying vec2 vUv;",

			"void main() {",

				"vUv = uv;",
				"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",

			"}"

		].join("\n"),

		fragmentShader: shaders.fragmentShader_aurorablur
		};

		/*this.aurora_blur_material = new THREE.ShaderMaterial(
			{
				uniforms: this.aurora_blur_uniforms,
				vertexShader: shaders.vertexShader_aurorablur,
				fragmentShader: shaders.fragmentShader_aurorablur,
				side: THREE.FrontSide,
				blending: THREE.NormalBlending,
				transparent: true
			}
		);*/


		this.aurora_sphere = new THREE.Mesh(this.globe_geometry.clone(), this.aurora_material);
		this.aurora_sphere.position = this.globe_mesh.position;
		this.aurora_sphere.scale.multiplyScalar(1.025);

		this.aurora_uniforms.sphereRadius.value = 10*1.02;

		this.aurora_sphere2 = new THREE.Mesh(this.globe_geometry.clone(), this.aurora_material);
		this.aurora_sphere2.position = this.globe_mesh.position;
		this.aurora_sphere2.scale.multiplyScalar(1.2);

		this.aurora_mask_geometry = new THREE.SphereGeometry(10,75,75);
		this.aurora_mask_material = new THREE.MeshBasicMaterial( { color: 0x000000 } );
		this.aurora_mask = new THREE.Mesh(this.aurora_mask_geometry, this.aurora_mask_material);



		this.aurora_scene = new THREE.Scene();
		this.aurora_scene2 = new THREE.Scene();
		this.aurora_scene.add(this.aurora_sphere);
		this.aurora_scene.add(this.aurora_mask);
		this.aurora_scene2.add(this.aurora_sphere2);

		this.aurora_pass = new THREE.ShaderPass(this.auroraPassShader);
		//this.aurora_overlaypass = new THREE.OverlayPass(null, 1.0);


		//this.aurora_composer = new THREE.EffectComposer(renderer);
		//aurora_renderpass = new THREE.RenderPass(this.scene, this.camera);
		//this.aurora_composer.addPass(aurora_renderpass);

		
		//this.aurora_pass.renderToScreen = true;
		//this.aurora_composer.addPass(this.aurora_pass);
		

		// TODO - space station

		// TODO - skybox

		//tex.skybox = load_texture(texture_dir+'skybox/starscape_3.jpg','starmap skybox texture');
		//this.skybox_material = new THREE.MeshBasicMaterial( { map: tex.skybox, side: THREE.DoubleSide } );
		//this.skybox_geometry = new THREE.CubeGeometry(1000,1000,1000);
		//this.skybox_mesh = new THREE.Mesh(this.skybox_geometry, this.skybox_material);

		// ===============================================
		// Suns

		loading_console_write('Creating sun geometry');
		this.sun_geometry = new THREE.SphereGeometry(6,10,10);
		this.sun_material = new THREE.MeshBasicMaterial( { color:0xfff600 } );
	
		this.sun_mesh = new THREE.Mesh(this.sun_geometry, this.sun_material);
		this.sun_mesh.position = this.sun_position;

		loading_console_write('Creating internal sun geometry');

		this.sun_inside_uniforms = {
			sceneTime: { type: "f", value: 0.0 },
			scale: { type: "f", value: 0.0 },
			scaleFactor: { type: "f", value: 1.0 },
			bumpScale: { type: "f", value: 1.0 }
		};

		this.sun_inside_material = new THREE.ShaderMaterial(
			{
				uniforms: this.sun_inside_uniforms,
				vertexShader: shaders.vertexShader_sun,
				fragmentShader: shaders.fragmentShader_sun,
				side: THREE.FrontSide
			}
		);

		this.sun_inside_geometry = new THREE.SphereGeometry(1.5,40,40);
		this.sun_inside_mesh = new THREE.Mesh(this.sun_inside_geometry, this.sun_inside_material);
		this.sun_inside_mesh2 = this.sun_inside_mesh.clone();

		this.sun_inside_scene = new THREE.Scene();
		this.sun_inside_scene.add(this.sun_inside_mesh2);
		this.sun_renderpass = new THREE.RenderPass(this.sun_inside_scene, this.camera);
		this.sun_bloompass = new THREE.BloomPass(0.65);
		this.sun_save = new THREE.SavePass(buffer1);
		this.sun_blend = new THREE.ShaderPass(THREE.AdditiveBlendShader2);
		this.sun_blend.uniforms['tDiffuse2'].value = buffer1;

		//this.sun_mesh.add(new THREE.Axes());
		//this.sun_mesh.lookAt(this.globe_mesh);

		this.light = new THREE.PointLight(0xffffff);
		this.light.position=this.sun_position;

		this.axisHelper = new THREE.AxisHelper(40);

	

		this.cosmos = starfield(undefined,10000);

		this.scene.add(this.cosmos);

		//this.scene.add(this.camera);
		this.scene.add(this.axisHelper);
		this.scene.add(this.globe_mesh);
		this.scene.add(this.globe_clouds_inside);
		this.scene.add(this.sun_mesh);
		this.scene.add(this.sun_inside_mesh);
		this.scene.add(this.light);
		this.scene.add(this.globe_clouds);
		//this.scene.add(this.globe_glow);
		//this.scene.add(this.skybox_mesh);
		this.scene.add(this.moon);
		

		this.aurora_sphere2 = this.aurora_sphere.clone();

		//this.scene.add(this.aurora_sphere2);
		
		//this.globe_mesh.visible = false;

		this.camera.position.set(-6.314,10.163,4.688);
		this.camera.rotation.set(-0.99, -1.015667, -0.913255);
		//this.camera.lookAt(this.scene.position);


		// ===============================================
		// Post shaders

		this.auroraBlurH = new THREE.ShaderPass(THREE.HorizontalBlurShader);
		this.auroraBlurV = new THREE.ShaderPass(THREE.VerticalBlurShader);
		this.bloompassAurora = new THREE.BloomPass(1);
		this.saveAurora = new THREE.SavePass(buffer6);
		
		this.blendAurora = new THREE.ShaderPass(THREE.AdditiveBlendShader2);
		this.blendAurora.uniforms['tDiffuse2'].value = buffer6;



		this.renderpass = new THREE.RenderPass(this.scene, this.camera);
		this.savepass = new THREE.SavePass(buffer4);
		this.texturepass = new THREE.TexturePass(buffer4, 1.0);


		this.composer = new THREE.EffectComposer(renderer);

		this.fxaaPass = new THREE.ShaderPass(THREE.FXAAShader);
		this.fxaaPass.uniforms[ 'resolution' ].value = new THREE.Vector2( 1 / wWidth, 1 / wHeight );
		//this.composer.addPass(this.fxaaPass);

		// this.rs_* - global settings for render_scene().
		this.rs_shaderclouds = true;
		this.rs_cloudoffset = 0;

		this.rs_mode = "outside";
		this.rs_enable_glow = true;
		this.rs_enable_aurora = true;
		this.rs_enable_sunrise = false;

	}

	var rs_lowres = 0;

	// Added this because the scene rendering was starting to gain complexity
	// Renders all the parts and overlays them to complete the final image.
	this.render_scene = function(s)
	{
		renderer.sortObjects = false;

		if (s === undefined)
			s = {};

		if (s.sceneTime === undefined)
			s.sceneTime = demo_time;

		// ==================
		// Start by rendering the earth without shaderclouds, glow or aurora to a texture

		// Set some defaults

		if (s.shaderclouds === undefined)
			s.shaderclouds = false;

		if (s.mode === undefined)
			mode = "outside";

		if (s.enable_glow === undefined)
			s.enable_glow = true;

		if (s.glow_intensity === undefined)
			s.glow_intensity = 1.0;

		if (s.enable_aurora === undefined)
			s.enable_aurora = false;

		if (s.enable_sunrise === undefined)
			s.enable_sunrise = false;


		if (this.rs_shaderclouds == true)
		{
			this.globe_clouds.visible = false;
		} else
		{
			this.globe_clouds.visible = true;
		}

		if (s.lowres === undefined)
			s.lowres = false;

		if (s.lowres == true)
		{
			if (rs_lowres == 0)
			{
				this.globe_uniforms.dayTexture.value = tex.earth_day_lowres;
				this.globe_uniforms.nightTexture.value = tex.earth_night_lowres;
				rs_lowres = 1;
			}
		} else
		{
			if (rs_lowres == 1)
			{
				this.globe_uniforms.dayTexture.value = tex.earth_day_hires;
				this.globe_uniforms.nightTexture.value = tex.earth_night_hires;
				rs_lowres = 0;
			}
		}

		if (s.mode == "outside")
		{
			this.globe_uniforms.insideEarth.value = 0;
			this.globe_clouds.visible = true;
			this.globe_clouds_inside.visible = false;
			if (s.enable_sunrise == true)
			{
				this.sun_mesh.visible = false;
			} else {
				this.sun_mesh.visible = true;
			}
			this.sun_inside_mesh.visible = false;

			if (this.camera.fow != 45)
			{
				this.camera.fow = 45;
				this.camera.updateProjectionMatrix();
			}

			this.globe_uniforms.sunVector.value = this.sun_mesh.position;

		} else
		{
			this.globe_uniforms.insideEarth.value = 1;
			this.globe_clouds.visible = true;
			this.globe_clouds_inside.visible = true;
			this.sun_inside_mesh.visible = true;
			this.rs_enable_glow = 0;
			this.rs_enable_aurora = 0;

			if (this.camera.fow != 75)
			{
				this.camera.fow = 75;
				this.camera.updateProjectionMatrix();
			}

			this.globe_uniforms.sunVector.value = this.sun_inside_mesh.position;
		}

		// Shaders that needs the camera position
		this.globe_uniforms.viewVector.value = this.camera.position;
		this.aurora_uniforms.viewVector.value = this.camera.position;
		this.aurora_blur_uniforms.viewVector.value = this.camera.position;
		this.glow_uniforms.viewVector.value = this.camera.position;

		// Shaders som trenger sol-posisjonen
		this.cloud_uniforms.sunVector.value = this.sun_mesh.position;
		this.glow_uniforms.sunVector.value = this.sun_mesh.position;
		this.cloud_inside_uniforms.sunVector.value = this.sun_inside_mesh.position;

		// Cloud texture x axis offset.
		this.globe_uniforms.cloudOffset.value = this.rs_cloudoffset;
		this.cloud_uniforms.textureOffset.value = this.rs_cloudoffset;
		this.cloud_inside_uniforms.textureOffset.value = this.rs_cloudoffset;

		this.globe_clouds.rotation.y = this.globe_mesh.rotation.y;
		this.globe_clouds_inside.rotation.y = this.globe_mesh.rotation.y;
		this.aurora_sphere.rotation.y = this.globe_mesh.rotation.y;

		this.glow_uniforms.c.value = s.glow_intensity;

		this.globe_uniforms.blink.value = getVal("var1");
		this.cloud_uniforms.blink.value = getVal("var1");

		// Reset the composer passes.
		effectcomposer.passes = [];


		if (s.enable_aurora == true)
		{
			this.aurora_uniforms.demoTime.value = s.sceneTime;

			this.savepass.renderTarget = buffer4;
			effectcomposer.doPass(this.savepass);

			// Aurora spherer front side
			this.aurora_material.side = THREE.FrontSide;

			this.aurora_uniforms.normalMode.value = 0;
			this.aurora_uniforms.viewVector.value = this.camera.position;
			this.aurora_mask.visible = true;
			renderer.render(this.aurora_scene, this.camera, buffer1, true);

			this.aurora_uniforms.normalMode.value = 1;
			renderer.render(this.aurora_scene2, this.camera, buffer3, true);

			// =============================
			// Render aurora sphere back side

			this.aurora_material.side = THREE.BackSide;

			//this.aurora_uniforms.demoTime.value = scene_time;
			this.aurora_uniforms.normalMode.value = 0;
			renderer.render(this.aurora_scene, this.camera, buffer2, true);

			this.aurora_blur_uniforms.viewVector.value = this.camera.position;

			//this.aurora_overlaypass.uniforms.overlayTexture.value = buffer1;
			//this.aurora_overlaypass.uniforms.opacity.value = 0.1;
			//effectcomposer.doPass(this.aurora_overlaypass)

			//this.auroraBlurV.renderToScreen = true;
			effectcomposer.doPass(this.aurora_pass);
			effectcomposer.doPass(this.auroraBlurH);
			effectcomposer.doPass(this.auroraBlurV);
			//effectcomposer.doPass(this.bloompassAurora);
			effectcomposer.doPass(this.saveAurora);
		}

		if (s.mode == "inside")
		{
			effectcomposer.doPass(this.sun_renderpass);
			effectcomposer.doPass(this.sun_bloompass);
			effectcomposer.doPass(this.sun_save);
		}


		effectcomposer.doPass(this.renderpass);


		// ==================
		// Render effects and composit them ontop of the texture containing the earth.

		//this.rs_enable_glow = false;

		if (s.enable_glow == true)
		{
			//console.log("lol");

			this.savepass.renderTarget = buffer4;
			effectcomposer.doPass(this.savepass); // Stash original scene
			
			renderer.render(this.glow_scene, this.camera, buffer1, true);
			//renderer.render(this.glow_scene, this.camera);

			effectcomposer.doPass(this.glow_renderpass);
			effectcomposer.doPass(this.glow_savepass);
			this.glow_savepass.renderTarget = buffer1;

			effectcomposer.doPass(this.texturepass); // Bring back original scene for overlay
			this.glow_overlaypass.uniforms.overlayTexture.value = buffer1;
			effectcomposer.doPass(this.glow_overlaypass);

		}

		if (s.enable_aurora == true)
		{
			effectcomposer.doPass(this.blendAurora);
		}

		// data is in readBuffer, writeBuffer is black.


		if (s.enable_sunrise == true)
		{
			// nite sin epic sunrise kommer her.
			
		}


		if (s.mode == "inside")
		{
			effectcomposer.doPass(this.sun_blend);
		}

		/*
		this.pp_overlay_uniforms.tDiffuse.value = effectcomposer.readBuffer;
		this.pp_overlay_uniforms.overlayTexture.value = buffer3;
		this.pp_overlay_uniforms.opacity.value = 0.0;
		renderer.render(this.pp_scene, this.pp_camera);
		*/

		effectcomposer.doPass(this.fxaaPass);

		effectcomposer.doPass(final_pass);

		renderer.sortObjects = true;
	}

	this.render_intro = function(scene_time, percent)
	{


		this.sun_position = (Math.sin(scene_time)*150,0,0);

		//this.moon2d.rotation.set(Math.PI/-2,Math.PI/2,0);
		//this.moon2d.position.set(50,0,0);

		this.camera.position.set(53-scene_time/30,0,-1.5-scene_time/50);

		this.camera.rotation.set((Math.PI/-2),Math.PI/2,0);

		this.skybox_mesh.rotation.set(0,-scene_time/100,0);

		//camera.lookAt(this.scene.position);

		var globe_time = scene_time-10

		this.globe_mesh.rotation.y = globe_time/20;
		this.globe_clouds.rotation.y = this.globe_mesh.rotation.y;
		this.cloud_uniforms.textureOffset.value = globe_time/350;
		this.globe_uniforms.cloudOffset.value = globe_time/350;


		//renderer.render(this.scene, this.camera);
		renderer.sortObjects = false;
		this.composer.render();
		renderer.sortObjects = true;
	}

	var lol2 = 0;

	this.render_test = function(scene_time, percent)
	{

		//this.controls.update();
		
		this.rs_cloudoffset = scene_time/900;
		//this.globe_mesh.rotation.y = scene_time/20;

		this.aurora_uniforms.demoTime.value = scene_time;

		this.render_scene({
			mode: "outside",
			enable_glow: true,
			enable_aurora: true
		});

		if (lol2++ > 60)
		{
			lol2 = 0;
			console.log("pos x: "+this.camera.position.x);
			console.log("pos y: "+this.camera.position.y);
			console.log("pos z: "+this.camera.position.z);

			console.log("rot x: "+this.camera.rotation.x);
			console.log("rot y: "+this.camera.rotation.y);
			console.log("rot z: "+this.camera.rotation.z);
		}
	}

	this.aurora_test = function(scene_time, percent)
	{
		//this.camera.position.set(0,0,-15);

		// =============================
		// Render aurora sphere and normal sphere front side

		this.aurora_material.side = THREE.FrontSide;

		this.aurora_uniforms.demoTime.value = scene_time;
		this.aurora_uniforms.normalMode.value = 0;
		this.aurora_uniforms.viewVector.value = this.camera.position;
		this.aurora_uniforms.viewNormal.value = this.camera.rotation;
		this.aurora_mask.visible = true;
		renderer.render(this.aurora_scene, this.camera, buffer1, false);

		this.aurora_uniforms.normalMode.value = 1;
		renderer.render(this.aurora_scene2, this.camera, buffer3, false);



		// =============================
		// Render aurora sphere back side

		this.aurora_material.side = THREE.BackSide;

		this.aurora_uniforms.demoTime.value = scene_time;
		this.aurora_uniforms.normalMode.value = 0;
		renderer.render(this.aurora_scene, this.camera, buffer2, false);

		//renderer.render(this.aurora_scene, this.camera);

		//renderer.render(this.aurora_scene, this.camera);

		//this.aurora_uniforms.normalMode.value = 1;
		//renderer.render(this.aurora_scene2, this.camera, buffer4, false);

		this.aurora_blur_uniforms.viewVector.value = this.camera.position;

		
		this.aurora_composer.render();

	}

	this.aurora_test2 = function(scene_time, percent)
	{
		this.globe_clouds.visible = false;


		this.aurora_uniforms.normalMode.value = 1;
		this.aurora_uniforms.demoTime.value = scene_time;

		//this.globe_mesh.rotation.y = scene_time/2;
		//this.aurora_sphere2.rotation.y = scene_time/2;

		renderer.sortObjects = false;
		renderer.render(this.scene, this.camera);
		renderer.sortObjects = true;
	}

	this.orbit_1 = function (scene_time, percent)
	{
		this.flyover_orbit (scene_time, percent, {
			lat_start: 0
		});
	}

	this.flyover_orbit = function(scene_time, percent, v)
	{
		//console.log(v);

		v.lat_start = deg2rad(v.lat_start);
		v.lon_start = deg2rad(v.lon_start);
		v.lat_end = deg2rad(v.lat_end);
		v.lon_end = deg2rad(v.lon_end);

		var lat = morph(v.lat_start, v.lat_end, percent);
		var lon = morph(v.lon_start, v.lon_end, percent);

		//console.log(v.lat_start);
		//console.log(v.lat_end);
		//console.log(lat);

		//vertex.x = cam_orbit_radius * Math.sin(feta)*Math.cos(phi);
		//vertex.y = cam_orbit_radius * Math.sin(feta)*Math.sin(phi);
		//vertex.z = cam_orbit_radius * Math.cos(feta);

		var cam_x = v.cam_orbit_radius * Math.sin(lat)*Math.cos(lon);
		var cam_z = v.cam_orbit_radius * Math.sin(lat)*Math.sin(lon);
		var cam_y = v.cam_orbit_radius * Math.cos(lat);


		v.cam_rot_start = {
			x: deg2rad(v.cam_rot_start.x),
			y: deg2rad(v.cam_rot_start.y),
			z: deg2rad(v.cam_rot_start.z),
		};

		v.cam_rot_end = {
			x: deg2rad(v.cam_rot_end.x),
			y: deg2rad(v.cam_rot_end.y),
			z: deg2rad(v.cam_rot_end.z),
		};

		
		var rot_start = new THREE.Vector3(v.cam_rot_start.x, v.cam_rot_start.y, v.cam_rot_start.z);
		var rot_end = new THREE.Vector3(v.cam_rot_end.x, v.cam_rot_end.y, v.cam_rot_end.z);
		cam_rot = rot_start.lerp(rot_end, percent);

		//this.arrowHelper.position.set(cam_x, cam_y, cam_z);

		this.camera.position.set(cam_x, cam_y, cam_z);
		this.camera.rotation.set(cam_rot.x, cam_rot.y, cam_rot.z);

		//console.log(lat);

		this.sun_position = new THREE.Vector3(250*Math.sin(deg2rad(v.sun_orbit)), 0, 250*Math.cos(deg2rad(v.sun_orbit)));

		this.globe_uniforms.sunVector.value = this.sun_position;
		this.globe_uniforms.viewVector.value = this.camera.position;
		this.cloud_uniforms.sunVector.value = this.sun_position;
		this.glow_uniforms.sunVector.value = this.sun_position;
		this.sun_mesh.position = this.sun_position;


		this.globe_mesh.rotation.set(0,0,0);
		this.globe_clouds.rotation.y = this.globe_mesh.rotation.y;
		this.cloud_uniforms.textureOffset.value = scene_time/350;
		this.globe_uniforms.cloudOffset.value = scene_time/350;


		//renderer.render(this.scene, this.camera);
		//this.composer.render();
		this.render_scene({
			mode: "outside",
			enable_glow: true,
			enable_aurora: true
		});

	}

	this.orbit_test = function(scene_time, percent)
	{
		this.add_gui_orbit();

		this.flyover_orbit(scene_time, this.gui_percent/100, {
			lat_start: this.gui_lat_start,
			lon_start: this.gui_lon_start,
			lat_end: this.gui_lat_end,
			lon_end: this.gui_lon_end,

			cam_orbit_radius: this.gui_orbit_r,

			cam_rot_start: {
				x: this.gui_rx_start,
				y: this.gui_ry_start,
				z: this.gui_rz_start
			},
			cam_rot_end: {
				x: this.gui_rx_end,
				y: this.gui_ry_end,
				z: this.gui_rz_end
			},

			sun_orbit: this.gui_sun_orbit
		});
	}

	this.orbit1 = function(scene_time, percent)
	{
		this.flyover_orbit(scene_time, percent, {
			lat_start: -1,
			lon_start: 0,
			lat_end: -1,
			lon_end: 66,

			cam_orbit_radius: 12,

			cam_rot_start: {
				x: 149,
				y: 40,
				z: -90
			},
			cam_rot_end: {
				x: 37,
				y: 60,
				z: -126
			},

			sun_orbit: 93
		});
	}

	// night aurora
	this.orbit2 = function(scene_time, percent)
	{
		this.flyover_orbit(scene_time, percent, {
			lat_start: 38,
			lon_start: 63,
			lat_end: 31,
			lon_end: 0,

			cam_orbit_radius: 13,

			cam_rot_start: {
				x: -25,
				y: -11,
				z: -34
			},
			cam_rot_end: {
				x: -55,
				y: 13,
				z: -18
			},

			sun_orbit: -84
		});
	}

	this.orbit3 = function(scene_time, percent)
	{
		this.flyover_orbit(scene_time, percent, {
			lat_start: -65,
			lon_start: 299,
			lat_end: -46,
			lon_end: 100,

			cam_orbit_radius: 12.5,

			cam_rot_start: {
				x: -65,
				y: -53,
				z: -149
			},
			cam_rot_end: {
				x: -13,
				y: 135,
				z: 34
			},

			sun_orbit: 0
		});
	}

	this.orbit4 = function(scene_time, percent)
	{
		this.flyover_orbit(scene_time, percent, {
			lat_start: 53,
			lon_start: 48,
			lat_end: 57,
			lon_end: 122,

			cam_orbit_radius: 11,

			cam_rot_start: {
				x: 13,
				y: 69,
				z: 27
			},
			cam_rot_end: {
				x: 0,
				y: 0,
				z: 0
			},

			sun_orbit: 75
		});
	}

	this.orbit5 = function(scene_time, percent)
	{
		this.flyover_orbit(scene_time, percent, {
			lat_start: 60,
			lon_start: 0,
			lat_end: 60,
			lon_end: 108,

			cam_orbit_radius: 12,

			cam_rot_start: {
				x: -180,
				y: 57,
				z: -93
			},
			cam_rot_end: {
				x: -13,
				y: 22,
				z: 180
			},

			sun_orbit: 75
		});
	}

	this.orbit_rocket = function(scene_time, percent)
	{
		this.rs_cloudoffset = getVal("var6")/1000;
		this.aurora_uniforms.auroraNorth.value = getVal("var5")/100;

		this.flyover_orbit(scene_time, percent, {
			lat_start: getVal('p1_lat'),
			lon_start: getVal('p1_lon'),
			lat_end: getVal('p2_lat'),
			lon_end: getVal('p2_lon'),

			cam_orbit_radius: getVal('radius'),

			cam_rot_start: {
				x: getVal('r1_x'),
				y: getVal('r1_y'),
				z: getVal('r1_z')
			},
			cam_rot_end: {
				x: getVal('r2_x'),
				y: getVal('r2_y'),
				z: getVal('r2_z')
			},

			sun_orbit: getVal('sun_orbit')
		});
	}



	this.flyover_test = function(scene_time, percent)
	{

		var lat_start = deg2rad(this.gui_lat_start);
		var lon_start = deg2rad(this.gui_lon_start);

		var lat_end = deg2rad(this.gui_lat_end);
		var lon_end = deg2rad(this.gui_lon_end);

		var cam_orbit_radius = this.gui_orbit_r;

		var percent = this.gui_percent/100;

		var lat = morph(lat_start, lat_end, percent);
		var lon = morph(lon_start, lon_end, percent);

		var cam_x = cam_orbit_radius * Math.cos(lat)*Math.cos(lon);
		var cam_y = cam_orbit_radius * Math.cos(lat)*Math.sin(lon);
		var cam_z = cam_orbit_radius * Math.sin(lat);


		var cam_rot_x_start = deg2rad(this.gui_rx_start);
		var cam_rot_y_start = deg2rad(this.gui_ry_start);
		var cam_rot_z_start = deg2rad(this.gui_rz_start);

		var cam_rot_x_end = deg2rad(this.gui_rx_end);
		var cam_rot_y_end = deg2rad(this.gui_ry_end);
		var cam_rot_z_end = deg2rad(this.gui_rz_end);

		var rot_start = new THREE.Vector3(cam_rot_x_start, cam_rot_y_start, cam_rot_z_start);
		var rot_end = new THREE.Vector3(cam_rot_x_end, cam_rot_y_end, cam_rot_z_end);
		cam_rot = rot_start.lerp(rot_end, percent);

		//this.controls.update();

		this.camera.position.set(cam_x, cam_y, cam_z);
		this.camera.rotation.set(cam_rot.x, cam_rot.y, cam_rot.z);

		
		//this.sun_position = {x: 300*Math.sin(scene_time/4), y: 0, z: 300*Math.cos(scene_time/4)};
		this.globe_uniforms.sunVector.value = this.sun_position;
		this.globe_uniforms.viewVector.value = this.camera.position;
		this.cloud_uniforms.sunVector.value = this.sun_position;
		this.glow_uniforms.sunVector.value = this.sun_position;
		this.sun_mesh.position = this.sun_position;
		//this.globe_material.needsUpdate = true;


		//camera.position.set(0,0,-20);
		//camera.lookAt(this.scene.position);

		//var td = clock.getDelta();
		//t+=td;

		
		this.globe_mesh.rotation.y = scene_time/20;
		this.globe_clouds.rotation.y = this.globe_mesh.rotation.y;
		this.cloud_uniforms.textureOffset.value = scene_time/350;
		this.globe_uniforms.cloudOffset.value = scene_time/350;
		
		//this.globe_glow.rotation.y += scene_time/2;
		//this.globe_mesh.updateMatrix();

		renderer.sortObjects = false;
		renderer.render(this.scene, this.camera);
		renderer.sortObjects = true;
		//this.composer.render();
	}

	this.render_test2 = function(scene_time, percent)
	{
		//controls.update();
		//var td = clock.getDelta();
		//t+=td;

		t = scene_time;
		//console.log(t);

		this.camera.position.set(10.6,0,-4);
		this.camera.rotation.set(0,-10,180);
		//camera.lookAt(this.scene.position);

		this.globe_mesh.rotation.y = scene_time/20;
		this.globe_clouds.rotation.y = this.globe_mesh.rotation.y;
		this.cloud_uniforms.textureOffset.value = scene_time/350;
		this.globe_uniforms.cloudOffset.value = scene_time/350;
		//this.globe_glow.rotation.y += scene_time/2;
		//this.globe_mesh.updateMatrix();


		//renderer.render(this.scene, this.camera);
		renderer.sortObjects = false;
		this.composer.render();
		renderer.sortObjects = true;
	}

	this.inside_earth = function(scene_time, percent)
	{
		//this.camera.fow = 75;
		//this.camera.updateProjectionMatrix();

		this.sun_inside_uniforms.scale.value = 2;

		this.sun_inside_uniforms.scaleFactor.value = 0.5+getVal("var3")/100;
		this.sun_inside_uniforms.bumpScale.value = 0.5+getVal("var5");

		this.globe_uniforms.sunblink.value = getVal("var4");
		this.cloud_inside_uniforms.sunblink.value = getVal("var4");

		this.axisHelper.visible = false;
		

		s = scene_time;

		plon = 1.0;
		plat = 1.5;

		cam_orbit = 8;
		look_orbit = 9;
		sun_orbit = 8;

		offset_look = 1.3;
		offset_sun = 1.4; // add this for "cat and mouse effect" +Math.sin(scene_time*3)/4;


		cam_lat = Math.sin(scene_time*plon);
		cam_lon = Math.sin(scene_time*plat);

		campos = new THREE.Vector3(
			cam_orbit * Math.cos(cam_lat) * Math.cos(cam_lon),
			cam_orbit * Math.cos(cam_lat) * Math.sin(cam_lon),
			cam_orbit * Math.sin(cam_lat)
		);

		look_lat = Math.sin((scene_time+offset_look)*plon);
		look_lon = Math.sin((scene_time+offset_look)*plat);

		lookpos = new THREE.Vector3(
			look_orbit * Math.cos(look_lat) * Math.cos(look_lon),
			look_orbit * Math.cos(look_lat) * Math.sin(look_lon),
			look_orbit * Math.sin(look_lat)
		);

		sun_lat = Math.sin((scene_time+offset_sun)*plon);
		sun_lon = Math.sin((scene_time+offset_sun)*plat);

		sunpos = new THREE.Vector3(
			sun_orbit * Math.cos(sun_lat) * Math.cos(sun_lon),
			sun_orbit * Math.cos(sun_lat) * Math.sin(sun_lon),
			sun_orbit * Math.sin(sun_lat)
		);

		//sunpos = {x: 0, y: 4, z: 5+Math.sin(scene_time)*5};

		this.camera.position = campos;
		this.camera.lookAt(lookpos);

		//this.camera.position.set(0,0,-9);

		this.sun_position = sunpos;
		this.sun_inside_mesh.position = sunpos;
		this.sun_inside_mesh2.position = sunpos;

		//console.log(sunpos);

		//this.globe_clouds_inside.visible = false;

		this.globe_mesh.rotation.set(0,0,0);
		this.globe_clouds_inside.rotation.y = this.globe_mesh.rotation.y;
		this.cloud_inside_uniforms.textureOffset.value = scene_time/50;
		this.globe_uniforms.cloudOffset.value = scene_time/50;

		this.globe_uniforms.sunVector.value = this.sun_position;
		this.globe_uniforms.viewVector.value = this.camera.position;
		this.cloud_uniforms.sunVector.value = this.sun_position;
		this.cloud_inside_uniforms.sunVector.value = this.sun_position;

		this.globe_uniforms.insideEarth.value = 1;
		this.cloud_inside_uniforms.insideEarth.value = 1;
		this.sun_inside_uniforms.sceneTime.value = scene_time;
		this.sun_inside_uniforms.scale.value = 1.5;

		//renderer.render(this.scene, this.camera);

		//this.composer.render();
		this.rs_mode = "inside";
		//this.render_scene();

		//this.globe_uniforms.insideEarth.value = 0;

		//this.camera.fow = 45;
		//this.camera.updateProjectionMatrix();

		this.render_scene({
			mode: "inside",
			enable_glow: false,
			enable_aurora: false
		});
	}

	this.slow_zoom_to_earth = function(scene_time, percent)
	{

		/*var wait = 0.2;
		if (percent > wait)
		{
			percent = (percent-wait)/(1-wait);
		} else {
			percent = 0;
		}*/

		var zoom = getVal("var2") / 100.0;
		//jQuery.easing.easeInSine(null,percent, 0, 1, 1);
		//zoom = jQuery.easing.easeInOutSine(null,zoom, 0, 1, 1);
		//var zoom = percent;

		this.axisHelper.visible = false;
		this.sun_mesh.visible = false;

		var cam_z = 70 + (1-zoom)*40;

		//this.moon2d.visible = false;
		this.moon.visible = true;

		this.moon.position.set(-1.5,-1.5,109);


		this.camera.position.set(0,0,cam_z);
		//this.camera.lookAt(this.globe_mesh.position);
		this.camera.rotation.set(0,0,zoom/3);

		//this.sun_position = {x: 250*Math.sin(deg2rad(180)), y: 0, z: 250*Math.cos(deg2rad(180))};
		this.sun_position = {x: 250, y: 0, z: -150};
		this.light.position = {x: 50, y: 0, z: 120};

		this.globe_uniforms.sunVector.value = this.sun_position;
		this.globe_uniforms.viewVector.value = this.camera.position;
		this.cloud_uniforms.sunVector.value = this.sun_position;
		this.glow_uniforms.sunVector.value = this.sun_position;
		this.sun_mesh.position = this.sun_position;


		this.globe_mesh.rotation.set(0,scene_time/10+3,0);
		this.globe_clouds.rotation.y = this.globe_mesh.rotation.y;
		this.cloud_uniforms.textureOffset.value = scene_time/350;
		this.globe_uniforms.cloudOffset.value = scene_time/350;

		//this.composer.render();
		//this.render_scene
		//renderer.render(this.scene, this.camera);
		this.render_scene({
			mode: "outside",
			enable_glow: true,
			enable_aurora: false,
			lowres: true,
			glow_intensity: 10
		});

	}

	this.zoom_into_earth = function(scene_time, percent)
	{
		//this.moon2d.visible = false;
		this.moon.visible = false;

		var crash = jQuery.easing.easeInElastic(null,percent,0,1,1);

		var cam_z = 10.5+(50-50*crash);

		this.camera.position.set(0,0,cam_z);
		//this.camera.lookAt(this.globe_mesh.position);
		this.camera.rotation.set(0,0,percent/3);

		this.sun_position = {x: 250*Math.sin(deg2rad(70)), y: 0, z: 250*Math.cos(deg2rad(70))};

		this.globe_uniforms.sunVector.value = this.sun_position;
		this.globe_uniforms.viewVector.value = this.camera.position;
		this.cloud_uniforms.sunVector.value = this.sun_position;
		this.glow_uniforms.sunVector.value = this.sun_position;
		this.sun_mesh.position = this.sun_position;


		this.globe_mesh.rotation.set(0,scene_time/3+3.5,0);
		this.globe_clouds.rotation.y = this.globe_mesh.rotation.y;
		this.cloud_uniforms.textureOffset.value = scene_time/350;
		this.globe_uniforms.cloudOffset.value = scene_time/350;

		renderer.sortObjects = false;
		this.composer.render();
		renderer.sortObjects = true;
	}

	this.descend = function(scene_time, percent)
	{

		p = percent;

		//var p = scene_time/25;
		//if (p>1)
		//	p=1;

		//p = 1;

		p = jQuery.easing.easeOutSine(null,p,0,1,1);

		pos_start1 = new THREE.Vector3(0, 0, -35);
		pos_start2 = new THREE.Vector3(-7, 0, -35);

		pos_start = pos_start1.lerp(pos_start2, Math.sin(p*Math.PI));

		rot_start = new THREE.Vector3(0, deg2rad(180), deg2rad(90));

		pos_end = new THREE.Vector3(2, 0, -12);
		rot_end = new THREE.Vector3(0, deg2rad(210), deg2rad(90));

		pos = pos_start.lerp(pos_end, p);
		rot = rot_start.lerp(rot_end, p);

		this.camera.position = pos;
		this.camera.rotation.set(rot.x, rot.y, rot.z);
		//this.camera.lookAt(this.globe_mesh.position);

		var s = 180+p*90;

		this.sun_position = {x: 250*Math.sin(deg2rad(s)), y: 0, z: 250*Math.cos(deg2rad(s))};
		this.sun_mesh.position = this.sun_position;


		this.globe_mesh.rotation.y = 5.5 + p*2;
		this.cosmos.rotation.y = this.globe_mesh.rotation.y*0.5


		this.rs_cloudoffset = -scene_time/350 - 0.2;


		this.render_scene({
			mode: "outside",
			enable_glow: true,
			enable_aurora: false,
			lowres: false,
			glow_intensity: 2
		});
	}

	this.render = function()
	{

	}

	this.add_gui_orbit = function()
	{
		if (this.has_gui_orbit === undefined)
		{
			this.has_gui_orbit = 1;

			this.gui_lat_start = 0;
			this.gui_lon_start = 0;
			this.gui_lat_end = 0;
			this.gui_lon_end = 180;

			this.gui_orbit_r = 12;

			this.gui_rx_start = 20;
			this.gui_ry_start = 40;
			this.gui_rz_start = -90;

			this.gui_rx_end = 0;
			this.gui_ry_end = 0;
			this.gui_rz_end = 0;

			this.gui_sun_orbit = 0;
			this.gui_percent = 0;
			this.gui_cloud_offfset = 0;

			this.gui = new dat.GUI();
			this.gui.width = 400
			this.gui.add(this, 'gui_lat_start', -180, 180);
			this.gui.add(this, 'gui_lon_start', -45, 360);
			this.gui.add(this, 'gui_lat_end', -180, 180);
			this.gui.add(this, 'gui_lon_end', -45, 360);
			this.gui.add(this, 'gui_orbit_r', 10, 20);
			
			this.gui.add(this, 'gui_rx_start', -180, 180);
			this.gui.add(this, 'gui_ry_start', -180, 180);
			this.gui.add(this, 'gui_rz_start', -180, 180);

			this.gui.add(this, 'gui_rx_end', -180, 180);
			this.gui.add(this, 'gui_ry_end', -180, 180);
			this.gui.add(this, 'gui_rz_end', -180, 180);

			this.gui.add(this, 'gui_sun_orbit', -180, 180);
			this.gui.add(this, 'gui_percent', 0, 100);
			this.gui.add(this, 'gui_cloud_offfset', 0, 100);

			sliderColor('gui_lat_start', '41d341');
			sliderColor('gui_lon_start', '41d341');
			sliderColor('gui_lat_end', 'd34141');
			sliderColor('gui_lon_end', 'd34141');

			sliderColor('gui_rx_start', '41d341');
			sliderColor('gui_ry_start', '41d341');
			sliderColor('gui_rz_start', '41d341');

			sliderColor('gui_rx_end', 'd34141');
			sliderColor('gui_ry_end', 'd34141');
			sliderColor('gui_rz_end', 'd34141');


		}
	}


}
