function scene_microscope() {
	this.scenename = "Microscope"

	this.load = function()
	{
		this.scene = new THREE.Scene();

		var ambient = new THREE.AmbientLight( 0xffffff );
		ambient.color.setHSL( 0.1, 0.3, 0.2 );
		this.scene.add( ambient );

		var dirLight = new THREE.DirectionalLight( 0xffffff, 0.125 );
		dirLight.position.set( 0, 10, -20 ).normalize();
		dirLight.color.setHSL( 0.1, 0.7, 0.7 );
		this.scene.add( dirLight );

		var light = new THREE.PointLight( 0xffffff, 1.5, 4500 );
		light.color.setHSL( 0.55, 0.9, 0.5 );
		light.position.set( -10, 10, -10 );
		this.scene.add( light );

		this.composer = new THREE.EffectComposer(renderer);

		this.camera = new THREE.PerspectiveCamera(45, 16/9, 0.1, 100);
		this.camera.position.set(0, 10, -30);
		this.camera.lookAt(new THREE.Vector3(0, 0, 0));

		//var material = new THREE.MeshPhongMaterial( { ambient: 0x333333, color: 0xffffff, specular: 0xffffff, shininess: 50 } )

		this.cellMaterial = new THREE.ShaderMaterial({
			uniforms: {
				"OuterColor": { "type": "c", "value": new THREE.Color(0.6, 0.6, 0.6) },
				"InnerColor": { "type": "c", "value": new THREE.Color(0.1, 0.1, 0.1) }
			},
			vertexShader: shaders.vertexShader_microscope,
			fragmentShader: shaders.fragmentShader_microscope
		});
		
		var loader = new THREE.JSONLoader();
		loader.load( "models/virus.js", function( geometry ) {
			var mesh = new THREE.Mesh( geometry.clone(), scenes.microscope.cellMaterial );
			mesh.scale.x = mesh.scale.y = mesh.scale.z = 0.12;
			mesh.position.z = -5;
			scenes.microscope.mesh = mesh;
			scenes.microscope.scene.add( mesh );

			var mesh2 = new THREE.Mesh( geometry.clone(), scenes.microscope.cellMaterial );
			mesh2.scale.x = mesh2.scale.y = mesh2.scale.z = 0.08;
			mesh2.position.z = 0;
			scenes.microscope.mesh2 = mesh2;
			scenes.microscope.scene.add( mesh2 );

			var mesh3 = new THREE.Mesh( geometry.clone(), scenes.microscope.cellMaterial );
			mesh3.scale.x = mesh3.scale.y = mesh3.scale.z = 0.1;
			mesh3.position.z = 5;
			scenes.microscope.mesh3 = mesh3;
			scenes.microscope.scene.add( mesh3 );
		});

		loader.load( "models/bloodcell.js", function( geometry ) {
			var mesh = new THREE.Mesh( geometry.clone(), scenes.microscope.cellMaterial );
			mesh.scale.x = mesh.scale.y = mesh.scale.z = 0.12;
			mesh.position.z = 40;
			scenes.microscope.bloodcell = mesh;
			scenes.microscope.scene.add( mesh );
		});

		var particleCount = 180;
		var particleGeom = new THREE.Geometry();
		for (var p = 0; p < particleCount; p++) {
			// create a particle with random
			// position values, -250 -> 250
			var pX = Math.random() * 100 - 50,
				pY = Math.random() * 60 - 30,
				pZ = Math.random() * 60 - 30,
				particle = new THREE.Vector3(pX, pY, pZ);

			// add it to the geometry
			particleGeom.vertices.push(particle);
		}
		
		tex.particle = load_texture("gfx/particle.png","particle");

		var pMaterial = new THREE.ParticleBasicMaterial({
			color: 0xFFFFFF,
			size: 1.0,
			map: tex.particle,
			blending: THREE.AdditiveBlending,
			transparent: true
		});

		this.particles = new THREE.ParticleSystem(particleGeom, pMaterial);
		this.particles.sortParticles = true;
		this.scene.add(this.particles);

		this.renderPass = new THREE.RenderPass(this.scene, this.camera);
		this.composer.addPass(this.renderPass);

		this.blurPass1 = new THREE.ShaderPass(THREE.VerticalBlurShader);
		this.blurPass1.uniforms["v"].value = 1 / wHeight;
		this.composer.addPass(this.blurPass1);

		this.blurPass2 = new THREE.ShaderPass(THREE.HorizontalBlurShader);
		this.blurPass2.uniforms["h"].value = 1 / wWidth;
		this.composer.addPass(this.blurPass2);

		this.composer.addPass(final_pass);
	};

	this.render = function(time, percent) 
	{
		if(typeof(this.mesh) !== "undefined") {
			this.mesh.rotation.x = time * 1.6;
			this.mesh.rotation.y = time * 0.5;

			this.mesh2.rotation.x = time * 1.2;
			this.mesh2.rotation.y = - time * 0.3;

			this.mesh3.rotation.x = - time * 0.2;
			this.mesh3.rotation.y = time * 0.6;

			this.mesh.position.x = this.lerp(30, -32, percent);
			this.mesh.position.y = this.lerp(10, -12.8, percent);

			this.mesh2.position.x = this.lerp(12, 16, percent);
			this.mesh2.position.y = this.lerp(16, -23, percent);

			this.mesh3.position.x = this.lerp(-7.8, 7, percent);
			this.mesh3.position.y = this.lerp(-1, 6, percent);

			this.bloodcell.position.x = this.lerp(-11.9, -25, percent);
			this.bloodcell.position.y = this.lerp( 16.0,   3, percent);

			this.bloodcell.rotation.x = this.lerp(0, -6, percent);
			this.bloodcell.rotation.y = this.lerp(0, .5, percent);

			this.particles.position.x = this.lerp(-20, 10, percent);
			this.particles.position.y = this.lerp(5, -5, percent);
		}
		
		this.composer.render();
	};

	this.lerp = function(s, e, p) {
		return s - ((s - e) * p);
	}
}