function scene_particles() {
	this.scenename = "Particles";
	this.lastframe = 0;

	this.load = function() {
		var width = window.innerWidth;
		var height = window.innerHeight;

		this.scene = new THREE.Scene();

		this.camera = new THREE.PerspectiveCamera(45, width/height, 0.1, 2000);
		this.camera.position.z = 1000;		
		this.scene.add(this.camera);

		this.controls = new THREE.OrbitControls( this.camera, renderer.domElement );

		this.particles = new THREE.Geometry();
		for (var i = 0; i < 25000; i++) {
			var particle = new THREE.Vector3(Math.random() * width - (width/2), Math.random() * height - (height/2), 0);
			particle.v = new THREE.Vector3(Math.random(), Math.random(), Math.random());
			this.particles.vertices.push(particle);
		}

		this.particleMat = new THREE.ParticleSystemMaterial( { size: 5, color: 0xaa33ff } );

		this.partsystem = new THREE.ParticleSystem(this.particles, this.particleMat);
		this.partsystem.sortParticles = true;

		this.scene.add(this.partsystem);
		this.camera.lookAt(this.partsystem.position);

		this.composer = new THREE.EffectComposer(renderer);

		this.a = 0.8;
		this.b = 0.2;

		this.composer.addPass(new THREE.RenderPass(this.scene, this.camera));
/*
		var fxaa = new THREE.ShaderPass( THREE.FXAAShader );
		fxaa.uniforms[ 'resolution' ].value.set( 1 / width, 1 / height );
		fxaa.renderToScreen = true;
		this.composer.addPass(fxaa);
*/
		
		var hblur = new THREE.ShaderPass( THREE.HorizontalBlurShader );
		hblur.uniforms['h'].value = 1 / width;
		this.composer.addPass( hblur );

		var vblur = new THREE.ShaderPass( THREE.VerticalBlurShader );
		vblur.uniforms['v'].value = 1 / width;
		vblur.renderToScreen = true;
		this.composer.addPass( vblur );
		
	}

	this.updateParticles = function(p, d) {
		var particleCount = p.vertices.length;

		while (particleCount--) {
			var particle = p.vertices[particleCount];
			particle.x = Math.sin((demo_time - particleCount) / 90 * this.a) * 500;
			particle.y = Math.cos((demo_time - particleCount) / 60 * this.b) * 300;
			//particle.z += d * (Math.random() - 0.5) * 2;
		}
		p.__dirtyVertices = true;
	}

	this.render = function(demo_time) {
		var delta_time = demo_time - this.lastframe;

		this.controls.update();

		this.updateParticles(this.particles, demo_time);

		this.composer.render();
		this.lastframe = demo_time;
	}
}