function scene_sunrise() {
	this.scenename = "Sunrise";

	this.load = function() {
		//renderer.setClearColor(0xff0000, 1.0);

		this.scene = new THREE.Scene();
		this.maskScene = new THREE.Scene();

		this.camera = new THREE.PerspectiveCamera(45, wWidth/wHeight, 0.1, 2000);
		this.camera.position.z = -230;
		this.camera.lookAt(new THREE.Vector3(0, 0, 0));

		this.scene.add(this.camera.clone());
		this.maskScene.add(this.camera.clone());

		var sunObj = this.createSphere(30, new THREE.Vector3(0, 0, 0), { 'obj': '#ffff00', 'mask': '#ffffff' });
		this.maskScene.add(sunObj.maskObject);
		this.scene.add(sunObj.actualObject);

		this.earthObj = this.createSphere(10, new THREE.Vector3(0, 0, -200), { 'obj': '#00cc66', 'mask': '#000000' });
		this.maskScene.add(this.earthObj.maskObject);
		this.scene.add(this.earthObj.actualObject);
		
		this.composer = new THREE.EffectComposer(renderer);

		var renderpass = new THREE.RenderPass(this.maskScene, this.camera);
		this.composer.addPass(renderpass);
		
		var hblurPass = new THREE.ShaderPass(THREE.MassiveHorizontalBlurShader);
		hblurPass.uniforms['h'].value = 1 / wWidth;
		this.composer.addPass(hblurPass);

		var vblurPass = new THREE.ShaderPass(THREE.MassiveVerticalBlurShader);
		vblurPass.uniforms['v'].value = 1 / wHeight;
		this.composer.addPass(vblurPass);

		var copyPass = new THREE.SavePass(buffer1);
		this.composer.addPass(copyPass);

		// Rendering the scene clears the render buffers

		var renderpass2 = new THREE.RenderPass(this.scene, this.camera);
		this.composer.addPass(renderpass2);

		var blendPass = new THREE.ShaderPass(THREE.AdditiveBlendShader);
		blendPass.uniforms['tDiffuse2'].value = buffer1;
		this.composer.addPass(blendPass);

		this.final_pass = new THREE.ShaderPass(FinalPassShader);
		this.final_pass.renderToScreen = true;
		
		this.composer.addPass(this.final_pass);
	}

	this.createSphere = function(r, p, c) {
		var geometry = new THREE.SphereGeometry(r, 30, 30);

		var mat = new THREE.MeshBasicMaterial({
        	color: c.obj 
		});

		var maskMat = new THREE.MeshBasicMaterial({
        	color: c.mask 
		});

		var mesh = new THREE.Mesh( geometry, mat );
		mesh.position = p;

		var maskObj = new THREE.Mesh( geometry, maskMat );
		maskObj.position = p;

		return { actualObject: mesh, maskObject: maskObj };
	}

	this.render = function(demo_time) {
		this.earthObj.maskObject.position.x = Math.sin(((5 + demo_time % 10) / 100) + Math.PI) * 100;
		this.earthObj.maskObject.position.z = Math.cos(((5 + demo_time % 10) / 100) + Math.PI) * 200;

		this.composer.render();
	}
}