function scene_terrain ()
{
	this.load = function()
	{
		var inParameters = {
			width: 200,
			height: 600,
			widthSegments: 250,
			heightSegments: 250,
			filterparam: 1
		};

		this.scene = new THREE.Scene();
		this.torusScene = new THREE.Scene();

		this.camera = new THREE.PerspectiveCamera(55.0, wWidth / wHeight, 0.5, 300000);
		//this.camera.position.set(0, Math.max(inParameters.width * 1.5, inParameters.height) / 8, -inParameters.height);
		this.camera.position.set(0, 50, -inParameters.height);
		//this.camera.position.set(-399, 501, -43);
		this.camera.lookAt(new THREE.Vector3(0, 50, 0));
		this.scene.add(this.camera);

		tex.terrain_heightmap = load_texture(texture_dir+'terrain_heightmap.png', 'terrain heightmap'); 
		tex.terrain_rocks = load_texture(texture_dir+'rocks.png', 'terrain rocks texture'); 
		tex.terrain_rocks.wrapS = THREE.MirroredRepeatWrapping;
		tex.terrain_rocks.wrapT = THREE.MirroredRepeatWrapping;

		this.mountain_uniforms = {
			"heightmap": { "type": "t", "value": tex.terrain_heightmap },
			"rockTex": { "type": "t", "value": tex.terrain_rocks },
			"maxHeight": { "type": "f", "value": 1000.0 },
			"u_time": { type: "f", value: 1.0 },
			"light": { type: "f", value: 0.075 }
		};

		var mountain_shaderMat = new THREE.ShaderMaterial({
			uniforms: this.mountain_uniforms,
			vertexShader: shaders.vertexShader_terrain_mountain,
			fragmentShader: shaders.fragmentShader_terrain_mountain,
//			side: THREE.DoubleSide,
			blending: THREE.NormalBlending,
//			transparent: true
		});


		this.mountain = new THREE.Mesh(new THREE.PlaneGeometry(10000, 2000, 100, 20), mountain_shaderMat);
		this.mountain.rotation.x = -Math.PI * 0.5;
		this.mountain.rotation.z = Math.PI;
		this.mountain.position.z = 3000;
		this.mountain.position.y = -30;
		this.scene.add(this.mountain);


		//this.controls = new THREE.OrbitControls( this.camera, renderer.domElement );
		this.controls = new THREE.OrbitControls( this.camera );
		
		var directionalLight = new THREE.DirectionalLight(0xffff55, 1);
		directionalLight.position.set(-60, 30, 60);
		this.scene.add(directionalLight);


		// Load textures	
		tex.waternormals = load_texture('gfx/water/waternormals.jpg',"water normals");	
		var waterNormals = tex.waternormals;
		waterNormals.wrapS = waterNormals.wrapT = THREE.RepeatWrapping; 

		// Create the water effect
		this.ms_Water = new THREE.Water(renderer, this.camera, this.scene, {
			textureWidth: 512, 
			textureHeight: 512,
			waterNormals: waterNormals,
			alpha: 1.0,
			sunDirection: directionalLight.position.normalize(),
			sunColor: 0x505050,
			waterColor: 0x0d1947, //#2C375F
			distortionScale: 50.0
		});

		var planeGeom = new THREE.PlaneGeometry(inParameters.width * 500, inParameters.height * 500, 5, 5);
		var aMeshMirror = new THREE.Mesh(planeGeom,this.ms_Water.material);

		aMeshMirror.add(this.ms_Water);
		aMeshMirror.rotation.x = - Math.PI * 0.5;

		this.scene.add(aMeshMirror);

		// The black layer used to mask the torus when its under the ocean
		var blackMirror = new THREE.Mesh(planeGeom, new THREE.MeshBasicMaterial( { color: 0x000000 } ));
		blackMirror.rotation.x = - Math.PI * 0.5;
		this.torusScene.add(blackMirror);

		// The torus knot
		var geometry = new THREE.TorusKnotGeometry( 60, 9, 100, 16 );
		var material = new THREE.MeshBasicMaterial( { color: 0xffff00 } );
		this.torusKnot = new THREE.Mesh( geometry, material );
		this.torusKnot.position.set(0, 800, 0);
		this.scene.add( this.torusKnot );

		// Make a copy for the bloom
		this.torusCopy = this.torusKnot.clone();
		this.torusScene.add( this.torusCopy );

		this.aurora_scene = new THREE.Scene();
		this.aurora_scene2 = new THREE.Scene();
		this.testscene = new THREE.Scene();

		this.normalplane_geo = new THREE.PlaneGeometry(inParameters.width * 700, inParameters.height * 500, 40,40);

		this.normalplane_uniforms = {
			viewVector: { type: "v3", value: this.camera.position },
			width: { type: "f", value: wWidth },
			height: { type: "f", value: wHeight },
			demoTime: { type: "f", value: 0 },
			sphereRadius: { type: "f", value: 0 },
			normalMode: { type: "i", value: 1 },
			reflectMode: { type: "i", value: 0 },
			auroraNorth: { type: "f", value: 1 },
			auroraSouth: { type: "f", value: 1 },
			planeMode: { type: "i", value: 1 },
			planeNormal: { type: "v3", value: {x: 0, y: 0, z: 0} },
			var1: { type: "f", value: 1 },
			var2: { type: "f", value: 1 },
			var3: { type: "f", value: 1 }
		};

		this.normalplane_material = new THREE.ShaderMaterial(
			{
				uniforms: this.normalplane_uniforms,
				vertexShader: shaders.vertexShader_aurora,
				fragmentShader: shaders.fragmentShader_aurora,
				side: THREE.FrontSide,
				blending: THREE.NormalBlending,
				transparent: true
			}
		);

		this.normalplane = new THREE.Mesh(this.normalplane_geo, this.normalplane_material);		
		//this.scene.add(this.normalplane);
		this.normalplane.position.set(0, 12000, 0);

		this.normalplane.rotation.x = deg2rad(95);
		this.normalplane.visible = true;


		this.auroraplane_geo = new THREE.PlaneGeometry(inParameters.width * 700, inParameters.height * 500, 1,1);

		this.auroraplane_uniforms = {
			planeMode: { type: "i", value: 1 },
			viewVector: { type: "v3", value: this.camera.position },
			width: { type: "f", value: wWidth },
			height: { type: "f", value: wHeight },
			demoTime: { type: "f", value: 0 },
			sphereRadius: { type: "f", value: 0 },
			normalMode: { type: "i", value: 0 },
			reflectMode: { type: "i", value: 0 },
			auroraNorth: { type: "f", value: 1 },
			auroraSouth: { type: "f", value: 1 },
			planeNormal: { type: "v3", value: {x: 0, y: 0, z: 0} },
			var1: { type: "f", value: 1 },
			var2: { type: "f", value: 1 },
			var3: { type: "f", value: 1 }
		};

		this.auroraplane_material = new THREE.ShaderMaterial(
			{
				uniforms: this.auroraplane_uniforms,
				vertexShader: shaders.vertexShader_aurora,
				fragmentShader: shaders.fragmentShader_aurora,
				side: THREE.FrontSide,
				blending: THREE.NormalBlending,
				transparent: true
			}
		);

		this.auroraplane = new THREE.Mesh(this.auroraplane_geo, this.auroraplane_material);		
		//this.scene.add(this.auroraplane);
		this.auroraplane.position.set(0, 12000, 0);
		this.auroraplane.rotation.x = deg2rad(95);

		this.aurorareflect_geo = new THREE.PlaneGeometry(inParameters.width * 700, inParameters.height * 500, 1,1);

		this.aurorareflect_uniforms = {
			planeMode: { type: "i", value: 1 },
			viewVector: { type: "v3", value: this.camera.position },
			width: { type: "f", value: wWidth },
			height: { type: "f", value: wHeight },
			demoTime: { type: "f", value: 0 },
			sphereRadius: { type: "f", value: 0 },
			normalMode: { type: "i", value: 0 },
			reflectMode: { type: "i", value: 1 },
			auroraNorth: { type: "f", value: 1 },
			auroraSouth: { type: "f", value: 1 },
			planeNormal: { type: "v3", value: {x: 0, y: 0, z: 0} },
			var1: { type: "f", value: 1 },
			var2: { type: "f", value: 1 },
			var3: { type: "f", value: 1 }
		};

		this.aurorareflect_material = new THREE.ShaderMaterial(
			{
				uniforms: this.aurorareflect_uniforms,
				vertexShader: shaders.vertexShader_aurora,
				fragmentShader: shaders.fragmentShader_aurora,
				side: THREE.FrontSide,
				blending: THREE.NormalBlending,
				transparent: true
			}
		);

		this.aurorareflect = new THREE.Mesh(this.aurorareflect_geo, this.aurorareflect_material);		
		//this.scene.add(this.auroraplane);
		this.aurorareflect.position.set(0, 12000, 0);
		this.aurorareflect.rotation.x = deg2rad(95);

		this.scene.add(this.aurorareflect);


		this.aurora_scene.add(this.auroraplane);
		//this.aurora_scene.add(this.aurora_mask);
		this.aurora_scene2.add(this.normalplane);

		this.mountain_scene = new THREE.Scene();
		var mountainMask2 = this.mountain.clone();
		this.mountain_scene.add(mountainMask2);


		this.aurora_blur_uniforms = {
			"tDiffuse": { type: "t", value: null },
			mapTexture: { type: "t", value: buffer3 },
			mapTextureBack: { type: "t", value: buffer3 },
			normalTexture: { type: "t", value: buffer4 },
			viewVector: { type: "v3", value: this.camera.position },
			planeNormal: { type: "v3", value: {x: 0, y: 0, z: 0} },
			auroraScale: { type: "f", value: 0.0025 },
			planeMode: { type: "i", value: 1 }
		};

		this.auroraPassShader = {
			uniforms: this.aurora_blur_uniforms,

			vertexShader: [
				"varying vec2 vUv;",
				"void main() {",
					"vUv = uv;",
					"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",
				"}"
			].join("\n"),

			fragmentShader: shaders.fragmentShader_aurorablur
		};


		this.starfield = starfield(100000,10000);
		this.scene.add(this.starfield);

		this.composer = new THREE.EffectComposer(renderer);

		this.aurora_pass = new THREE.ShaderPass(this.auroraPassShader);		
		this.composer.addPass(this.aurora_pass);


		var auroraBlurH = new THREE.ShaderPass(THREE.HorizontalBlurShader);
		var auroraBlurV = new THREE.ShaderPass(THREE.VerticalBlurShader);
		this.composer.addPass(auroraBlurH);
		this.composer.addPass(auroraBlurV);

		var bloompassAurora = new THREE.BloomPass(1);
		this.composer.addPass(bloompassAurora);

		var removeMountains = new THREE.ShaderPass(THREE.RemoveNonTransparentShader);
		removeMountains.uniforms['tDiffuse2'].value = buffer6;
		this.composer.addPass(removeMountains);

		var saveAurora = new THREE.SavePass(buffer5);
		this.composer.addPass(saveAurora);


		// Render torus for bloom
		var renderpass = new THREE.RenderPass(this.torusScene, this.camera);
		this.composer.addPass(renderpass);

		var bloompass = new THREE.BloomPass(0.65);
		this.composer.addPass(bloompass);

		var copyPass = new THREE.SavePass(buffer2);
		this.composer.addPass(copyPass);

		// Disable the aurora meshs
		this.composer.addPass(new THREE.ChangeVisPass([this.aurorareflect], false));

		// Render actual scene
		var renderpass2 = new THREE.RenderPass(this.scene, this.camera);
		this.composer.addPass(renderpass2);

		// Enable them again
		this.composer.addPass(new THREE.ChangeVisPass([this.aurorareflect], true));

		var blendPass2 = new THREE.ShaderPass(THREE.AdditiveBlendShader);
		blendPass2.uniforms['tDiffuse2'].value = buffer2;
		this.composer.addPass(blendPass2);


		//var loadAurora = new THREE.TexturePass(buffer5);
		//this.composer.addPass(loadAurora);


		var blendPass3 = new THREE.ShaderPass(THREE.AdditiveBlendShader2);
		blendPass3.uniforms['tDiffuse2'].value = buffer5;
		this.composer.addPass(blendPass3);

		this.fxaaPass = new THREE.ShaderPass(THREE.FXAAShader);
		this.fxaaPass.uniforms[ 'resolution' ].value = new THREE.Vector2( 1 / wWidth, 1 / wHeight );
		this.composer.addPass(this.fxaaPass);

		//this.composer.addPass(this.aurora_pass);

		//this.final_pass = new THREE.ShaderPass(FinalPassShader);
		//this.final_pass.renderToScreen = true;
		this.composer.addPass(final_pass);
	}

	this.render = function(scene_time, percent)
	{
		//this.normalplane_uniforms.planeNormal.value = {x: getVal("var1"),y: getVal("var1"),z: getVal("var1")};
		//this.normalplane_uniforms.planeNormal.value.x = getVal("var1");
		//this.normalplane_uniforms.planeNormal.value.y = getVal("var2");
		
		this.starfield.rotation.set(0.2,-0.2,scene_time/50);

		this.auroraplane_uniforms.var1.value = getVal("var1");
		this.auroraplane_uniforms.var2.value = getVal("var2");
		this.auroraplane_uniforms.var3.value = getVal("var3");

		this.aurorareflect_uniforms.var1.value = getVal("var1");
		this.aurorareflect_uniforms.var2.value = getVal("var2");
		this.aurorareflect_uniforms.var3.value = getVal("var3");
		
		this.auroraplane_uniforms.auroraNorth.value = getVal("var7");
		this.aurorareflect_uniforms.auroraNorth.value = getVal("var7");

		this.normalplane_uniforms.planeNormal.value.x = 0.5;
		this.normalplane_uniforms.planeNormal.value.y = 1.0;
		this.normalplane_uniforms.planeNormal.value.z = 0.0;

		this.normalplane_uniforms.viewVector.value = this.camera.position;
		this.auroraplane_uniforms.viewVector.value = this.camera.position;
		this.auroraplane_uniforms.demoTime.value = scene_time;
		this.aurorareflect_uniforms.demoTime.value = scene_time;

		// Render the aurora normal plane and aurora pattern plane for the aurorablur shader.
		renderer.render(this.aurora_scene, this.camera, buffer3, true);
		renderer.render(this.aurora_scene2, this.camera, buffer4, true);

		renderer.render(this.mountain_scene, this.camera, buffer6, true);

		//renderer.render(this.aurora_scene, this.camera);
		//renderer.render(this.aurora_scene2, this.camera);

		//var auroraTime = scene_time;
		// Offset time to find good effects from plasma
		//this.aurora_uniforms.u_time.value = rocketTracks.terrain_aurora.getValue(row);
		//this.mountain_uniforms.u_time.value = rocketTracks.terrain_aurora.getValue(row);

		this.torusKnot.scale.x = this.torusCopy.scale.x = getVal("var6");
		this.torusKnot.scale.y = this.torusCopy.scale.y = getVal("var6");
		this.torusKnot.scale.z = this.torusCopy.scale.z = getVal("var6");
		
		this.camera.position.x = getVal("var4");
		this.camera.lookAt(new THREE.Vector3(0, 100, 0));

		this.torusKnot.position.y = this.torusCopy.position.y = getVal("var5");


		this.torusKnot.rotation.x = this.torusCopy.rotation.x = scene_time;
		this.torusKnot.rotation.y = this.torusCopy.rotation.y = scene_time / 2.0;
		this.torusKnot.rotation.z = this.torusCopy.rotation.z = scene_time / 6.0;
		
		this.ms_Water.material.uniforms.time.value += 1.0 / 60.0;
		this.ms_Water.render();

		this.composer.render();
		//renderer.render(this.scene, this.camera);
	}
}