function scene_textparticles()
{
	this.load = function(text)
	{
		this.scene = new THREE.Scene();
		this.camera = new THREE.PerspectiveCamera(45, 16/9, 0.1, 200); // view angle, aspect, near, far
		this.camera.position.set(10, 10, 30);
		this.camera.lookAt(this.scene.position);

		//this.controls = new THREE.OrbitControls( this.camera, renderer.domElement );

		var geom = new THREE.TextGeometry(text, {
			size: 5.0,
			height: 0.1,
			curveSegments: 5,
			font: "harabarahand",
			style: "italic"
		});
		geom.computeBoundingBox();

		var uniforms = {
			"amount": { "type": "f", "value": 0.0 },
			"amount2": { "type": "f", "value": 0.0 }
		};

		var particleMat = new THREE.ShaderMaterial( {
			uniforms:       uniforms,
			vertexShader:   shaders.vertexShader_textparticles,
			fragmentShader: shaders.fragmentShader_textparticles,
			transparent: true
		});

		this.particles = new THREE.ParticleSystem(geom, particleMat);
		this.particles.position.x = (geom.boundingBox.min.x - geom.boundingBox.max.x) / 2;
		this.particles.position.y = 2;
		this.scene.add(this.particles);

		this.renderPass = new THREE.RenderPass(this.scene, this.camera);
		this.blurPass = new THREE.BloomPass(1.0, 25, 2, 512);
	}

	this.render = function(scene_time, percent)
	{
		this.particles.material.uniforms["amount"].value = getVal("var1");
		this.particles.material.uniforms["amount2"].value = getVal("var2");

		//this.camera.position.x = this.lerp(20, -20, percent);
		var radius = getVal("var4");
		var deg = deg2rad(getVal("var3"));
		this.camera.position.set(Math.sin(deg) * radius,0,Math.cos(deg) * radius);
		this.camera.position.y = getVal("var5");
		this.camera.lookAt({x: 0, y: 1, z: 0});

		effectcomposer.doPass(this.renderPass);
		effectcomposer.doPass(this.blurPass);
		effectcomposer.doPass(final_pass);
	}

	this.lerp = function(s, e, p) {
		return s - ((s - e) * p);
	}
}