function scene_tunnel() {
	this.scenename = "Tunnel"

	this.load = function()
	{
		this.scene = new THREE.Scene();
		this.scene.fog = new THREE.Fog(0x000000, 10, 60);
		this.scene.add(this.scene.fog);
		//this.scene.fog	= new THREE.FogExp2( 0x000000, 0.5 );

		this.camera = new THREE.PerspectiveCamera(45, 16/9, 0.1, 100);
		//this.camera.position.set(0,0,-23);
		this.camera.position.set(0,24,0);
		this.camera.rotation.set(deg2rad(-90),0,0);

		//this.controls = new THREE.OrbitControls( this.camera, renderer.domElement );

		this.cylinder_geometry = new THREE.CylinderGeometry(10,7,50,100,10,true);

		this.cylinder_uniforms = {
			dayTexture: { type: "t", value: tex.earth_day_hires },
			nightTexture: { type: "t", value: tex.earth_night_hires },
			cloudTexture: { type: "t", value: tex.earth_clouds2_hires },
			waterTexture: { type: "t", value: tex.earth_water_hires },
			viewVector: { type: "v3", value: this.camera.position },
			sunVector: { type: "v3", value: this.camera.position },
			cloudOffset: { type: "f", value: 0.0 },
			yOffset: { type: "f", value: 0.0 },
			insideEarth: { type: "i", value: 1 },
			tubeFog: { type: "i", value: 1 },
			flipXY: { type: "i", value: 0 },
			blink: { type: "f", value: 0.0 },
			sunblink: { type: "f", value: 100.0 },
		};

		this.cylinder_material = new THREE.ShaderMaterial(
		{
			uniforms: this.cylinder_uniforms,
			vertexShader: shaders.vertexShader_globe,
			fragmentShader: shaders.fragmentShader_globe,
			side: THREE.DoubleSide,
			blending: THREE.NormalBlending,
			transparent: true
		}
		);
		
		this.light = new THREE.PointLight(0xffffff, 1, 100);

		

		this.cylinder = new THREE.Mesh( this.cylinder_geometry, this.cylinder_material );
		//this.cylinder.rotation.set(deg2rad(-90),0,0);

		this.cloud_uniforms = {
			cloudTexture: { type: "t", value: tex.earth_clouds2_hires },
			cloudlightsTexture: { type: "t", value: tex.earth_cloudlights_hires },
			sunVector: { type: "v3", value: this.camera.position },
			insideEarth: { type: "i", value: 1 },
			tubeFog: { type: "i", value: 1 },
			textureOffset: { type: "f", value: 0.0 },
			yOffset: { type: "f", value: 0.0 },
			blink: { type: "f", value: 0.0 },
			sunblink: { type: "f", value: 100.0 },
		};

		this.cloud_material = new THREE.ShaderMaterial(
		{
			uniforms: this.cloud_uniforms,
			vertexShader: shaders.vertexShader_globeclouds,
			fragmentShader: shaders.fragmentShader_globeclouds,
			side: THREE.BackSide,
			blending: THREE.NormalBlending,
			transparent: true
		}
		);

		this.clouds = new THREE.Mesh(this.cylinder_geometry.clone(), this.cloud_material);
		this.clouds.scale.set(0.96,1,0.96);
		//this.clouds.rotation.set(deg2rad(-90),0,0);
		this.clouds.visible = true;


		this.sun_inside_uniforms = {
			sceneTime: { type: "f", value: 0.0 },
			scale: { type: "f", value: 0.0 },
			scaleFactor: { type: "f", value: 1.0 },
			bumpScale: { type: "f", value: 1.0 }
		};

		this.sun_inside_material = new THREE.ShaderMaterial(
			{
				uniforms: this.sun_inside_uniforms,
				vertexShader: shaders.vertexShader_sun,
				fragmentShader: shaders.fragmentShader_sun,
				side: THREE.FrontSide
			}
		);

		this.sun_inside_geometry = new THREE.SphereGeometry(1.5,200,200);
		this.sun_inside = new THREE.Mesh(this.sun_inside_geometry, this.sun_inside_material);
		

		/*this.text_geometry = new THREE.TextGeometry('test',{
			size: 5,
			height: 1,
			curveSegments: 20,
			
			font: 'optimer',
			weight: 'normal',
			style: 'normal',
			bevelThickness: 0,
			bevelSize: 0,
			bevelEnabled: 0,

			material: 0,
			extrudeMaterial: 1
		});*/

		this.light = new THREE.PointLight(0x606060, 0.4, 13);
		this.ambient = new THREE.AmbientLight(0x101010);
		this.directional = new THREE.DirectionalLight(0xffffff, 0.7);
		this.directional.position.set(0,30,30);

		this.text = new THREE.Object3D();
		this.text.add(this.createTextMesh("Code by\nchr\nnitelite"));
		this.text.add(this.createTextMesh("Music by\naudiophile\nsynchrotron"));
		this.text.add(this.createTextMesh("Timing by\ntelc"));
		this.text.add(this.createTextMesh("Galaxies by\naxelbs"));

		this.text.add(this.createTextMesh("Greets to:"));
		this.text.add(this.createTextMesh("chiller"));
		this.text.add(this.createTextMesh("Indigo"));
		this.text.add(this.createTextMesh("darklite"));
		this.text.add(this.createTextMesh("bitflavour"));
		this.text.add(this.createTextMesh("sandsmark"));
		this.text.add(this.createTextMesh("TG Creativia\nCrew"));
		this.text.add(this.createTextMesh("and all the other"));
		this.text.add(this.createTextMesh("creative people"));
		this.text.add(this.createTextMesh("at"));
		this.text.add(this.createTextMesh("The Gathering 2014"));

		for(var i = 0; i < 4; i++) {
			this.text.children[i].position.y -= (i * 40);
		}
		for(var i = 4; i < this.text.children.length; i++) {
			this.text.children[i].position.y -= 120 + (i * 20);	
		}

		this.scene.add(this.text);		

		this.renderpass = new THREE.RenderPass(this.scene, this.camera);

		this.fxaaPass = new THREE.ShaderPass(THREE.FXAAShader);
		this.fxaaPass.uniforms[ 'resolution' ].value = new THREE.Vector2( 1 / wWidth, 1 / wHeight );

		this.scene.add(this.ambient);
		this.scene.add(this.directional);

		this.scene.add(this.sun_inside);
		this.scene.add(this.cylinder);
		this.scene.add(this.clouds);
		this.scene.add(this.light);
	}

	this.createTextMesh = function(text, color) {
		if (color === undefined) {
			color = 0x5FE3FE;
		}

		var text_material = new THREE.MeshLambertMaterial( {"color": color, "emissive": color, "opacity": 1.0, "transparent": true} );
		
		var group = new THREE.Object3D();

		var lines = text.split("\n");
		var z = 0;

		for(var i = 0; i < lines.length; i++) {
			var geom = new THREE.TextGeometry(lines[i], {
				size: (lines.length > 1 && i === 0) ? 0.6 : 1,
				height: 0.3,
				curveSegments: 10,
				font: "helvetiker"
			});	

			geom.computeBoundingBox();

			var mesh = new THREE.Mesh(geom, text_material);
			mesh.rotation.set(deg2rad(-90), 0, 0);
			mesh.position.z = z;
			mesh.position.x = -1 * ((geom.boundingBox.max.x - geom.boundingBox.min.x) / 2);

			
			z += 1.45;//( geom.boundingBox.max.y - geom.boundingBox.min.y ) + 0.4;

			group.add(mesh);
		}

		group.position.z = -1;

		return group;
	}

	this.render = function(scene_time,percent)
	{
		renderer.sortObjects = false;

		//this.controls.update();

		this.cylinder_uniforms.yOffset.value = -scene_time*0.3;
		this.cloud_uniforms.yOffset.value = this.cylinder_uniforms.yOffset.value;
		//this.cylinder_uniforms.sunVector.value = this.camera.position;

		var anim = scene_time;

		var cam_offset = 0.5;
		var sun_offset = 0.5;


		var cam_radius = Math.sin(scene_time)*2+6;
		cam_radius = 5;
		var cam_deg = anim + Math.sin(scene_time);
		cam_pos_x = Math.sin(cam_deg)*cam_radius;
		cam_pos_z = Math.cos(cam_deg)*cam_radius;

		var look_radius = 7;
		var look_deg = anim + cam_offset;
		look_pos_x = Math.sin(look_deg)*look_radius;
		look_pos_z = Math.cos(look_deg)*look_radius;

		var sun_radius = 6;
		var sun_deg = anim + sun_offset;
		sun_pos_x = Math.sin(sun_deg)*sun_radius;
		sun_pos_y = Math.cos(sun_deg)*sun_radius;
		sun_pos_y = 9;
		sun_pos_z = Math.cos(sun_deg)*sun_radius;


		this.camera.position.x = cam_pos_x;
		this.camera.position.z = cam_pos_z;
		this.camera.rotation.set(deg2rad(-90), Math.cos(scene_time)*0.2, Math.sin(scene_time)*0.5);
		//this.camera.lookAt({x: look_pos_x, y: -15, z: look_pos_z});

		this.sun_inside.position.set(sun_pos_x, sun_pos_y, sun_pos_z);
		//this.sun_inside.position.set(Math.sin(scene_time)*10,0,0);
		this.sun_inside_uniforms.sceneTime.value = scene_time;
		this.sun_inside_uniforms.scale.value = 1;

		sunpos = this.sun_inside.position;

		//this.cylinder_uniforms.sunVector.value = {x: sunpos.x, y: sunpos.z, z: sunpos.y};
		this.cylinder_uniforms.sunVector.value = this.sun_inside.position;
		this.cloud_uniforms.sunVector.value = this.sun_inside.position;
		this.cloud_uniforms.textureOffset.value = scene_time/50;
		this.cylinder_uniforms.cloudOffset.value = this.cloud_uniforms.textureOffset.value;


		this.cylinder_uniforms.blink.value = getVal("var1");
		this.cloud_uniforms.blink.value = getVal("var1");


		this.text.position.y = getVal("var2");


		this.cylinder_uniforms.sunblink.value = getVal("var4");
		this.cloud_uniforms.sunblink.value = getVal("var4");
		
		this.sun_inside_uniforms.scaleFactor.value = 0.5+getVal("var3")/100;
		this.sun_inside_uniforms.bumpScale.value = 0.5+getVal("var5");

		//renderer.render(this.scene, this.camera);
		effectcomposer.doPass(this.renderpass);
		effectcomposer.doPass(this.fxaaPass);
		effectcomposer.doPass(final_pass);

		renderer.sortObjects = true;
	}
}