
// Timing of all the scenes in the demo.

/*
	  14.7 - First change in tempo
	  28.7 - Second change in temp
	  42.3 - Crescendo
	  	45.80
	  	49.15
	  	52.67
	  56.0 - Slow down
	  69.8 - Another crescendo
	  83.1 - Trumpets - sunrise?
	 111.0 - Pitch up
	 138.4 - Slow pace outro starts
	 164.3 - Fade out

*/

function load_timeline()
{
	scene_composer.add(scenes.title_screen, scenes.title_screen.render, 14.5, {in: ['black', 4], out: ['black', 5],});

	scene_composer.add(scenes.globe, scenes.globe.slow_zoom_to_earth, 14, {in: ['black', 2], out: ['black', 2],});
	// 28.5 sec

	scene_composer.add(scenes.globe, scenes.globe.descend, 13.7, {in: ['black', 1], out: ['black', 1],});
	// 42.3 sec

	scene_composer.add(scenes.globe, scenes.globe.orbit5, 3.5, {in: ['black', 0.1]});
	scene_composer.add(scenes.globe, scenes.globe.orbit2, 3.5, {});
	scene_composer.add(scenes.globe, scenes.globe.orbit3, 3.5, {});
	scene_composer.add(scenes.globe, scenes.globe.orbit2, 10, {in: ['black', 1], out: ['black', 1],});

	// First scene of the earth. Start wide and slowly come closer.
	scene_composer.add(scenes.globe, scenes.globe.slow_zoom_to_earth, 15, {in: ['black', 7], out: ['black', 1],});

	// Start out in space and zoom into the earth. fadeout rihgt before crashing.
	scene_composer.add(scenes.globe, scenes.globe.zoom_into_earth, 3, {in: ['black', 0.5], out: ['black', 0.2],});

}