package gui;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.JButton;

import main.LagreProdukter;
import main.Main;
import main.Produkt;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.io.IOException;

import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class MainGUI extends JFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private JPanel contentPane;
	private JTextField textProdNavn;
	private JTextField textSalgPris;
	private JTextField textKjopsPris;
	private JLabel lblLeggTilNy;
	private JLabel lblProdukter;
	private JButton btnLagreDatabase;
	private JLabel lblProduktId;
	private JTextField textProdID;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					MainGUI frame = new MainGUI();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public MainGUI() {
		setResizable(false);
		setTitle("Varelager");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 454, 302);
		contentPane = new JPanel();
		contentPane.addFocusListener(new FocusAdapter() {
			@Override
			public void focusGained(FocusEvent arg0) {
				
				lblProdukter.setText(Produkt.getAntallProdukt()+"");
				}
		});
		
		JMenuBar menuBar = new JMenuBar();
		setJMenuBar(menuBar);
		
		JMenu mnVis = new JMenu("Vis...");
		menuBar.add(mnVis);
		
		JMenuItem mntmProdukter = new JMenuItem("Produkter");
		mntmProdukter.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				
				ListProdukter visProd = new ListProdukter();
				visProd.setVisible(true);
			}
		});
		mnVis.add(mntmProdukter);
		
		JMenu mnDebug = new JMenu("DEBUG");
		menuBar.add(mnDebug);
		
		JMenuItem mntmAddProdukter = new JMenuItem("Add Produkter");
		mntmAddProdukter.setToolTipText("Legger 5 ting i databasen.");
		mntmAddProdukter.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				
				String[] nameArray = {"Bil","Bt","Sykkel","Sparkesykkel","Fly"};
				int[] intArray = {1,2,3,4,5};
				double[] doubleArray = {1000,2000,3000,4000,5000};
				double[] doubleArray2 = {100,200,300,400,500};
				
				Produkt prod1 = new Produkt(nameArray[0], intArray[0], doubleArray[0], doubleArray2[0]);
				Main.getProdList().add(prod1);
				Produkt prod2 = new Produkt(nameArray[1], intArray[1], doubleArray[1], doubleArray2[1]);
				Main.getProdList().add(prod2);
				Produkt prod3 = new Produkt(nameArray[2], intArray[2], doubleArray[2], doubleArray2[2]);
				Main.getProdList().add(prod3);
				Produkt prod4 = new Produkt(nameArray[3], intArray[3], doubleArray[3], doubleArray2[3]);
				Main.getProdList().add(prod4);
				Produkt prod5 = new Produkt(nameArray[4], intArray[4], doubleArray[4], doubleArray2[4]);
				Main.getProdList().add(prod5);
				
				lblProdukter.setText(Produkt.getAntallProdukt()+"");
				
			}
		});
		mnDebug.add(mntmAddProdukter);
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		
		JLabel lblProduktNavn = new JLabel("Produkt Navn:");
		lblProduktNavn.setBounds(21, 44, 84, 14);
		lblProduktNavn.setHorizontalAlignment(SwingConstants.TRAILING);
		
		JLabel lblNewLabel = new JLabel("Salgs Pris:");
		lblNewLabel.setBounds(10, 70, 95, 14);
		lblNewLabel.setHorizontalAlignment(SwingConstants.TRAILING);
		
		JLabel lblNewLabel_1 = new JLabel("Inkj\u00F8ps Pris:");
		lblNewLabel_1.setBounds(15, 92, 90, 14);
		lblNewLabel_1.setHorizontalAlignment(SwingConstants.TRAILING);
		
		textProdNavn = new JTextField();
		textProdNavn.setBounds(109, 41, 86, 20);
		textProdNavn.setColumns(10);
		
		textSalgPris = new JTextField();
		textSalgPris.setBounds(109, 67, 86, 20);
		textSalgPris.setColumns(10);
		
		textKjopsPris = new JTextField();
		textKjopsPris.setBounds(109, 92, 86, 20);
		textKjopsPris.setColumns(10);
		
		lblLeggTilNy = new JLabel("Legg til ny...");
		lblLeggTilNy.setBounds(15, 16, 280, 14);
		lblLeggTilNy.setHorizontalAlignment(SwingConstants.CENTER);
		
		JButton btnLeggTilProdukt = new JButton("Legg til Produkt");
		btnLeggTilProdukt.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				
				String prodnavn = textProdNavn.getText();
				String prodID = textProdID.getText();
				String innkjopsPris = textKjopsPris.getText();
				String salgsPris = textKjopsPris.getText();
				
				double salgsPrisN;
				double innkjopsPrisN;
				int prodIDn;
				
				try {
					salgsPrisN = Double.parseDouble(salgsPris);
					innkjopsPrisN = Double.parseDouble(innkjopsPris);
					prodIDn = Integer.parseInt(prodID);
					
					
					
					Produkt prod = new Produkt(prodnavn, prodIDn, salgsPrisN, innkjopsPrisN);
					Main.getProdList().add(prod);
					
					lblProdukter.setText(Produkt.getAntallProdukt()+"");
					
				} catch (NumberFormatException e) {
					
					JOptionPane.showMessageDialog(null, "Feil i Pris(er) eller ID verdi!\n" + e.getMessage() + "\n\nNB: Du m bruke . (punktum) ikke , (komma)!", "Error!", 0);
				}
				
			}
		});
		btnLeggTilProdukt.setBounds(21, 170, 132, 23);
		
		JLabel lblNewLabel_2 = new JLabel("Produkter i Systemet:");
		lblNewLabel_2.setBounds(218, 16, 169, 14);
		lblNewLabel_2.setHorizontalAlignment(SwingConstants.CENTER);
		
		JLabel lblAntallProdukter = new JLabel("Antall produkter:");
		lblAntallProdukter.setBounds(218, 41, 126, 14);
		lblAntallProdukter.setHorizontalAlignment(SwingConstants.RIGHT);
		
		lblProdukter = new JLabel("#ANTAL");
		lblProdukter.setBounds(354, 44, 71, 14);
		
		lblProdukter.setText(Produkt.getAntallProdukt()+"");
		
		
		btnLagreDatabase = new JButton("Lagre Database");
		btnLagreDatabase.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				
				try {
					new LagreProdukter(Main.getFileLoc() + "storage.txt");
				} catch (IOException e) {
					JOptionPane.showMessageDialog(null, "Error saving: " + e.toString(), "Error!", 0);
				}
				
				
			}
		});
		btnLagreDatabase.setBounds(266, 170, 159, 23);
		contentPane.setLayout(null);
		contentPane.add(lblLeggTilNy);
		contentPane.add(lblNewLabel);
		contentPane.add(lblProduktNavn);
		contentPane.add(lblNewLabel_1);
		contentPane.add(textKjopsPris);
		contentPane.add(textSalgPris);
		contentPane.add(textProdNavn);
		contentPane.add(lblNewLabel_2);
		contentPane.add(lblAntallProdukter);
		contentPane.add(lblProdukter);
		contentPane.add(btnLagreDatabase);
		contentPane.add(btnLeggTilProdukt);
		
		lblProduktId = new JLabel("Produkt ID:");
		lblProduktId.setHorizontalAlignment(SwingConstants.TRAILING);
		lblProduktId.setBounds(34, 117, 71, 14);
		contentPane.add(lblProduktId);
		
		textProdID = new JTextField();
		textProdID.setBounds(109, 117, 86, 20);
		contentPane.add(textProdID);
		textProdID.setColumns(10);
	}
}
