function wall()
{
    this.start_time = 0;
    this.end_time = 0;

	  this.angularSpeed = 0.2; 
    this.angle = 0.5;
    this.objWall, this.objChamfer=[];
    this.objParticle=[], this.objParticleCount=0;
    this.renderer, this.scene, this.camera;
    this.angleChange, this.light, this.light1;
    this.objCounter;
    var texCounter;
    this.geometry=[];
    this.counter;

    var textObj;
    var overlay4=0;
    var welove=0;
        
    this.textMaterial;


    this.aBloomFactor = 0.4, this.aBloomStrength = 1.5; // Adjust parameters as you want
    this.aEffectCopy;
    this.aEffectBloom;
    this.aRenderModel;
    

    this.addParticleSystem = function(x,y,id){
    
      // Create Particles -------------------------------------------------------------------------------------------
      this.geometry[id] = new THREE.Geometry();

			//sprite1 = THREE.ImageUtils.loadTexture( "images/particle.png" );
			sprite2 = THREE.ImageUtils.loadTexture( "images/particle2.png" );
      color = [0.95, 0.1, 0.5];    
    
			for ( i = 0; i < 150; i ++ ) {

				var vertex = new THREE.Vector3();
				vertex.x = x + Math.random() * 20 - 20;
				vertex.y = y + Math.random() * 20 - 10;
				vertex.z = Math.random() * 200 - 100;

				this.geometry[id].vertices.push( vertex );

			}

      materials = new THREE.ParticleSystemMaterial( { size: 25+Math.random()*30, map: sprite2, blending: THREE.AdditiveBlending, depthTest: true, transparent : true } );

      
			materials.color.setHSL( color[0], color[1], color[2] );
      materials.opacity = 0.4;

			this.objParticle[id] = new THREE.ParticleSystem( this.geometry[id], materials );

      this.objParticle[id].sortParticles = true;
      this.objParticle[id].position.z = -90;
			
      this.scene.add(this.objParticle[id]);      

      
      // Create Bokeh Overlay ----------------------------------------------------------------------------------------
      var map2 = THREE.ImageUtils.loadTexture( 'images/bokeh1.png' );
			map2.wrapS = map2.wrapT = THREE.RepeatWrapping;
      map2.repeat.set( 2, 1 );

			var material2 = new THREE.MeshLambertMaterial( {
        color: 0x000000,       
        specular: 0x000000,
        ambient: 0x111111,
        emissive: 0x000000,
        map: map2, 
        side: THREE.FrontSide,  
        transparent: true,
        depthTest: false
      } );
      material2.opacity = 0.1;
      
      var overlay2 = new THREE.Mesh( new THREE.PlaneGeometry( 250, 150, 1, 1 ), material2 );
      overlay2.position.set( 0, 0, -49 );
      overlay2.rotation.z = 37;
      
      this.scene.add( overlay2 );
      
      // Create Circle Overlay ----------------------------------------------------------------------------------------
      var map4 = THREE.ImageUtils.loadTexture( 'images/circle2.png' );
			map4.wrapS = map4.wrapT = THREE.RepeatWrapping;
      map4.repeat.set( 1, 1 );

			var material4 = new THREE.MeshLambertMaterial( { 
        color: 0xffffff,
        ambient: 0x112222, 
        map: map4, 
        side: THREE.FrontSide,  
        transparent: true,
        depthTest: false
      } );
      material4.opacity = 0.1;
      
      overlay4 = new THREE.Mesh( new THREE.PlaneGeometry( 250, 250, 1, 1 ), material4 );
      overlay4.position.set( 0, 0, -10 );
      
      this.scene.add( overlay4 );               
       

      // Create WeLove Overlay ----------------------------------------------------------------------------------------
      var map5 = THREE.ImageUtils.loadTexture( 'images/love.png' );
			map5.wrapS = map5.wrapT = THREE.RepeatWrapping;
      map5.repeat.set( 1, 1 );

			var material5 = new THREE.MeshLambertMaterial( { 
        color: 0xffffff,
        ambient: 0x112222, 
        map: map5, 
        side: THREE.FrontSide,  
        transparent: true,
        depthTest: false
      } );
      material5.opacity = 0.1;
      
      welove = new THREE.Mesh( new THREE.PlaneGeometry( 250, 250, 1, 1 ), material5 );
      welove.position.set( 5, 0, -10 );
      welove.rotation.z = 38;
      
      
      this.scene.add( welove );               
       
      
    }

    this.init = function(renderer, camera)
    {      
    
      this.renderer = renderer;
            
      this.camera = new THREE.PerspectiveCamera(75, window.innerWidth / window.innerHeight, 1, 1000 );
      this.camera.position.z = 110;
      this.camera.position.y = 40;
      
      this.scene = new THREE.Scene();
      this.objWall = new THREE.Object3D();
      
      // Add ChamferBox to scenegraph
      // Create Cubemap -------------------------------------------------------------------------------------------
      var path = "assets/cube/";
			var format = '.jpg';
			var urls = [
					path + 'posx_1' + format, path + 'negx_1' + format,
					path + 'posy_1' + format, path + 'negy_1' + format,
					path + 'posz_1' + format, path + 'negz_1' + format
				];

			var reflectionCube = THREE.ImageUtils.loadTextureCube( urls );
			reflectionCube.format = THREE.RGBFormat;

      var cubeMaterial = new THREE.MeshLambertMaterial( { color: 0xffffff, ambient: 0x000000 , specular: 0xffffff, envMap: reflectionCube, combine: THREE.MixOperation, reflectivity: 0.1 } );

      // Create Cube Wall -------------------------------------------------------------------------------------------
      var i=0, m=0;
      var xg = 25, yg = 15;
      
      for (var x = 0; x<xg; x++)
        for (var y = 0; y<yg; y++)
          {
            
            this.objChamfer[i] = create_chamfer_0();
            this.objChamfer[i].material = cubeMaterial;
          
            this.objChamfer[i].position.set( -100+x*20, -100+y*20 , 0);
            this.objWall.add( this.objChamfer[i] ); 
          
            if (m == 37)
            // if ((y&12) == 0)
            {
              this.objWall.children[i].visible = false;
              this.addParticleSystem(-90+x*20, -100+y*20, this.objParticleCount);
              this.objParticleCount++;
              this.addParticleSystem(-590+x*20, -100+y*20, this.objParticleCount);
              this.objParticleCount++;

              // this.addParticleSystem(-90+this.objWall.children[i].position.x*20, -120+this.objWall.children[i].y*20);              
              m=0;
            } 
            
            i++;   
            m++;
            
          }      
        
      this.objCounter = i;        
      this.scene.add(this.objWall);
      this.objWall.scale.z = 0.5;

      // this.addTextGeometry(this.scene);
      var loader = new THREE.OBJLoader();
      var scene = this.scene;      
      // var obj_map = this.blob_text;
      // var obj_bumpmap = this.blob_text_norms;
      loader.load('assets/greets.obj', function(object) 
      {
        object.traverse(function(child) 
        {

          this.textMaterial = new THREE.MeshFaceMaterial( [ 
              new THREE.MeshPhongMaterial( { color: 0xff0000, ambient: 0xff0000, shading: THREE.FlatShading } ), // front
              //new THREE.MeshPhongMaterial( { color: 0xffffff, ambient: 0xffffff, shading: THREE.SmoothShading } ) // side
          ] );    

          if (child instanceof THREE.Mesh) 
          {
            child.material.specular = 0xff0000;
            child.material = this.textMaterial;

          }

        });

        scene.add(object);        

        //object.rotation.z = -0.25;      
        object.rotation.x = 1.6;
        object.position.z = 7; 
        object.position.y = 50;
        object.position.x = 900;
        object.scale.z = object.scale.x = 3.0;  

        textObj = object; 
      }); 


      
      // Add Maiin light to scenegraph
      this.light = new THREE.AmbientLight( 0xffffff );
      //this.light.castShadow = true;
      this.scene.add(this.light);

      
      this.light1 = new THREE.SpotLight( 0xff3333, 0.4 );
      this.light1.position.set(0, 0, 50);
      this.light1.target.position.set(0, 0, 0);
      //this.light.castShadow = true;
      this.scene.add(this.light1);

            
      // Init the Bloom postprocessing ---------------------------------------------------
      this.aEffectBloom = new THREE.BloomPass(this.aBloomStrength, this.aBloomFactor * 25.0, this.aBloomFactor * 4.0, 512 );
     
      // Create the post-effect system
      this.aEffectCopy = new THREE.ShaderPass(THREE.CopyShader);
      this.aEffectCopy.renderToScreen = true;    
      this.aRenderModel = new THREE.RenderPass(this.scene, this.camera);               
     
      // Create the rendering pass
      this.composer = new THREE.EffectComposer(this.renderer);
      this.composer.addPass(this.aRenderModel);
      this.composer.addPass(this.aEffectBloom);
      this.composer.addPass(this.aEffectCopy);   

    };

    this.setupRenderer = function(){
    
      var time = Date.now() * 0.00005;
          
      this.renderer.setClearColor( 0x222222, 1.0 );

      this.renderer.autoClear  = false;   
      this.camera.fov = 70;
      this.camera.updateProjectionMatrix();
      
      
      this.camera.position.z = 96.0 + (25.0*Math.sin(time*20));
      this.camera.position.x = 24;
      this.camera.rotation.z = 38;

      //key('w', function(){ alert("-");this.angle -=0.1 });
      //key('x', function(){ this.angle +=0.1 });    
    }

    this.preRenderer = function(){
        this.composer.render();    
    }
    
    this.render = function(demoFrame)
    {
        
    	  //this.angleChange = this.angularSpeed * demoFrame * 2 * Math.PI / 1000;

        this.light1.position.x = 200.0*Math.cos(demoFrame);
        this.light1.position.y = 200.0*Math.sin(demoFrame);

        for (var k = 0; k<this.objParticleCount; k++)
        {
          this.objParticle[k].position.x -= 1;
          this.objParticle[k].position.z += 0.1;
         
         // enlever particle system du la scene
         // recréer un systeme de paricule au coord.
                   
          if(this.objParticle[k].position.x < -119 ){
            var tmpy = this.objParticle[k].position.y;
            this.objParticle[k].position.x = 379;
          }
        }

        for (var x = 0; x<this.objCounter; x++)
        {
          this.objWall.children[x].position.x -= 1; 
          
          if(this.objWall.children[x].position.x < -159 )
            this.objWall.children[x].position.x = 340;
        }

        textObj.position.x -= demoFrame*107;
        //overlay4.rotation.y += demoFrame*2.0;
        
        //this.renderer.render(this.scene, this.camera);
        this.composer.render();
    }

}