import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {

    Camera {
        property string name: "camera"

        x: sync("camera.x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")

        property real camUpX: sync("camera.upX")
        property real camUpY: sync("camera.upY")

        property real camRoll: sync("camera.roll")
        upX: Math.sin(camRoll)*camUpY+Math.cos(camRoll)*camUpX
        upY: Math.cos(camRoll)*camUpY-Math.sin(camRoll)*camUpX
        upZ: sync("camera.upZ")
    }




    Shader {
        file: sceneDir+"smDust"
    }

    Texture {
        textureUnit: 0
        textureItem: kuvas
        Image {
            id: kuvas
            visible: false
            //source: "../../images/StarDusts1.png"
            source: "../../images/Stardusts1.png"

          //  source: "../../images/apo-mist-9090724-357_2.png"
         //   source: "../../images/Stardust1.jpg"
         //   source: "../../images/_SK57416.png"
         //   source: "../../images/bokeh5.png"
        //    source: "../../images/noisep1s.png"
        }
    }

    Texture {
        textureUnit: 1
        textureItem: kuvas22
        Image {
            id: kuvas22
            visible: false
         //   source: "../../images/apo-mist-9090724-357_2.png"

            source: "../../images/_SK57414_normal.png"
         //   source: "../../images/bokeh5.png"
        //    source: "../../images/noisep1s.png"
        }
    }

    //ZeppoHeviaMeetsBezier16.png
    DrawMesh {
        Clear {
            cR: 0.0; cG: 0.0; cB: 0.0
        }

//        Clear {
//            cR: 0.150; cG: 0.150; cB: 0.30
//        }
        property string name: "luola"
        file: "mesh/aivob.x"
       // file: "mesh/Drill002.dae"

        depthWrite: false

        Rot { d: 1.0; ax: 0.0; ay: 1.0; az: 0.0 }
        Sca { s: 1.50; y: 100.0; }

        ShaderParam {
            paramName: "g_uvOfsX"
            paramValue: sync("uvOfsX")+rocket.time*0.0
        }
        ShaderParam {
            paramName: "g_alpha"
            paramValue: sync("stardust.a")+rocket.time*0.0
        }
    }








    Texture {
        textureUnit: 0
        textureItem: kuvaEdge
        Image {
            id: kuvaEdge
            visible: false
          //  source: "../../images/Levikset.png"
            source: "../../images/Space_reps_2.png"
          //  source: "../../images/Stardusts1.png"


       //     source: "../../images/stadion_taivas_bb.png"

        }
    }

    Texture {
        textureUnit: 1
        textureItem: noiseTex
        Image {
            id: noiseTex
            visible: false
            source: "../../images/random16.png"
        }
    }
    Shader {
        file: sceneDir+"smEdge"
    }
    DrawMesh {
//        Clear {
//            cR: 0.150; cG: 0.150; cB: 0.30
//        }

        Pos { x: sync("edge.x"); y: sync("edge.y"); z: sync("edge.z"); }

        Rot { d: 90; ax: 1.0; ay: 0.0; az: 0.0 }
        property string name: "mesh2"
        //file: "mesh/SpacePlane200x200.lwo"
        file: "mesh/400x400.obj"
        //file: "mesh/500x500.lwo"
        Sca { s: 0.50; x: 3.0*sync("edge.sxz"); y: 3.0*sync("edge.sxz"); z: 1.0 }

 // depthWrite: false
//   depthWrite: true
        ShaderParam {
            paramName: "g_gamma"
            paramValue: sync("edgeGamma")
        }

        ShaderParam {
            paramName: "g_alpha"
            paramValue: sync("edgeAlpha")
        }

        ShaderParam {
            paramName: "g_fracturePoint"
            paramValue: sync("fracturePoint")
        }

        ShaderParam {
            paramName: "g_fractureStrength"
            paramValue: sync("fractureStrength")
        }
    }



/*

    Texture {
        textureUnit: 0
        textureItem: kuvaEdge2
        Image {
            id: kuvaEdge2
            visible: false
          //  source: "../../images/Levikset.png"
            source: "../../images/Levikset.png"
          //  source: "../../images/Stardusts1.png"

        }
    }

    DrawMesh {
//        Clear {
//            cR: 0.150; cG: 0.150; cB: 0.30
//        }

        Pos { x: sync("edge.x"); y: sync("edge.y"); z: sync("edge.z"); }

        Rot { d: 90; ax: 1.0; ay: 0.0; az: 0.0 }
        property string name: "mesh2"
        file: "mesh/SpacePlane200x200.lwo"
        Sca { s: 0.02; x: 3.0*sync("edge.sxz"); y: 3.0*sync("edge.sxz"); z: 1.0 }

  depthWrite: false
//   depthWrite: true
        ShaderParam {
            paramName: "g_gamma"
            paramValue: sync("edge2Gamma")
        }

        ShaderParam {
            paramName: "g_alpha"
            paramValue: sync("edge2Alpha")
        }

    }
*/


    Texture {
        textureUnit: 0
        textureItem: kuva
        Image {
            id: kuva
            visible: false
            //source: "../../images/ZeppoHeviaMeetsBezier16.png"
            source: "../../images/_SK57414.png"
        }
    }


    Texture {
        textureUnit: 2
        textureItem: kuvasEnv
        Image {
            id: kuvasEnv
            visible: false
            source: "../../images/area_lights.jpg"
        }
    }

    Texture {
        textureUnit: 3
        textureRT: "previousFrameMeetDriller"
    }



    Shader {
        file: sceneDir+"sm"
    }
    DrawMesh {
        Pos { x: sync("drill.x"); y: sync("drill.y"); z: sync("drill.z"); }
        property string name: "mesh2"
        file: "mesh/Drill002.dae"
        Sca { s: 1.20 }
        Rot { d: sync("drillRot.x"); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: sync("drillRot.z"); ax: 0.0; ay: 0.0; az: 1.0 }
        Rot { d: sync("drillRot"); ax: 0.0; ay: 1.0; az: 0.0 }
        SavePoint {
            target: "drillerHead"
            x: 0.0; y: 1.0; z: 0.0
        }
        SavePoint {
            target: "driller"
            x: 0.0; y: 0.0; z: 0.0
        }
   }




    SetMaterial {
        shader: sceneDir+"smHippu"
        texture0: "images/adapt_logo2_full.png"
        texture1: "images/_SK57414_normal.png"
        texture2: "images/Stardusts1.png"
    }

    Repeater {
        model: 100
    DrawMesh {
        //Clear { cR: 0.150; cG: 0.150; cB: 0.30 }
        //file: "mesh/plane.x"
        //file: "mesh/aivob.x"
        file: "mesh/ball5000.x"
        //file: "mesh/seitti.x"
        //file: "mesh/Drill002.dae"
        blendMode: "add"
        depthTest: true
        depthWrite: false

        property real radde: Math.cos(index*1.23+Math.cos(index))*2.2+3.0
        Pos { x: 120.0*radde*Math.sin(index)-0.0; y: 500*Math.cos(index)-530.0; z: 120.0*radde*Math.cos(index)-200.0; }
        Rot { d: index*23; ax: 0.50; ay: 1.0; az: 0.0 }
        Sca { s: 10.0; x: 10.0; y: 0.10; z: 10.0 }
        ShaderParam {
            paramName: "g_meshExplo"
            paramValue: sync("hippu.explo")
        }
    }
    }



    Blit {
        textureRT: "previousFrameMeetDriller"
    }

    Vignette {
        posX: getSavePointX2D("driller")
        posY: getSavePointY2D("driller")
    }
    GodRay {
        godRayX: getSavePointX2D("drillerHead")
        godRayY: getSavePointY2D("drillerHead")
    }
    Tonemap {
    }



}
