#version 430

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texNorm;

in vec4 posG;
in vec3 normalG;
in vec2 uvG;
in vec3 tangentG;
in vec3 colorG;

layout(location = 0) out vec4 frag;
layout(location = 1) out vec4 frag2;

// layout(location = 0) out uvec4 uex_colour;
// layout(location = 1) out vec4 ex_colour;

uniform float g_time;

uniform float g_alpha;

uniform float g_edgeTresBlack=0.0;
uniform float g_edgeTresWhite=1.0;

uniform float g_gamma = 1.0;

uniform float g_contrastMin = 0.40;
uniform float g_contrastMax = 0.50;

void main() {

  vec3 normal = normalG;
  vec2 uv = uvG;
  vec3 tangent = tangentG;
  vec3 color = colorG;

 // color.rgb = vec3(1.0);

  vec2 myUv = uv;

  myUv.y = -myUv.y+0.0;

  myUv -= vec2(0.5, 0.5);
  myUv = myUv*3.0;
  myUv += vec2(0.5, 0.5);

  float br = 1.0;
/*
  if (myUv.x<0.01 || myUv.x > 0.99) {
      br = 0.0;
  }
  if (myUv.y<-20.0) {
      br = 0.0;
  }
  if (myUv.y>-19.0) {
      br = 0.0;
  }
  */
//  if (myUv.y<-10.01 || myUv.y > 10.99) {
//      br = 0.0;
//  }

//  myUv.x += 0.05;
//  myUv.y -= 0.01;



//  myUv.x += g_time*0.2;

 vec4 diffuse = 1.0*texture2D(tex, myUv.xy*1.0)*1.0*br+0.0*vec4(1.0);

 float diffuseA = diffuse.a;

 float tresDelta = g_edgeTresWhite-g_edgeTresBlack;

 // levels
 diffuse = ((diffuse-vec4(g_edgeTresBlack))/vec4(tresDelta));

 // gamma
 diffuse = pow(diffuse, 1.0/vec4(g_gamma));

 // contrast
 diffuse = clamp(((diffuse-vec4(g_contrastMin))*1.0/(g_contrastMax-g_contrastMin)), 0.0, 100.0);

// diffuse.rgb *= diffuse.rgb;
 diffuse *= 40.0;

 diffuse.a = diffuseA;


 // diffuse.r = pow(diffuse.r, 2.5);
 // diffuse.g = pow(diffuse.g, 1.10);
 // diffuse.b = pow(diffuse.b, 0.70);

  vec3 lightPos = vec3(0.0*cos(g_time*2.0), 0.0, 5.0);
  vec3 surfPos = vec3(0.0f, 0.0f, 0.0f);
  vec3 lightDir = lightPos-surfPos;

  float lightDist = sqrt(dot(lightDir, lightDir));

  vec3 myNormal = normal;
  vec3 biTangent = cross(myNormal, tangent);

//  float bumpX = 0.0*(texture2D(tex, myUv.xy+vec2(1.0/512.0, 0.0)).g-texture2D(tex, myUv.xy+vec2(-1.0/512.0, 0.0)).g);
//  float bumpY = 0.0*(texture2D(tex, myUv.xy+vec2(0.0, 1.0/512.0)).g-texture2D(tex, myUv.xy+vec2(0.0, -1.0/512.0)).g);


  vec4 normFromTex = texture2D(texNorm, myUv);
  float bumpStrength = 0.01;
  float bumpX = -(normFromTex.x-0.5)*bumpStrength;
  float bumpY = -(normFromTex.y-0.5)*bumpStrength;

//  bumpX = 0.0;
//  bumpY = 0.0;

  myNormal += tangent*bumpX + biTangent*bumpY;


  float normalLen = sqrt(dot(myNormal, myNormal));

  float d = dot(lightDir, myNormal)/(lightDist*normalLen);
  d = clamp(d, 0.0, 1.0);

  //d = d*0.35+pow(d, 128.0f);
  //frag = vec4(d, d, d, d);

 // frag = (diffuse+0.4)*d*0.35 + pow(d, 128.0f)+0.03;

  float specPow = 80.0;

  frag = diffuse*(d*0.1+0.01) + 2.0*pow(d, specPow);

  vec4 c = frag;


//  c.r = pow(c.r, 0.85);
//  c.g = pow(c.g, 0.55);
//  c.b = pow(c.b, 0.45);

  c.r = pow(c.r, 1.0);
  c.g = pow(c.g, 1.0);
  c.b = pow(c.b, 1.0);


  c.a = clamp(diffuse.r*1.0, 0.0, 1.0);

  c.a = smoothstep(0.0, 1.0, c.a);
 // c.a = 1.0;

  // c.rgb = vec3((posG.z/posG.w-0.9)*10.0);
  //c.rgb = vec3(gl_FragDepth*10000.0);
  // c.rgb = vec3((gl_FragCoord.z*gl_FragCoord.w-0.0)*10.0);

  float depthi = 1.0-(gl_FragCoord.z*gl_FragCoord.w-0.0)*2.0;

  frag = vec4(c.r, c.g, c.b, c.a);
  //frag.r = 1.0;

  if (g_alpha > 1.0) {
      float alphaC = clamp((g_alpha-1.0), 0.0, 1.0);
    frag.a = mix(g_alpha, diffuse.r*alphaC, alphaC);
  } else {
    frag.a = g_alpha;
  }


  vec2 uvMod = (uv-vec2(0.50,0.50))*2.0;
  uvMod.y += -0.0;
  float distanceToMiddle = dot(uvMod,uvMod);
  distanceToMiddle = pow(distanceToMiddle*1.1, 0.20);
  float fracture = 1.0/(0.02+distanceToMiddle);

  frag.rgb *= 0.15*vec3(fracture);
  frag.a = 1.0;

  //frag2 = frag;

  frag2 = vec4(c.r, c.r, c.r, 1.0);
 // frag2.rgb = vec3(depthi*depthi);

}

