import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {

    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: 0.0
        upY: -1.0
        upZ: 0.0
    }

    Texture {
        textureUnit: 0
        textureItem: kuva
        Image {
            id: kuva
            visible: false
            source: "../../images/apo-mist-9090724-357_2.png"
        }
    }

    Texture {
        textureUnit: 1
        textureItem: kuvaEnv
        Image {
            id: kuvaEnv
            visible: false
            source: "../../images/area_lights.jpg"
        }
    }

//    Shader {
//        file: sceneDir+"ssPartTrans"
//        tfVaryings: "posG,uvG"
//    }
//    DrawVB {
//        enabled: true
//        type: "pointGrid"
//        gridWidth: 200 //windowWidth/4
//        gridHeight: 200 // windowHeight/4
//        depthTest: false
//        depthWrite: false
//        ShaderParam {
//            paramName: "g_pikselos"
//            paramValue: sync("pikselos")
//        }
//    }

//    Shader {
//        file: sceneDir+"ssPart"
//    }
//    DrawVB {
//        enabled: true
//        type: "pointGridDraw"
//        gridWidth: 200 //windowWidth/4
//        gridHeight: 200 // windowHeight/4
//        depthTest: false
//        depthWrite: false
//        ShaderParam {
//            paramName: "g_pikselos"
//            paramValue: sync("pikselos")
//        }
//    }

    Shader {
        file: sceneDir+"sm"
    }

    DrawMesh {
//        Clear {
//            cR: 0.150; cG: 0.150; cB: 0.30
//        }

        property string name: "mesh2"
        file: "mesh/aivob.x"
        Sca { s: 1.0 }
        ShaderParam {
            paramName: "g_makkaraOfs"
            paramValue: sync("mesh.makkaraOfs")
        }
        ShaderParam {
            paramName: "g_makkara"
            paramValue: sync("mesh.makkara")
        }
        SavePoint {
            target: "makkara"
            x: 0.0; y: 0.0; z: 0.0;
        }
    }

    PartSim {
        name: "credits"
        gridDimension: 1024
        partSize: 0.15
    }

    Vignette {
        posX: 0.0
        posY: 0.0
    }
    GodRay {
        name: "godray1"
        godRayX: getSavePointX2D("makkara")
        godRayY: getSavePointY2D("makkara")
    }
    GodRay {
        name: "godray2"
        godRayX: getSavePointX2D("makkara")
        godRayY: getSavePointY2D("makkara")
    }
    GodRayOld {
        name: "godrayOld"
        godRayX: getSavePointX2D("makkara")
        godRayY: getSavePointY2D("makkara")
    }

    Tonemap {
    }



}
