#version 430



vec4 rotateXZ(vec4 p, float a) {
vec4 r = p;
r.x = cos(a)*p.x - sin(a)*p.z;
r.z = sin(a)*p.x + cos(a)*p.z;
return r;
}

vec3 rotateXZ3(vec3 p, float a) {
return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
vec4 r = p;
r.x = cos(a)*p.x - sin(a)*p.y;
r.y = sin(a)*p.x + cos(a)*p.y;
return r;
}


vec3 rotateXY(vec3 p, float a) {
vec3 r = p;
r.x = cos(a)*p.x - sin(a)*p.y;
r.y = sin(a)*p.x + cos(a)*p.y;
return r;
}


vec4 rotateYZ(vec4 p, float a) {
vec4 r = p;
r.y = cos(a)*p.y - sin(a)*p.z;
r.z = sin(a)*p.y + cos(a)*p.z;
return r;
}

// google glsl rand gave this, thanks and credit flies to
// http://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}


layout(points) in;
layout(points) out;
layout(max_vertices = 4) out;

//layout(line_strip, max_vertices = 15) out;

in vec3 posV[];
in vec2 uvV[];
in vec3 velV[];
in float ageV[];
in float recV[];
in vec3 posInitV[];


out vec3 posG;
out vec2 uvG;
out vec3 velG;
out float ageG;
out float recG;
out vec3 posInitG;

uniform float g_force = 1.0;
uniform float g_noiseFreq = 1.0;
uniform float g_speed = 1.0;
uniform float g_initShapeX = 1.0;
uniform float g_initShapeY = 1.0;
uniform float g_maxAge = 10.0;

uniform float g_initPosX = 0.0;
uniform float g_initPosY = 0.0;
uniform float g_initPosZ = 0.0;

uniform vec4 g_noiseScale = vec4(1.0, 5.0, 1.0, 0.0);


uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;
uniform float g_timeStep;

uniform float windowWidth = 1280.0;
uniform float windowHeight = 720.0;

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texNoise;
layout(binding=2) uniform sampler2D texEmitShape;

uniform float g_pikselos = 0.0;
in int gl_PrimitiveID;


float noise(in vec3 x) //3d noise from iq
{
    vec3 p = floor(x);
    vec3 f = fract(x);
        f = f*f*(3.0-2.0*f);
        vec2 uv = (p.xy+vec2(37.0,17.0)*p.z) + f.xy;
        vec2 rg = texture2D( texNoise, (uv+ 0.5)/256.0, -100.0 ).yx;
        return mix( rg.x, rg.y, f.z );
}

float fbm(in vec3 x)
{
    float rz = 0.;
    float a = .35;
    for (int i = 0; i<4; i++)
    {
        rz += noise(x)*a;
        a*=.5;
        x*= 4.;
    }
    return rz;
}

uniform float g_gridDim = 100.0;
uniform float g_rotOrigin = 0.0;

uniform vec4 g_noiseOfs = vec4(0.0, 0.0, 0.0, 0.0);


void main(void) {

    vec3 pos = posV[0];
    vec2 uv = uvV[0];

    vec3 vel = velV[0];
    float age = ageV[0];
    float rec = recV[0];

    vec3 posInit = posInitV[0];

   // mat4 mvp = projectionMatrix * modelViewMatrix;
    vec3 posNois = vec3(uv, 0.0);
    float tkk = 1.1;

    float distFromOrig = dot(pos,pos);

    if (age<0.001 || distFromOrig > 200.0 || age > g_maxAge-g_maxAge*1.0*fbm(pos*2330.30+vec3(g_time*1.9231,g_time,0.0))) {
        int prim = gl_PrimitiveID;

        int gridDim = int(g_gridDim);

        int primZ = 0;
        int primY = int(prim/gridDim);
        int primX = prim-primY*gridDim;

        float pullaU = float(primX)/float(gridDim);
        float pullaV = float(primY)/float(gridDim);

        if (age < 0.0001 && prim!=0) {
        // first time age is zero when we come to init
            posInit.x = (pullaU-0.5);
            posInit.z = (pullaV-0.5);
            posInit.y = 0.0;

            pos.y = (pullaU-0.5)*2.0*g_initShapeX+g_initPosX;
            pos.z = (pullaV-0.5)*2.0*g_initShapeY+g_initPosZ;
            pos.x = 0.0*2.0+g_initPosY;

            uv.x = pullaU*1.0+0.0;
            uv.y = pullaV*1.0+0.0;

        } else {
            pos.y = posInit.x*g_initShapeX+g_initPosX;
            pos.x = posInit.y*2.0+g_initPosY;
            pos.z = posInit.z*g_initShapeY+g_initPosZ;
        }

        vel = vec3(0.0);

        age = 0.01;
    }


    pos.xyz = rotateXY(pos.xyz, -g_timeStep*distFromOrig*g_rotOrigin);

    age += g_timeStep;

    pos += vel*g_timeStep*g_speed;

    float bScale = 2.4;

    vec2 myUv = uv;
    myUv.y = -myUv.y;
    myUv.x = myUv.x;

    vec4 emitShape = texture2D(texEmitShape, myUv);

    if (emitShape.r < 0.1 ) {
        return;
    }

    rec = emitShape.r*3.0;

    float myTime = g_time*1.0;
    float timeStepScale = 2.2;

/*
    posNois.x += cos(myTime*tkk+bScale*pos.y*(2.2+2.0*sin(myTime))*sin(g_time*tkk*1.2+pos.y*10.3));
    posNois.y += sin(myTime*tkk*1.23-bScale*pos.x*(2.2+2.0*cos(0.3+myTime*0.7))*cos(myTime*tkk*0.912+pos.x*10.3));
    posNois.z += 2.5*sin(myTime*tkk*1.63-bScale*pos.y*(1.2+1.0*sin(0.45+myTime*0.32))*cos(myTime*tkk*1.312+pos.y*12.3-pos.z*10.3));
    */

    float noiseFreq = 20.5*g_noiseFreq;
    posNois.x = fbm(pos.xyz*0.230*noiseFreq+0.0*vec3(g_time, g_time*1.2, 0.3));
    posNois.y = fbm(pos.yzx*0.30*noiseFreq+0.0*vec3(g_time*0.3, g_time*0.62, 0.3));
    posNois.z = fbm(pos.zyx*0.20*noiseFreq+0.0*vec3(g_time*0.1, g_time*0.12, 0.3));

    //posNois.y *= -30.0;
    posNois += g_noiseOfs.xyz;
    posNois.xyz *= g_noiseScale.xyz;


//    posNois.y += fbm(posNois.xzy*1.50*noiseFreq+0.0*vec3(g_time*0.3, g_time*0.62, 0.3));
//    posNois.z += fbm(posNois.zyx*1.20*noiseFreq+0.0*vec3(g_time*0.1, g_time*0.12, 0.3));
//    posNois.x += fbm(posNois.xyz*1.230*noiseFreq+0.0*vec3(g_time, g_time*1.2, 0.3));

//    vec4 result = texture2D(texNoise, uvNois*0.10+vec2(0.0, 0.0));


//    pos.x += 0.1*sin(pos.y*24.4+myTime)*0.1;
//    pos.y += 0.1*cos(pos.y*24.2*sin(pos.x*23.4)+myTime)*0.1;
//    pos.z += 0.005*cos(pos.y*11.2*cos(pos.x*12.4)+myTime)*0.1;

    vel.xyz += g_force*g_timeStep*posNois.xyz*timeStepScale; // (0.2+0.15*sin(g_time*1.0));

//    pos.xy += noiseValue.xy*1.1;


//    pos.z += abs(0.10*(result.r*1.0-0.5)*0.20);
//    pos.x += 0.0*(result.g*1.0-0.5)*0.20;
//    pos.y += 0.0*(result.b*1.0-0.5)*0.20;

//    pos.z += 0.0003;

//    float maxZ = 0.02;

//    if (pos.z > maxZ) {
//        pos.z = -maxZ;
//    }
// vec4 result = texture2D(tex, uv[0]+vec2(0.0, 0.0));

    //pos.x += 10.0*sin(g_time);
    //pos.y += 10.0*cos(g_time);

    posG = pos;
    uvG = uv;
    velG = vel;
    ageG = age;
    recG = rec;
    posInitG = posInit;
    EmitVertex();
    EndPrimitive();
}
