#version 430


layout (location=0) in vec3 vertexPosition;
layout (location=1) in vec3 vertexNormal;
layout (location=2) in vec2 vertexUV;
layout (location=3) in vec3 vertexTangent;
out vec3 normal;
out vec2 uv;
out vec3 tangent;
out vec4 origPos;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;


vec4 rotateXZ(vec4 p, float a) {
    vec4 r = p;
    r.x = cos(a)*p.x - sin(a)*p.z;
    r.z = sin(a)*p.x + cos(a)*p.z;
    return r;
}

vec3 rotateXZ3(vec3 p, float a) {
    return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
    vec4 r = p;
    r.x = cos(a)*p.x - sin(a)*p.y;
    r.y = sin(a)*p.x + cos(a)*p.y;
    return r;
}

vec3 rotateXY3(vec3 p, float a) {
    vec3 r = p;
    r.x = cos(a)*p.x - sin(a)*p.y;
    r.y = sin(a)*p.x + cos(a)*p.y;
    return r;
}

vec4 rotateYZ(vec4 p, float a) {
    vec4 r = p;
    r.y = cos(a)*p.y - sin(a)*p.z;
    r.z = sin(a)*p.y + cos(a)*p.z;
    return r;
}
vec3 rotateYZ3(vec3 p, float a) {
    vec3 r = p;
    r.y = cos(a)*p.y - sin(a)*p.z;
    r.z = sin(a)*p.y + cos(a)*p.z;
    return r;
}


uniform float g_jellyAnimOfs = 0.0;



uniform float g_phiOfs = 0.0;
uniform float g_thetaOfs = 0.0;
uniform float g_rFactor = 0.50;


float getTheta(vec3 v) {
  float theta = acos(v.z/sqrt(dot(v,v)));
  return theta;
}
float getPhi(vec3 v) {
  float phi = atan(v.y, v.x);
  return phi;
}

#pragma code_seg(".code_seq_calcSH")
vec3 calcSH(vec3 p, float theta, float phi, float thetaOfs, float phiOfs) {

//    int mSH[][8] = {
//      { 1, 5, 5, 1,     3, 12, 12, 3 },
//      { 3, 2, 3, 2,     2, 2, 2, 2 }
//    };

   float r;
   vec4 temp;
   float sinphi;
   int selectedSH = 0;
//   temp.x = sin(1*phi+phiOfs);
//   temp.y = cos(5*phi+phiOfs);
//   temp.z = sin(5*theta+thetaOfs);
//   temp.w = cos(1*theta+thetaOfs);

   temp.x = sin(3*phi+phiOfs);
   temp.y = cos(2*phi+phiOfs);
   temp.z = sin(3*theta+thetaOfs);
   temp.w = cos(2*theta+thetaOfs);


   r=0.0f;
   r+=pow(temp.x, 3.0);
   r+=pow(temp.y, 12.0);
   r+=pow(temp.z, 12.0);
   r+=pow(temp.w, 3.0);


//   r+=pow(temp.x, 2.0);
//   r+=pow(temp.y, 2.0);
//   r+=pow(temp.z, 2.0);
//   r+=pow(temp.w, 2.0);

   r = 1.0f+mix(0.0, r, g_rFactor);
   sinphi = sin(phi*0.999+0.0005*3.141952);
   p.x = r*sinphi*cos(theta);
   p.y = r*cos(phi);
   p.z = r*sinphi*sin(theta);
   return p;
}



float getMedusaScale(float posY) {
    //return (1.0+(-14.0+10.0*sin(g_time*3.0))*smoothstep(0.0, 4.0, pow(0.495-posY, 2.0)));
    return (1.0+(-1.0+3.80*sin(g_time*3.0+g_jellyAnimOfs))*pow(0.495-posY, 3.0));
}

void main() {
    gl_Position = vec4(vertexPosition, 1.0);
/*
    gl_Position.xyz *= getMedusaScale(gl_Position.y);
    gl_Position.y -= getMedusaScale(-0.15)*0.05;
*/

    float th = getTheta(gl_Position.xyz);
    float ph = getPhi(gl_Position.xyz);

    gl_Position.xyz = calcSH(gl_Position.xyz, th, ph, g_time*1.0, g_time*0.5);


    normal = vertexNormal;
    tangent = vertexTangent;
    uv = vertexUV;
}
