import QtQuick 2.0
import QtGraphicalEffects 1.0
import "./_SharedQML"
import AdaptDemoSystem 1.0

Scene {
    id: debugInfo
    // property bool bDebugTexts: true
    property bool bDebugTexts: false

    property string name: "DebugInfo"
    property string sceneName: ""
    property string sceneDir: "fx/"+sceneName+"/"
    property bool bSceneEnabled: true


    onSetSceneName: {
        sceneName = sn;
        name = sn;
    }
    sceneEnabled: bSceneEnabled
    enabled: bSceneEnabled

    property real mX: 0.0
    property real mY: 0.0
    anchors.fill: parent

    MouseArea {
        anchors.fill: parent
        hoverEnabled: true
        onMouseXChanged: {
            debugInfo.mX = mouseX;
            debugInfo.mY = mouseY;
            console.log("mouse at:"+mouseX+","+mouseY)
        }
        onMouseYChanged: {
            debugInfo.mX = mouseX;
            debugInfo.mY = mouseY;
        }
    }


//    MouseArea {
//        anchors.left: parent.left
//        anchors.top: parent.top
//        width: texts.childrenRect.width
//        height: texts.childrenRect.height
//        hoverEnabled: true
//        onPressed: {
//            debugInfo.bDebugTexts = !debugInfo.bDebugTexts;
//            //console.log("pressed mouse")
//        }
//    }


    Item {
        visible: bDebugTexts
        enabled: bDebugTexts
        id: mousePos
        layer.enabled: true
        width: 1280
        height: 720
        FastBlur {
            anchors.fill: texts
            source: texts
            radius: 32
        }

        Timer {
            interval: 1000
            running: true
            repeat: true
            onTriggered: {
                var fps = (1000.0/ rocket.getFrameTimeSmooth()).toFixed()
                fpsText.text = "FPS:"+fps
            }
        }


        Timer {
            interval: 20
            running: true
            repeat: true
            onTriggered: {
                demoTime.text = "demo time:"+rocket.time.toFixed(3)
            }
        }



        Item {
            opacity: 1.0
            id: texts
            Column {
                ShadowText {
                    id: demoTime
                    text:"demo time:"+rocket.time.toFixed(3)
                }
                ShadowText {
                    id: fpsText
                }
                ShadowText {
                    id: mousePosText
                    text:"mouse pos:"+debugInfo.mX+","+debugInfo.mY
                }
                ShadowText {
                    text:"mouse norm:"+(debugInfo.mX/windowWidth*2.0-1.0).toFixed(3)+","+(debugInfo.mY/windowHeight*2.0-1.0).toFixed(3)
                }
            }
        }



    }


//    DrawItem {
//        visible: bDebugTexts
//        enabled: bDebugTexts

//        flip: false
//        itemId: mousePos
//    }

    DrawRT {
        visible: bDebugTexts
        enabled: bDebugTexts
        textureItem: mousePos
      //  textureRT: "godRays"
        flip: false
    }


}

