import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0


RocketScene {

    id: skene

    ShakyCamera {
        camShakePosAmp: sync("camera.shake.amp")
        camShakeLookAtAmp: sync("camera.shakeLookAt.amp")
        camShakeFreq: sync("camera.shake.freq")
    }

    MeshCave {
        name: "cave"
    }
    MeshDriller {
        name: "driller"
    }





    Texture {
        textureUnit: 0
        textureItem: kuvaxx
        Image {
            id: kuvaxx
            visible: false
            source: "../../images/apo-mist-9090724-357_2.png"
        }
    }
    Texture {
        textureUnit: 2
        textureItem: kuvasEnv
        Image {
            id: kuvasEnv
            visible: false
            source: "../../images/area_lights.jpg"
        }
    }
    Shader {
        file: sceneDir+"sm"
    }
    Repeater {
        model: 150
        DrawMesh {
            file: "mesh/ball5000.x"
            //file: "mesh/medusasmooth.lwo"
            //file: "mesh/medusa.lwo"
            depthTest: true
            depthWrite: false
            blendMode: "add"
            property real jellyAreaScale: sync("urpoAreaScale")
            enabled: index<sync("urpoNum")
            property real jellySize: 0.0
            onEnabledChanged: {
                if (enabled) {
                    jellySize = 1.0
                } else {
                    jellySize = 0.0
                }
            }
            Behavior on jellySize {
                NumberAnimation { duration: 1000 }
            }

            Pos {
                x: Math.sin(index*1.2)*2.0*jellyAreaScale
                y: Math.cos(index*1.7123)*2.0*jellyAreaScale
                z: Math.cos(index*2.3+Math.sin(index*0.92))*1.0*jellyAreaScale
            }
            Rot { d: rocket.time*7.8+index*36.7*0.2139; ax: 1.0; ay: 0.50; az: 0.0 }
            Sca { s: sync("urpoScale")*jellySize; x: 1.0; y:1.5; z:1.0 }
            ShaderParam {
                paramName: "g_urpoAnimOfs"
                paramValue: sync("urpoAnimOfs")+index*1.7731
            }
        }
    }


/*
    Repeater {
        model: 8
        delegate: MeshDriller {
            name: "kulmaKivi1"
            file: "mesh/ball5000.x"
            property string gsName: "driller_"+(index+1)
            posX: getSavePointX(gsName)*0.20
            posY: getSavePointY(gsName)*0.20
            posZ: getSavePointZ(gsName)*0.20
            scale: 1.0
        }
    }
*/
//    MeshBasic {
//        name: "basic"
//    }

//    MeshPlane {
//        name: "plane"
//    }


    DrawOverlayMul {
        posX: sync("ovl.posX")+getSavePointX2D("driller")
        posY: sync("ovl.posY")+getSavePointY2D("driller")
        overlayScale: sync("ovl.scale")
        overlayAlpha: sync("ovl.alpha")
        file: "adapt_logo2_full.png"
    }


    Vignette {
        posX: getSavePointX2D("driller")
        posY: getSavePointY2D("driller")
    }

    GodRay {
        godRayX: getSavePointX2D("driller")
        godRayY: getSavePointY2D("driller")
    }
    Tonemap {
    }


}
