import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0


RocketScene {

    id: skene

    ShakyCamera {
        camShakePosAmp: sync("camera.shake.amp")
        camShakeLookAtAmp: sync("camera.shakeLookAt.amp")
        camShakeFreq: sync("camera.shake.freq")
    }


    MeshSun {
        name: "sun"
    }

    MeshBeach {
        name: "beach"
    }
    MeshPalmu {
        name: "palmu1"
    }
    MeshPalmu {
        name: "palmu2"
    }
    MeshWesi {
        name: "wesi"
    }

//    MeshBasic {
//        name: "basic"
//    }

//    MeshPlane {
//        name: "plane"
//    }

    Texture {
        textureUnit: 0
        textureItem: kuvaxx
        Image {
            id: kuvaxx
            visible: false
            source: "../../images/apo-mist-9090724-357_2.png"
        }
    }
    Texture {
        textureUnit: 2
        textureItem: kuvasEnv
        Image {
            id: kuvasEnv
            visible: false
            source: "../../images/area_lights.jpg"
        }
    }
    Shader {
        file: sceneDir+"sm"
    }
    Repeater {
        model: 150
        DrawMesh {
            file: "mesh/sileakivi70kpoly.lwo"
            //file: "mesh/medusasmooth.lwo"
            //file: "mesh/medusa.lwo"
            depthTest: true
            depthWrite: false
            blendMode: "add"
            property real jellyAreaScale: sync("kiviAreaScale")
            enabled: index<sync("kiviNum")
            property real jellySize: 0.0
            onEnabledChanged: {
                if (enabled) {
                    jellySize = 1.0
                } else {
                    jellySize = 0.0
                }
            }
            Behavior on jellySize {
                NumberAnimation { duration: 1000 }
            }

            Pos {
                x: Math.sin(index*1.2)*2.0*jellyAreaScale
                y: Math.cos(index*1.7123)*2.0*jellyAreaScale
                z: Math.cos(index*2.3+Math.sin(index*0.92))*1.0*jellyAreaScale
            }
            Rot { d: rocket.time*7.8+index*36.7*0.2139; ax: 1.0; ay: 0.50; az: 0.0 }
            Sca { s: sync("kiviScale")*jellySize; x: 1.0; y:1.5; z:1.0 }
            ShaderParam {
                paramName: "g_kiviAnimOfs"
                paramValue: sync("kiviAnimOfs")+index*1.7731
            }
        }
    }



    Vignette {
        posX: 0.0 //getSavePointX2D("sun")
        posY: 0.0 //getSavePointY2D("sun")
    }

    GodRay {
        godRayX: getSavePointX2D("sun")
        godRayY: getSavePointY2D("sun")
    }
    Tonemap {
    }


}
