#version 430


layout (location=0) in vec3 vertexPosition;
layout (location=1) in vec3 vertexNormal;
layout (location=2) in vec2 vertexUV;
layout (location=3) in vec3 vertexTangent;
out vec3 normal;
out vec2 uv;
out vec3 tangent;
out vec4 origPos;
out vec3 posInV;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;


vec4 rotateXZ(vec4 p, float a) {
    vec4 r = p;
    r.x = cos(a)*p.x - sin(a)*p.z;
    r.z = sin(a)*p.x + cos(a)*p.z;
    return r;
}

vec3 rotateXZ3(vec3 p, float a) {
    return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
    vec4 r = p;
    r.x = cos(a)*p.x - sin(a)*p.y;
    r.y = sin(a)*p.x + cos(a)*p.y;
    return r;
}

vec3 rotateXY3(vec3 p, float a) {
    vec3 r = p;
    r.x = cos(a)*p.x - sin(a)*p.y;
    r.y = sin(a)*p.x + cos(a)*p.y;
    return r;
}

vec4 rotateYZ(vec4 p, float a) {
    vec4 r = p;
    r.y = cos(a)*p.y - sin(a)*p.z;
    r.z = sin(a)*p.y + cos(a)*p.z;
    return r;
}
vec3 rotateYZ3(vec3 p, float a) {
    vec3 r = p;
    r.y = cos(a)*p.y - sin(a)*p.z;
    r.z = sin(a)*p.y + cos(a)*p.z;
    return r;
}


float atanSafe(float y, float x) {
 float ret=0.0;
        if (x!=0.0) {
                if (x>0.0) {
                        ret=atan(y/x);
                } else	{
                        ret=atan(y/x)+3.141592;
                }
        } else {
                if (y>=0.0) {
                        ret=0.5*3.141592;
                } else {
                        ret=-0.5*3.141592;
                }
        }
 return ret;
}


float getTheta(vec3 v) {
  float theta = acos(v.z/sqrt(dot(v,v)));
  return theta;
}
float getPhi(vec3 v) {
  float phi = atan(v.y,v.x);
  return phi;
}

vec2 getSphericalUV(vec3 v) {
    return vec2(getTheta(v)/(1.0*3.141592)+0.0, -getPhi(v)/(2.0*3.141592)+0.50);
}



void main() {
    gl_Position = vec4(vertexPosition*0.20, 1.0);
    vec4 posse = gl_Position*1.0;
    origPos = posse*1.0;

    float timeMul = 0.10;

    float times = g_time*0.1*timeMul;
    float times2 = g_time*0.2*timeMul;
    float times3 = g_time*timeMul;

    normal = vertexNormal;
    tangent = vertexTangent;

    float yk = 1.0;
    vec4 pos1 = rotateXZ(gl_Position, -times3*0.20+yk*posse.y*sin(times2)+0.0*posse.z);
    vec4 pos2 = rotateXZ(gl_Position, -(times3+0.1)*0.20+yk*posse.y*sin(times2+0.02)+0.0*posse.z);
    origPos = pos2-pos1;

    posInV = vertexPosition;

   // uv = vertexUV;
   // uv = -uv;
    uv = getSphericalUV(vertexPosition);
}


