import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0


RocketScene {

    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: sync("camera.upX")
        upY: sync("camera.upY")
        upZ: sync("camera.upZ")
    }

//    Shader {
//        file: sceneDir+"smBg"
//    }
//    Texture {
//        textureUnit: 0
//        textureItem: kuva1
//        Image {
//            id: kuva1
//            visible: false
//            source: "_SK57414.png"
//        }
//    }
//    Texture {
//        textureUnit: 1
//        textureItem: kuva2
//        Image {
//            id: kuva2
//            visible: false
//            source: "_SK57414_normal.png"
//        }
//    }

    SetMaterial {
        shader: sceneDir+"smBg"
        texture0: sceneDir+"_SK57414.png"
        texture1: sceneDir+"_SK57414_normal.png"
    }

    DrawMesh {
//        Clear { cR: 0.0; cG: 0.0; cB: 0.0 }

        property string name: "bg"
        file: "mesh/aivob.x"
        depthTest: true
        depthWrite: true
        Rot { d: 1.0; ax: 0.0; ay: 1.0; az: 0.0 }
        Sca { s: 0.0; y: 1.0; }
        ShaderParam {
            paramName: "g_uvOfsX"
            paramValue: sync("uvOfsX")+rocket.time*0.0
        }
    }


    Texture {
        layer.enabled: true
        textureUnit: 0
        textureItem: particleTexture
//        width: 1280
//        height: 720
        Image {
            layer.enabled: true

            //            width: 1280
//            height: 720
            anchors.fill: parent
            id: particleTexture
        //    visible: false
           // source: "noisep1s.png"
            //source: "../../images/stars2_blue.png"
           source: "bokeh5.png"
            //source: "../../images/apo-mist-9090724-357_2.png"
        }
    }
    Texture {
        textureUnit: 1
        textureItem: particleNoise
        Image {
            id: particleNoise
            visible: false
            source: "random16.png"
        }
    }
    Texture {
        textureUnit: 2
        textureItem: particleEmitShape
        Image {
            id: particleEmitShape
            visible: false
            source: "Levikset.png"
            //source: "bokeh5.png"
        }
    }
    Texture {
        textureUnit: 3
        textureItem: particleEnv
        Image {
            id: particleEnv
            visible: false
            //source: "area_lights.jpg"
            source: "Bright-roof-multi.jpg"
            //source: "PeaceGardens_01_LDR.jpg"
            //source: "bokeh5.png"
        }
    }



    // --------------------------------------
    // ADVANCE PARTICLE SIMULATIONS
    // --------------------------------------


    property string shaderVaryings: "vec3 posG; vec2 uvG; vec3 velG; vec3 colG; float ageG;"
//    property string shaderVaryings: "vec3 posG; vec2 uvG;"
    Shader {
        file: sceneDir+"ssPartTrans"
        tfVaryings: shaderVaryings
    }
    DrawVB {
        enabled: true
        type: "pointGrid"
        property string name: "partSim15"
        vboId: sceneName+name
        reset: sync(name+".reset")

        tfVaryings: shaderVaryings

        gridWidth: 128
        gridHeight: 128
        depthTest: false
        depthWrite: false
        ShaderParam {
            paramName: "g_pikselos"
            paramValue: sync("pikselos")
        }
    }

//    DrawVB {
//        enabled: true
//        type: "pointGrid"
//        vboId: sceneName+"partSim18"
//        property string name: vboId
//        reset: sync(name+"reset")
//        gridWidth: 1000
//        gridHeight: 1000
//        depthTest: false
//        depthWrite: false
//        ShaderParam {
//            paramName: "g_pikselos"
//            paramValue: sync("pikselos")
//        }
//    }




    // --------------------------------------
    // RENDER PARTICLES
    // --------------------------------------
    Shader {
        file: sceneDir+"ssPart"
    }
    DrawVB {
        enabled: true
        type: "pointGridDraw"
        property string name: "partSim15"
        vboId: sceneName+name
        depthTest: true
        depthWrite: false
        ShaderParam {
            paramName: "g_pikselos"
            paramValue: sync("pikselos")
        }
        ShaderParam {
            paramName: "g_partSize"
            paramValue: 1.0
        }

    }

//        DrawVB {
//            enabled: true
//            type: "pointGridDraw"
//            vboId: sceneName+"partSim18"
//    //        gridWidth: partW
//    //        gridHeight: partH
//            depthTest: true
//            depthWrite: false
//            ShaderParam {
//                paramName: "g_pikselos"
//                paramValue: sync("pikselos")
//            }
//            ShaderParam {
//                paramName: "g_partSize"
//                paramValue: 0.50
//            }
//        }


    Vignette {
    }

    GodRay {
        godRayX: getSavePointX2D("valopallo")
        godRayY: getSavePointY2D("valopallo")
    }
    Tonemap {
    }

}
